package com.digiwin.athena.eoc.sdk.manager;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.common.sdk.manager.util.DwHttpResultParseUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.eoc.sdk.meta.dto.EocResultBDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.request.MEocEmpInfoReqDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.request.MEocEmpInfosReqDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.empinfo.MEocEmpDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import org.springframework.core.ParameterizedTypeReference;

import java.util.List;

import static com.digiwin.athena.eoc.sdk.meta.constants.EocErrorCode.P_EOC_500_5001;
import static com.digiwin.athena.eoc.sdk.meta.constants.EocErrorCode.P_EOC_500_5004;

/**
 * eoc 获取员工信息相关api
 *
 * @author gengwei
 * @since 2024/8/15 09:17
 */
public class EocEmpInfoManager {

    private static String getEocUri() {
        return JaProperty.get("eoc.uri");
    }

    private static final ParameterizedTypeReference<EocResultBDTO<List<MEocEmpDTO>>> EOC_EMPLOYEE_INFOS_TYPE = new ParameterizedTypeReference<EocResultBDTO<List<MEocEmpDTO>>>() {
    };

    private static final ParameterizedTypeReference<EocResultBDTO<MEocEmpDTO>> EOC_EMPLOYEE_INFO_TYPE = new ParameterizedTypeReference<EocResultBDTO<MEocEmpDTO>>() {
    };

    /**
     * 根据用户id/员工id批量获取用户信息
     */
    public static final String EMP_INFOS_URL = getEocUri() + "/api/eoc/v2/emp/infos";

    /**
     * 根据用户id/员工id批量获取用户信息
     */
    public static final String EMP_INFO_URL = getEocUri() + "/api/eoc/v2/emp/info";

    /**
     * 批量获取人员信息
     *
     * @return {@link EocResultBDTO<List<MEocEmpDTO>>}
     **/
    public static List<MEocEmpDTO> getEmpInfos(MEocEmpInfosReqDTO req) {
        //参数校验失败在调用EOC前抛出异常JaException
        if (JaCollectionUtil.isEmpty(req.getEmpIds())
                && JaCollectionUtil.isEmpty(req.getUserIds())
        ) {
            throw BusinessException.buildErrorCode(P_EOC_500_5001);
        }
        return DwHttpResultParseUtil.parse(DwSpringHttpUtil.post(EMP_INFOS_URL, req, EOC_EMPLOYEE_INFOS_TYPE));
    }

    /**
     * 获取人员信息
     *
     * @param req
     * @return {@link EocResultBDTO<List<MEocEmpDTO>>}
     **/
    public static MEocEmpDTO getEmpInfo(MEocEmpInfoReqDTO req) {
        //参数校验失败在调用EOC前抛出异常JaException
        if (JaStringUtil.isEmpty(req.getId())
                && JaStringUtil.isEmpty(req.getEmpId())
                && JaStringUtil.isEmpty(req.getUserId())
                && null == req.getSid()
        ) {
            throw BusinessException.buildErrorCode(P_EOC_500_5004);
        }
        return DwHttpResultParseUtil.parse(DwSpringHttpUtil.post(EMP_INFO_URL, req, EOC_EMPLOYEE_INFO_TYPE));
    }
}

