package com.digiwin.athena.eoc.sdk.meta.dto;

import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import static com.digiwin.athena.common.sdk.manager.meta.constants.CommonErrorCode.P_AI_500_5000;

/**
 * eoc 返回的数据格式
 *
 * @author gengwei
 * @since 2024/8/15 09:28
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class EocResultBDTO<T> implements JaResultParseHandler<T> {

    private String timestamp;
    private String code;
    private String message;
    private String path;
    private Boolean success;
    private String sourceId;
    private String errorType;
    private String errorCode;
    private String errorMessage;
    private String expId;

    private T data;

    @Override
    public Boolean success() {
        return success;
    }

    @Override
    public String code() {
        return JaStringUtil.isEmpty(code) ? (JaStringUtil.isEmpty(errorCode) ? P_AI_500_5000 : errorCode) : code;
    }

    @Override
    public String message() {
        return JaStringUtil.isEmpty(message) ? errorMessage : message;
    }

    @Override
    public T data() {
        return getData();
    }

    public static void main(String[] args) {
        Boolean success = null;
        System.out.println(success);

    }
}
