package com.digiwin.athena.eoc.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.List;


@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EocDeptDTO {

    private int code;
    private String message;
    private boolean success;
    private DataObject data;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class DataObject {
        private Integer total;
        private List<Dept> list;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Dept {
        private Long sid;
        private String id;
        private String name;
        private String directorId;
        private String directorName;
        private List<EmployeeDTO> emps;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class EmployeeDTO {

        private Long sid;
        private String id;
        private String name;
        private Boolean mainDept;
        private Boolean status;
        private String agentId;
        private String agentName;
        private LocalDateTime agentBeginDate;
        private LocalDateTime agentEndDate;

    }
}
