package com.digiwin.athena.gmc.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

/**
 * /api/eoc/v2/dept/emps 部门及其子部门员工的实体
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EocDeptEmployeeDTO {

    /**
     * 必有字段  备注：员工id
     */
    private String empId;

    /**
     * 必有字段  备注：员工名称
     */
    private String empName;

    /**
     * 必有字段  备注：部门id
     */
    private String deptId;

    /**
     * 必有字段  备注：部门名称
     */
    private String deptName;

    /**
     * 可有字段  备注：父部门id
     */
    private String parentDeptId;

    /**
     * 可有字段  备注：父部门名称
     */
    private String parentDeptName;

    private String userId;

    private String userName;

    private Boolean status;

}
