package com.digiwin.athena.gmc.sdk.manager;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.gmc.sdk.meta.dto.GmcResultDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.Map;

/**
 * eoc 通用api
 *
 * @author gengwei
 * @since 2024/8/20 10:18
 */
public class GmcManager {

    private static String getGmcUri() {
        return JaProperty.get("gmc.uri");
    }


    private static final ParameterizedTypeReference<GmcResultDTO<JSONArray>> JSONArrayType = new ParameterizedTypeReference<GmcResultDTO<JSONArray>>() {
    };

    /**
     * 通过appcode获取钉钉suiteKey
     */
    public static final String GMC_GOODS_MAPPINGS_URL = getGmcUri() + "/api/gmc/v2/goods/mappings?code={code}";


    public static GmcResultDTO<JSONArray> queryAppAuthInfo(AuthoredUser user, String appCode) {
        Map<String, Object> param = new HashMap<>();
        param.put("code", appCode);
        return DwSpringHttpUtil.get(GMC_GOODS_MAPPINGS_URL, JSONArrayType, httpHeaders -> {
            httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, user.getToken());
            httpHeaders.set(DwHttpHeaderConstants.Header_App_Token, DwHttpHeaderConstants.App_Token_Athena);
        }, param);
    }


}
