package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.action;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Map;

/**
 * 前端执行的Action实体
 * 例如执行保存、更新、删除等action
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class SubmitActionRespDTO implements Serializable {

    /**
     * 主ACTION
     */
    private SubmitAction action;

    /**
     * Action的数据
     */
    private Map<String, Object> data;

    /**
     * 补充信息，用于scs后端分页查询校验处理
     */
    private AdditionalInfoRespDTO additionalInfo;

    /**
     * 实际操作的用户
     */
    private AuthoredUser operateAuthoredUser;

    /**
     * activityCode
     */
    private String activityCode;
}
