package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 交付设计器的待办工作台设置
 */
@Getter
@Setter
public class WorkbenchSettingRespDTO {

    private String id;

    private String tenantId;

    private WSConfigType configType;

    private WSPageCode pageCode;

    /**
     * 条件配置
     */
    private List<WSConditionVO> condition;

    /**
     * 排序下，默认的条件
     */
    private List<WSConditionVO> defaultCondition;

    @Getter
    @Setter
    public static class WSConditionVO {
        /**
         * 名称
         */
        private String aliasName;
        /**
         * 代号
         */
        private String aliasCode;
        /**
         * 类型
         */
        private String dataType;

        private SourceType sourceType;

        private List<PointInTime> pointInTime;

        private List<Dimensionality> dimensionality;
        /**
         * 是否默认启用
         */
        private Boolean defaultEffective;

        /**
         * 是否启用
         */
        private Boolean enable;

        /**
         * 分组下，是否默认分组项
         */
        private Boolean defaultGroup;

        /**
         * 生效范围
         */
        private List<ConditionScopeVO> conditionScope;
    }

    public enum WSConfigType {
        order,//排序
        filter,//筛选
        group;//分组
    }

    public enum WSPageCode {
        task,//任务
        project;//项目

    }

    public enum Dimensionality {
        month,
        year
    }

    public enum PointInTime {
        begin,//项目开始
        end//项目结束
    }

    public enum SourceType {
        customer,//自定义
        system//系统级
    }

    @Getter
    @Setter
    public static class ConditionScopeVO {

        private String appCode;
        /**
         * 任务名称或项目名称
         */
        private String name;
        /**
         * 原始编码
         */
        private String fieldCode;

        /**
         * 任务和项目编码
         */
        private String code;
    }

}
