package com.digiwin.athena.knowledgegraph.sdk.manager;

import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.knowledgegraph.sdk.meta.constants.KgConstants;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.KgResultDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.request.ActivityDefinitionListReqDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.request.TaskCardFieldReqDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.kg.TaskCardFieldRespDTO;
import com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap.*;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * kg 任务相关api
 *
 * @author gengwei
 * @since 2024/8/13 13:36
 */
public class KnowledgegraphManager {


    /**
     * 获取 themeMap.knowledgeGraphUri
     *
     * @return {@link String}
     * @author gengwei
     * @since 2024/8/20 17:50
     **/
    private static String getKnowledgeGraphUri() {
        return JaProperty.get("themeMap.uri");
    }


    private static String getDataMapUri() {
        return JaProperty.get("themeMap.dataMapUri");
    }



    private static final ParameterizedTypeReference<KgResultDTO<List<TmAppRespDTO>>> TmAppDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmAppRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<String>>> StringListType = new ParameterizedTypeReference<KgResultDTO<List<String>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<TmActivityResponseDTO>>> TmActivityResponseDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmActivityResponseDTO>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<TmActivityResponseDTO>> TmActivityResponseDTOType = new ParameterizedTypeReference<KgResultDTO<TmActivityResponseDTO>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<TmTaskDefineResponseDTO>>> TmTaskDefineResponseDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmTaskDefineResponseDTO>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<Map<String, Map<Object, Object>>>> MapMapType = new ParameterizedTypeReference<KgResultDTO<Map<String, Map<Object, Object>>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<TmReportRespDTO>>> TmReportRespDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TmReportRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<Map<String, Object>>> MapType = new ParameterizedTypeReference<KgResultDTO<Map<String, Object>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<TmTaskDefineResponseDTO>> TmTaskDefineResponseDTOType = new ParameterizedTypeReference<KgResultDTO<TmTaskDefineResponseDTO>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<Boolean>> BooleanType = new ParameterizedTypeReference<KgResultDTO<Boolean>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<TaskCardFieldRespDTO>>> TaskCardFieldRespDTOListType = new ParameterizedTypeReference<KgResultDTO<List<TaskCardFieldRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<BusinessKeyDTO>> BusinessKeyDTOType = new ParameterizedTypeReference<KgResultDTO<BusinessKeyDTO>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<WorkbenchSettingRespDTO>> WorkbenchSettingRespDTOType = new ParameterizedTypeReference<KgResultDTO<WorkbenchSettingRespDTO>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<BaseItemRespDTO>>> BaseItemRespDTOListType = new ParameterizedTypeReference<KgResultDTO<List<BaseItemRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<KgResultDTO<List<ImportAndExportConfigRespDTO>>> ImportAndExportDTOListType = new ParameterizedTypeReference<KgResultDTO<List<ImportAndExportConfigRespDTO>>>() {
    };


    /**
     * 用appCode获取应用信息
     */
  //  public static final String TASK_APPLICATION_RELATION_URL = getDataMapUri()+ "/restful/standard/datamap/app/applicationByTypeAndCodeList";
    public static final String TASK_APPLICATION_RELATION_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/applicationRelation";
    /**
     * 根据code获取所有应用
     */
    public static final String APP_CODE_BY_TASK_CODE_URL = getDataMapUri() + "/restful/standard/datamap/app/appCodeByTaskCode?code={code}";

    /**
     * 根据 应用code 获取其包含的项目code列表
     */
    public static final String RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_TASK_CODE_APP_CODE_URL = getDataMapUri() + "/restful/standard/datamap/app/taskCode?appCode={appCode}";

    /**
     * 批量获取任务的转派定义
     */
    public static final String BATCH_ACTIVITY_BASIC_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/batch/activityBasic";

    /**
     * 批量获取项目的转派定义
     */
    public static final String BATCH_TASK_BASIC_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/batch/taskBasic";

    /**
     * 根据活动id获取活动定义2（任务卡定义）
     */
    public static final String TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL = getDataMapUri() + "/restful/standard/datamap/task/activityDefinitionWithMergeRule?taskId={taskId}&activityId={activityId}&pageCode={pageCode}";

    /**
     * 根据活动id获取活动定义（任务卡定义）
     */
    public static final String TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE_URL = getDataMapUri() + "/restful/standard/datamap/record/activityDefinition?activityId={activityId}&pageCode={pageCode}";

    public static final String TASK_ACTIVITY_DEFINITION_LIST_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/activityDefinitionList";

    /**
     * 获取任务的关联任务code
     */
    public static final String TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL = getDataMapUri() + "/restful/standard/datamap/view/activityStartTargetCode";

    /**
     * 获取报表附属的任务或者项目作业列表
     */
    public static final String TASK_BIZS_BY_REPORT_CODE_NTYPE_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/bizsByReportCodeNType";

    /**
     * 查询规则
     */
    public static final String TASK_CARD_OPTIMIZE_RULES_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/cardConfig";

    /**
     * 查询待办列表的card config
     */
    public static final String CARD_CONFIG_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/cardConfigByType";

    /**
     * 获取指定任务的任务定义（项目卡定义）
     */
    public static final String TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID_URL = getDataMapUri() + "/restful/standard/datamap/task/definitionByTaskId?taskId={taskId}";

    /**
     * 查询待办列表查询条件
     */
    public static final String QUERY_CONDITION_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/queryCondition";

    /**
     * 根据项目/任务code 获取挂载的报表概要信息列表
     */
    public static final String TASK_REPORTS_BY_BIZ_CODE_NTYPE_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/reportsByBizCodeNType";

    public static final String TASK_ORDER_STATUS_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/taskOrderStatus";

    public static final String VIEW_TASKCARDFIELD_URL = getDataMapUri() + "/restful/standard/datamap/view/taskCardField";

    /**
     * 获取项目/任务的业务主键
     */
    public static final String VIEW_BK_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/view/bk";

    /**
     * 根据emailCode和语言别，获取邮件模板ID
     */
    public static final String VIEW_EMAIL_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/view/email";

    /**
     * 待办工作台配置
     */
    public static final String WORKBENCH_SETTING_URL = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/workbenchSetting/workbenchSetting?pageCode={pageCode}&configType={configType}&appCondition={appCondition}";


    /**
     * 基础资料录入
     */
    public static final String ACTIVITIES_BY_PATTERN = getDataMapUri() + "/restful/standard/datamap/record/activitiesAndSortByPattern?pattern=DATA_ENTRY";


    /**
     * 基础资料导入导出配置项
     */
    public static final String IMPORT_AND_EXPORT_CONFIG = getKnowledgeGraphUri() + "/restful/service/knowledgegraph/task/ExportAndImportConfig";



    /**
     * 获取基础资料导入导出配置项
     * @return
     */
    public static KgResultDTO<List<ImportAndExportConfigRespDTO>> getImportAndExportConfig() {
        Map<String, Object> paramMap = new HashMap<>();
        return DwSpringHttpUtil.get(IMPORT_AND_EXPORT_CONFIG, ImportAndExportDTOListType, paramMap);
    }


    /**
     * 获取基础资料
     * @return
     */
    public static KgResultDTO<List<BaseItemRespDTO>> getActivitiesByPattern() {
        //查询参数
        Map<String, Object> paramMap = new HashMap<>();
        return DwSpringHttpUtil.get(ACTIVITIES_BY_PATTERN, BaseItemRespDTOListType, paramMap);

    }


    /**
     * 用appCode获取应用信息
     *
     * @return {@link KgResultDTO<List<TmAppRespDTO>>}
     * @author gengwei
     * @since 2024/8/20 17:41
     **/
    public static KgResultDTO<List<TmAppRespDTO>> getApplicationRelation(String type, List<String> codeList) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("type", type);
        params.put("codes", codeList);

        return DwSpringHttpUtil.post(TASK_APPLICATION_RELATION_URL, params, TmAppDTOListType);

    }

    /**
     * 根据code获取所有应用
     */
    public static KgResultDTO<List<TmAppRespDTO>> getAppInfos(String code) {
        //查询参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("code", code);
        return DwSpringHttpUtil.get(APP_CODE_BY_TASK_CODE_URL, TmAppDTOListType, paramMap);

    }

    /**
     * 根据 应用code 获取其包含的项目code列表
     */
    public static KgResultDTO<List<String>> getTaskCodeListByAppCode(String appCode) {
        Map<String, Object> param = new HashMap<>();
        param.put("appCode", appCode);

        return DwSpringHttpUtil.get(RESTFUL_SERVICE_KNOWLEDGEGRAPH_APP_TASK_CODE_APP_CODE_URL, StringListType, param);
    }

    /**
     * 批量获取任务的转派定义
     *
     * @param activities map结构 {"taskCode":"task_RE_Preparation","activityCode":"purchaseApproval"}
     */
    public static KgResultDTO<List<TmActivityResponseDTO>> getBatchActivityAssigns(List<Map<Object, Object>> activities) {
        Map<String, Object> rootPara = new HashMap<>();
        Map<String, Object> qPara = new HashMap<>();
        qPara.put("taskAndActivities", activities);
        rootPara.put("q", qPara);

        return DwSpringHttpUtil.post(BATCH_ACTIVITY_BASIC_URL, rootPara, TmActivityResponseDTOListType);

    }


    /**
     * 批量获取项目的转派定义
     *
     * @param taskCodes 项目code列表
     */
    public static KgResultDTO<List<TmTaskDefineResponseDTO>> getBatchTaskAssigns(List<String> taskCodes) {
        Map<String, Object> rootPara = new HashMap<>();
        Map<String, Object> qPara = new HashMap<>();
        qPara.put("codes", taskCodes);
        rootPara.put("q", qPara);
        return DwSpringHttpUtil.post(BATCH_TASK_BASIC_URL, rootPara, TmTaskDefineResponseDTOListType);
    }

    public static KgResultDTO<TmActivityResponseDTO> getActivityAction(String tmTaskId, String tmActivityId, String pageCode) {

        String url = TASK_ACTIVITY_DEFINITION_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL;
        if (KgConstants.VIRTUAL_PROJECT.equals(tmTaskId)) {
            url = TASK_ACTIVITY_DEFINITION_ACTIVITY_ID_PAGE_CODE_URL;
        }
        Map<String, Object> param = new HashMap<>(3);
        param.put("taskId", tmTaskId);
        param.put("activityId", tmActivityId);
        param.put("pageCode", pageCode);
        return DwSpringHttpUtil.get(url, TmActivityResponseDTOType, param);
    }

    /**
     * 根据 tmTaskId，activityIds，pageCode 查询活动定义
     *
     * @return {@link KgResultDTO<Map<String,Map>>}
     * @author gengwei
     * @since 2024/9/2 13:45
     **/
    public static KgResultDTO<Map<String, Map<Object, Object>>> getActivityDefinitionListByPageCode(ActivityDefinitionListReqDTO activityDefinitionListReqDTO) {
        return DwSpringHttpUtil.post(TASK_ACTIVITY_DEFINITION_LIST_URL, activityDefinitionListReqDTO, MapMapType);
    }


    /**
     * 获取任务的关联任务code
     */
    public static KgResultDTO<TmActivityResponseDTO> getActivityTargetCode(String tmTaskId, String tmActivityId, String pageCode) {
        Map<String, Object> param = new HashMap<>(3);
        param.put("projectCode", tmTaskId);
        param.put("taskCode", tmActivityId);
        param.put("pageCode", pageCode);

        return DwSpringHttpUtil.post(TASK_ACTIVITY_START_TARGET_CODE_TASK_ID_ACTIVITY_ID_PAGE_CODE_URL, param,TmActivityResponseDTOType);

    }

    /**
     * 获取报表附属的任务或者项目作业列表
     *
     * @param reportCode 报表tmActivityId
     * @param type       1：项目，2：任务
     */
    public static KgResultDTO<List<TmReportRespDTO>> getReportRelativeActivities(String reportCode, Integer type) {
        String url = UriComponentsBuilder.fromHttpUrl(TASK_BIZS_BY_REPORT_CODE_NTYPE_URL)
                .queryParam("reportCode", reportCode)
                .queryParam("type", type)
                .build()
                .toUriString();
        return DwSpringHttpUtil.get(url, TmReportRespDTOListType);
    }


    public static KgResultDTO<Map<String, Object>> getTaskCardOptimizeRules() {
        return DwSpringHttpUtil.get(TASK_CARD_OPTIMIZE_RULES_URL, MapType);
    }


    public static KgResultDTO<Map<String, Object>> postCardConfigByType(String pageCode, Set<String> codes) {
        Map<String, Object> cardConfigQuery = new HashMap<>(2);
        cardConfigQuery.put("pageCode", pageCode);
        cardConfigQuery.put("codes", codes);
        Map<String, Object> body = new HashMap<>(1);
        body.put("cardConfigQuery", cardConfigQuery);
        return DwSpringHttpUtil.post(CARD_CONFIG_URL, body, MapType);
    }


    /**
     * 获取指定任务的任务定义
     */
    public static KgResultDTO<TmTaskDefineResponseDTO> getTask(String taskId) {
        Map<String, Object> param = new HashMap<>();
        param.put("taskId", taskId);
        return DwSpringHttpUtil.get(TASK_DEFINITION_WITH_MULTI_LANGUAGE_TASK_ID_URL, TmTaskDefineResponseDTOType, param);
    }

    public static KgResultDTO<Map<String, Object>> getQueryCondition(String pageCode, String conditionType) {
        Map<String, Object> map = new HashMap<>(2);
        map.put("pageCode", pageCode);
        map.put("configType", conditionType);

        Map<String, Object> body = new HashMap<>(1);
        body.put("cardConditionQuery", map);
        return DwSpringHttpUtil.post(QUERY_CONDITION_URL, body, MapType);

    }


    /**
     * 根据项目/任务code 获取挂载的报表概要信息列表
     */
    public static KgResultDTO<List<TmReportRespDTO>> getReportSummaryList(String bizCode, Integer type, String userId) {
        String url = UriComponentsBuilder.fromHttpUrl(TASK_REPORTS_BY_BIZ_CODE_NTYPE_URL)
                .queryParam("bizCode", bizCode)
                .queryParam("type", type)
                .queryParam("userId", userId)
                .build()
                .toUriString();

        return DwSpringHttpUtil.get(url, TmReportRespDTOListType);
    }


    public static KgResultDTO<Boolean> getOrderDisplay() {
        return DwSpringHttpUtil.get(TASK_ORDER_STATUS_URL, BooleanType);
    }


    public static KgResultDTO<List<TaskCardFieldRespDTO>> taskCardFieldRequest(TaskCardFieldReqDTO taskCardFieldRequest) {
        Map<String, Object> body = new HashMap<>();
        body.put("taskCardFieldRequest", taskCardFieldRequest);
        return DwSpringHttpUtil.post(VIEW_TASKCARDFIELD_URL, body, TaskCardFieldRespDTOListType);
    }


    /**
     * 获取项目/任务的业务主键
     * TODO 改成DTO
     */
    public static KgResultDTO<BusinessKeyDTO> getTaskActivityBK(String objectType, String objectValue) {
        Map<String, String> request = new HashMap<>(2);
        request.put("objectType", objectType);
        request.put("objectValue", objectValue);
        //请求地址
        Map<String, Map<String, String>> body = new HashMap<>(1);
        body.put("request", request);
        return DwSpringHttpUtil.post(VIEW_BK_URL, body, BusinessKeyDTOType);
    }

    /**
     * 根据emailCode和语言别，获取邮件模板ID
     * majianfu 迭代22/需求ID：1854 2021-11-29
     *
     * @return 请求成功，则返回邮件模板ID（可能为null）；请求失败，则抛出599 BusinessException
     */
    public static KgResultDTO<Map<String, Object>> getEmailEventIdByLocale(String emailCode, String locale) {
        String url = UriComponentsBuilder.fromHttpUrl(VIEW_EMAIL_URL)
                .queryParam("emailCode", emailCode)
                .queryParam("locale", locale)
                .build().toUriString();
        return DwSpringHttpUtil.get(url, MapType);
    }

    /**
     * 待办列表查询条件租户级/应用级 配置
     *
     * @return {@link KgResultDTO<WorkbenchSettingRespDTO>}
     * @author gengwei
     * @since 2024/9/2 15:13
     **/
    public static KgResultDTO<WorkbenchSettingRespDTO> getWorkbenchSetting(String pageCode, String configType) {
        Map<String, Object> urlParam = new HashMap<>(3);
        urlParam.put("pageCode", pageCode);
        urlParam.put("configType", configType);
        urlParam.put("appCondition", false);
        return DwSpringHttpUtil.get(WORKBENCH_SETTING_URL, WorkbenchSettingRespDTOType, urlParam);
    }




}
