package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * 基础资料导入导出配置项
 *
 * @author hbk
 * @since 2025/3/13
 */


@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class ImportAndExportConfigRespDTO {

    private String code;

    private String name;

    private String viewCode;

    private String viewName;

    private String pattern;

    private String pageCode;

    private ExportConfig exportConfig;

    private List<ImportConfig> importConfig;

    private TemplateConfig templateConfig;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ExportConfig {
        private String actionId;

    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ImportConfig {
        private String actionId;
        private String actionType;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class TemplateConfig {
        private String actionId;
    }

}

