package com.digiwin.athena.knowledgegraph.sdk.meta.dto.response.thememap;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.Map;

@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TmActivityResponseDTO {

    private String activityId;
    private Object activityName;
    private int sequence;
    /**
     * 紧急
     */
    private int emergency;
    /**
     * 是否里程碑，true-在可视化面板显示，false-可视化面板不显示
     */
    private boolean milestone;
    private String executeType;
    private String pattern;
    private String category;
    private Object title;
    private Object subTitle;
    private Object description;
    private Object subDescription;
    private Boolean showFlow;
    private TmActivityExpectedDurationDTO expectedDuration;

    private Map<String, TmActionDTO> dataSources;

    private List<TmDataProcessDTO> dataProcessors;

    private int approveType;
    private int groupDispatchType;
    private List<String> startApproveActivity;
    private String startApproveActivityName;
    private Map<Object, Object> lang;
    private List<Approves> approves;
    private List<Message> messages;

    /**
     * 任务逾期处理规则
     */
    private List<Map<Object, Object>> overdueRules;

    /**
     * 汇总（已读，未读，已提交）
     */
    private TmCountItemDTO countItems;


    private TmActivityPageDTO pages;

    /**
     * 任务是否合并
     */
    private Boolean merge;

    /**
     * 任务可转派人员定义，没有定义表示可以转派给任意人员
     * <p>
     * 冲刺5开始，不再使用，请使用assignConfig
     */
    private TmUserDTO assignTo;

    /**
     * 任务的辅助执行者名单
     */
    private TmUserDTO assistant;

    /**
     * 是否可以转派
     * 为null或true，或没有指定，都表示可以转派
     * 为false表示不可以转派
     * <p>
     * 冲刺5开始，不再使用，请使用assignConfig
     */
    @Builder.Default
    private Boolean assignAble = true;

    private String name;

    /**
     * 目标签核任务code
     */
    private String targetApproveActivity;

    /**
     * 卡片逾期时是否需要向辅助执行者发送新卡片
     */
    private boolean overdueAuxiliary;

    /**
     * 附加数据<br>
     * imGroup  是否创建im任务群，false不创建；null、true或没有此值，创建
     */
    private Map<Object, Object> config;

    /**
     * 转派配置。同时兼容 assignAble 和 assignTo
     */
    private TmAssignConfigDTO assignConfig;

    /**
     * 附件配置
     */
    private TmAttachmentConfigInfo attachment;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Approves {

        private String key;
        private String identityType;
        private String identity;
        private List<Submits> submits;
        private String sequence;
        private String title;
        private int approveType;
        private String innerType;

    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Submits {

        private String title;
        private String actionId;
        private String serviceName;
        private String type;
        private String innerType;

    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Message {

        private List<String> messageType;
        private List<ToUsers> toUsers;
        private String extractScript;
        private String title;
        private String content;
        private String contentType;

    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ToUsers {

        private String identityType;
        private String source;
        private String identity;

    }
}
