package com.digiwin.athena.ops.sdk.manager;

import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.ops.sdk.meta.OpsResultDTO;
import com.digiwin.athena.ops.sdk.meta.response.PreGrayDataDto;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OpsManager {

    private static String getOpsUri() {
        return JaProperty.get("ops.uri");
    }

    public static final String PRE_STATE_URL = getOpsUri() + "/api/v1/deployment/mode";

    private static final ParameterizedTypeReference<OpsResultDTO<OpsResultDTO.DataContainer>> WithPreGrayDataDTOType = new ParameterizedTypeReference<OpsResultDTO<OpsResultDTO.DataContainer>>() {
    };

    /**
     * 查询预发布环境的灰度信息<br></>
     * 类型：String  必有字段  备注：裡面會有 pre, prod, custom, custom-hotfix, pre-hotfix, prod-hotfix。pre 預區 (內部租戶)、prod 正式區 (所有租戶)、custom 客戶區 (部分客戶租戶)。以下是使用兩個版本(金絲雀)流水線會有的：custom-hotfix 客戶區 hotfix (部分客戶租戶)、pre-hotfix 預區 hotfix (部分租戶)、prod-hotfix 正式區 hotfix [測試環境才有，因為正式環境只有一個 prod] (部分租戶)
     * <br></>
     * 包含pre则为预区
     *
     * @param cloud
     * @param area
     * @param appId
     * @param name
     * @param mode
     * @return
     */
    public static OpsResultDTO<OpsResultDTO.DataContainer> queryPreState(String cloud, String area, String appId, String name, String mode) {
        String url = UriComponentsBuilder.fromHttpUrl(PRE_STATE_URL)
                .queryParam("cloud", cloud)
                .queryParam("area", area)
                .queryParam("appId", appId)
                .queryParam("name", name)
                .queryParam("mode", mode)
                .build()
                .encode()
                .toUriString();
        return DwSpringHttpUtil.get(url, WithPreGrayDataDTOType, httpHeaders -> {
            httpHeaders.set(DwHttpHeaderConstants.Header_RoutingKey, "99990000");
            httpHeaders.set(DwHttpHeaderConstants.Header_Token, "e6cf01a1-18b1-45e4-ba2b-6ccdb35c49b9");
        }, Collections.emptyMap());
    }

}
