package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 待办详情数据(ptm.backlog表记录)
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmBacklogRecordRespDTO {

    private Long id;
    private Long workItemId;
    private Long activityId;
    private Long taskId;
    private Long projectId;
    private Long projectCardId;

    private String name;
    private String performerId;
    private String performerName;
    private String taskDefCode;
    private String projectDefCode;
    private LocalDateTime planEndTime;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Boolean closed;
    private Boolean merge;
    private Map businessUnit;

    /**
     * 处理者类型0:默认;1:辅助执行者;2:跨租户
     */
    private Integer type;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private Boolean overdue;
    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private Integer version;
    private String entityState;
    private Integer deleted;
    /**
     * 任务pattern
     */
    private String taskDefPattern;
    /**
     * 任务category
     */
    private String taskDefCategory;
    // 是否隐藏该任务卡   1:true 0:false
    private Boolean hidden;

}
