package com.digiwin.athena.ptm.sdk.meta.dto.response;


import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM活动信息： 任务详情数据(task表记录) + 活动详情数据(activity表记录) + 项目详情数据(project表记录)  + 事项详情数据(ptm_task_activity_item 表记录)
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmActWithTaskAndProjectRespDTO {

    private Long id;
    private Long projectId;
    private Long projectCardId;

    private String taskName;
    private String taskType;
    private LocalDateTime planEndTime;
    private String signReason;
    private String taskDefCode;
    private String taskDefName;
    private String taskDefPattern;
    private String taskDefCategory;
    private String taskDefExecuteType;
    private Boolean milestone;
    private Integer state;
    private Integer subState;
    private String processSerialNumber;
    private String bpmnType;
    private String bpmTaskUid;
    private String bpmSourceTaskUid;
    private String engine;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private Map businessUnit;
    private String proxyToken;
    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private Integer version;
    private String entityState;
    private Integer deleted;
    private Map data;


    /**
     * PTM 事项详情数据(ptm_task_activity_item 表记录)
     **/
    private Long acticityId;
    private Long taskId;

    private String activityName;
    private Integer signType;
    private Map informer;

    private String bpmActivityId;
    private String bpmActivityUid;
    private String bpmActivityName;

    private Long backlogId;
    private Long activityId;

    private String performerId;
    private String performerName;
    private Integer performerType;
    private String agentPerformerId;
    private String agentPerformerName;

    /**
     * 0.正常产生;1.转派；2.退回重签；3.退回重办；4.加签；9.撤回重办 10.交接;
     */
    private Integer createType;
    private String workItemId;
    private String fromWorkItemId;
    private Integer itemType;
    private Long groupId;
    private String comment;

    private String projectDefCode;
    private String projectDefName;
    private String projectDefPattern;
    private String sourceEntityName;
    private String projectName;

    private String personInCharge;
    private String personInChargeName;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Map mergeData;
    private String sourceIds;
    private String sourceName;
    private String remark;
    private Boolean hidden;
    private Boolean changedFlag;
    private Boolean completedReport;
    private String eocCode;
    private String eocName;
    private Integer eocType;
    private LocalDateTime dueDate;
    private String dueDateName;
    /**
     * 紧急度，25（紧急），50（一般-默认），75（低）
     */
    private Integer emergency;
    private String traceId;
    private Boolean importance;

    private Boolean expire;


}
