package com.digiwin.athena.ptm.sdk.meta.dto.request;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * TaskCardQueryModel
 * 任务卡数据查询请求
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TaskCardQueryModelReqDTO {
    /**
     * 用户id列表
     */
    private List<String> userIds;

    /**
     * 待办id列表
     */
    private List<Long> backlogIds;

    /**
     * 任务预计完成日开始时间
     */
    private String startPlanEndTime;

    /**
     * 任务预计完成日结束时间
     */
    private String endPlanEndTime;

    /**
     * 任务卡是否关闭
     */
    private Boolean closed;

    /**
     * 任务code
     */
    private List<String> codes;
}
