package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;

/**
 * PTM 事项详情数据(ptm_task_activity_item 表记录)
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmWorkItemRecordRespDTO {

    private Long id;
    private Long backlogId;
    private Long activityId;
    private Long taskId;
    private Long projectId;
    private Long projectCardId;

    private String performerId;
    private String performerName;
    private Integer performerType;
    private String agentPerformerId;
    private String agentPerformerName;

    /**
     * 0.正常产生;1.转派；2.退回重签；3.退回重办；4.加签；9.撤回重办 10.交接;
     */
    private Integer createType;
    private String workItemId;
    private String fromWorkItemId;
    private Integer state;
    private Integer subState;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private Integer itemType;
    private Long groupId;
    private String comment;
    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private Integer version;
    private String entityState;
    private Integer deleted;

}
