package com.digiwin.athena.ptm.sdk.manager;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.ptm.sdk.meta.dto.PtmResultDTO;
import com.digiwin.athena.ptm.sdk.meta.dto.request.*;
import com.digiwin.athena.ptm.sdk.meta.dto.response.*;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.*;

/**
 * ptm 相关api
 *
 * @author gengwei
 * @since 2024/8/20 14:51
 */
public class PtmManager {

    private static String getPtmUri() {
        return JaProperty.get("taskEngine.ptmUri");
    }
    private static String getDataFootPrintUri() {
        return JaProperty.get("smartdata.dataFootPrintUri");
    }

    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmTaskCardItemRespDTO>>> PtmTaskCardItemDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmTaskCardItemRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmProjectRecordRespDTO>>> PtmProjectRecordDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmProjectRecordRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmTaskRecordRespDTO>>> PtmTaskRecordDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmTaskRecordRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogItemRespDTO>>> PtmBacklogItemDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogItemRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmActWithTaskAndProjectRespDTO>> PtmActWithTaskAndProjectDTOListType = new ParameterizedTypeReference<PtmResultDTO<PtmActWithTaskAndProjectRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmRessignTraceRespDTO>>> PtmRessignTraceRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmRessignTraceRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmProjectRecordRespDTO>> PtmProjectRecordDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmProjectRecordRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmProjectCardRecordRespDTO>> PtmProjectCardRecordDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmProjectCardRecordRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmProjectCardRecordRespDTO>>> PtmProjectCardRecordDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmProjectCardRecordRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmTaskRecordRespDTO>> PtmTaskRecordDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmTaskRecordRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmActivityRecordRespDTO>> PtmActivityDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmActivityRecordRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmActivityRecordRespDTO>>> PtmActivityListDTOType = new ParameterizedTypeReference<PtmResultDTO<List<PtmActivityRecordRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmWorkItemRecordRespDTO>> PtmWorkItemDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmWorkItemRecordRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmWorkItemRecordRespDTO>>> PtmWorkItemListDTOType = new ParameterizedTypeReference<PtmResultDTO<List<PtmWorkItemRecordRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmBacklogRecordRespDTO>> PtmBacklogDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmBacklogRecordRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogRecordRespDTO>>> PtmBacklogListDTOType = new ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogRecordRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<Map<String, Object>>> PtmMapType = new ParameterizedTypeReference<PtmResultDTO<Map<String, Object>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogIdRespDTO>>> PtmMapListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogIdRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<DataFootBacklogIdRespDTO>>> DataFootMapListType = new ParameterizedTypeReference<PtmResultDTO<List<DataFootBacklogIdRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<Boolean>> PtmBooleanType = new ParameterizedTypeReference<PtmResultDTO<Boolean>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmProjectCardDetailRespDTO>> PtmProjectCardDetailRespDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmProjectCardDetailRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmProjectCardTaskDetailRespDTO>>> PtmProjectCardTaskDetailRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmProjectCardTaskDetailRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<PtmProjectCardPanelRespDTO>> PtmProjectCardPanelRespDTOType = new ParameterizedTypeReference<PtmResultDTO<PtmProjectCardPanelRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmProjectCardItemRespDTO>>> PtmProjectCardItemRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmProjectCardItemRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<BpmTaskApprovePreviousActivityRespDTO>> BpmTaskApprovePreviousActivityRespDTOType = new ParameterizedTypeReference<PtmResultDTO<BpmTaskApprovePreviousActivityRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogPartialRespDTO>>> PtmBacklogPartialRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogPartialRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<Boolean>>> PtmBooleanListType = new ParameterizedTypeReference<PtmResultDTO<List<Boolean>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmTaskCardDataRespDTO>>> PtmTaskCardDataRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmTaskCardDataRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmProjectReportItemRespDTO>>> PtmProjectReportItemRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmProjectReportItemRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogApprovalRespDTO>>> PtmBacklogApprovalRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<PtmBacklogApprovalRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<MobileBacklogGroupRespDTO>>> MobileBacklogGroupRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<MobileBacklogGroupRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<ProjectCardItemSimpleInfoRespDTO>>> ProjectCardItemSimpleInfoRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<ProjectCardItemSimpleInfoRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<WorkitemCompletedRespDTO>> WorkitemCompletedRespType = new ParameterizedTypeReference<PtmResultDTO<WorkitemCompletedRespDTO>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<WorkitemBacklogRespDTO>>> WorkitemBacklogRespListRespType = new ParameterizedTypeReference<PtmResultDTO<List<WorkitemBacklogRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<List<BacklogItemSimpleInfoRespDTO>>> BacklogItemSimpleInfoRespDTOListType = new ParameterizedTypeReference<PtmResultDTO<List<BacklogItemSimpleInfoRespDTO>>>() {
    };
    private static final ParameterizedTypeReference<PtmResultDTO<Object>> ObjectType = new ParameterizedTypeReference<PtmResultDTO<Object>>() {
    };

    /**
     * 查询ptm任务卡列表
     */
    private static final String TASK_CARD_LIST_URL = getPtmUri() + "/v2/api/backlog/list";

    /**
     * 获取任务记录详情(ptm_task表)
     */
    private static final String TASK_ACTIVITY_BY_WORK_ITEM_ID_URL = getPtmUri() + "/v2/api/project/task/activity/by-workItemId?workItemId={workItemId}";
    /**
     * 查询ptm任务卡列表，abt使用
     */
    private static final String TASK_CARD_LIST_SIMPLIFYLIST_URL = getPtmUri() + "api/task/card/processing/simplifyList";
    /**
     * 查询ptm任务卡列表
     */
    private static final String TASK_CARD_PROCESSING_LIST_URL = getPtmUri() + "api/task/card/processing/list";

    /**
     * 批量-获取项目 记录详情(ptm_project表)
     */
    private static final String PROJECT_DATA_LIST_URL = getPtmUri() + "api/data/project/list";

    /**
     * 批量 获取任务记录详情(ptm_task表)
     */
    private static final String TASK_LIST_URL = getPtmUri() + "api/data/task/list";

    /**
     * 根据backlogId获取全部的任务列表
     */
    private static final String TASK_CARD_LIST_BATCH_URL = getPtmUri() + "api/task/card/task/list/batch";

    /**
     * 获取转派历程
     */
    private static final String REASSIGN_TRACE_URL = getPtmUri() + "/v2/api/workitem/reassign/trace?backlogId={backlogId}";

    /**
     * 获取项目记录详情(ptm_project表)
     */
    private static final String PROJECT_DATA_URL = getPtmUri() + "api/data/project?id={projectId}";

    /**
     * 获取项目卡记录详情（ptm_project_card表）
     */
    private static final String PROJECT_CARD_DATA_URL = getPtmUri() + "api/data/project/card?id={projectCardId}";

    /**
     * 批量 获取项目卡 记录详情（ptm_project_card表）
     */
    private static final String PROJECT_CARD_DATA_LIST_URL = getPtmUri() + "api/data/project/card/list";

    /**
     * 获取任务记录详情(ptm_task表)
     */
    private static final String TASK_DATA_URL = getPtmUri() + "api/data/task?id={taskId}";

    /**
     * 获取活动记录详情(ptm_activity表)
     */
    private static final String TASK_ACTIVITY_URL = getPtmUri() + "api/data/task/activity?id={activityId}";

    /**
     * 获取事项的记录详情(ptm_task_activity_item 表记录)
     */
    private static final String TASK_ACTIVITY_ITEM_URL = getPtmUri() + "api/data/task/activity/item?id={workItemId}";

    /**
     * 获取待办的记录详情(ptm_backlog 表记录)
     */
    private static final String ACTIVITY_ITEM_BACKLOG_URL = getPtmUri() + "api/data/task/activity/item/backlog?id={backlogId}";

    /**
     * 批量 获取待办的记录详情(ptm_backlog 表记录)
     */
    private static final String ACTIVITY_ITEM_BACKLOG_LIST_URL = getPtmUri() + "api/data/task/activity/item/backlog/list";

    /**
     * 批量 获取事项 的记录详情(ptm_task_activity_item 表记录)
     */
    private static final String ACTIVITY_ITEM_LIST_URL = getPtmUri() + "api/data/task/activity/item/list";

    /**
     * 批量 获取活动记录详情(ptm_activity表)
     */
    private static final String TASK_ACTIVITY_LIST_URL = getPtmUri() + "api/data/task/activity/list";

    /**
     * 根据活动id和任务id获取bpmdata
     */
    private static final String TASK_VARIABLES_URL = getPtmUri() + "api/data/task/variables";

    /**
     *  获取任务卡待办id集合
     */
    public static final String BACKLOG_ID_LIST = getPtmUri() + "api/backlog/ids/by-condition-list";
    /**
     *  根据bk和任务编号获取任务信息列表
     */
    public static final String TASK_ID_LIST = getDataFootPrintUri()+" restful/service/DataFootprint/activity/queryByBk";
    /**
     * 根据流程序号，关闭其所在的主项目。提前结束项目
     */
    public static final String PROJECT_CARD_CLOSE_URL = getPtmUri() + "api/project/card/close";

    /**
     * 获取 项目卡 详情
     */
    public static final String PROJECT_CARD_DETAIL_ID_PROJECT_CARD_ID_URL = getPtmUri() + "api/project/card/detail?id={projectCardId}";

    /**
     * 获取项目卡中指定任务的所有任务信息
     */
    public static final String PROJECT_CARD_DETAIL_URL = getPtmUri() + "api/project/card/detail";

    /**
     * 获取项目卡的可视化面板数据
     */
    public static final String PROJECT_CARD_PANEL_ID_PROJECT_CARD_ID_URL = getPtmUri() + "api/project/card/panel?id={projectCardId}";

    /**
     * 查询ptm项目卡列表
     */
    public static final String PROJECT_CARD_PROCESSING_LIST_URL = getPtmUri() + "api/project/card/processing/list";

    /**
     * 转派 项目卡
     */
    public static final String PROJECT_CARD_REASSIGN_URL = getPtmUri() + "api/project/card/reassign";

    /**
     * 查询指定任务可退回重签信息
     */
    public static final String TASK_APPROVE_WORK_PREVIOUS_ACTIVITIES_URL = getPtmUri() + "api/task/approve/work/previous-activities";

    /**
     * 批量根据ptm_task.id查询所属的待办部分信息
     */
    public static final String TASK_BACKLOG_LIST_URL = getPtmUri() + "api/task/backlog/list";

    /**
     * 更新签核通知信息
     */
    public static final String TASK_CARD_APPROVE_INFORMER_UPDATE = getPtmUri() + "api/task/card/approve/informer/update";

    /**
     * 创建辅助执行者-待办
     */
    public static final String TASK_CARD_ASSIST_ADD_URL = getPtmUri() + "api/task/card/assist/add";

    /**
     * 多元交互-创建外部厂商个人租户待办
     */
    public static final String TASK_CARD_CROSS_TENANT_ADD_URL = getPtmUri() + "api/task/card/cross-tenant/add";

    /**
     * 根据待办id获取任务卡的data、stateData
     */
    public static final String TASK_CARD_DATA_URL = getPtmUri() + "api/task/card/data";

    /**
     * PTM 项目型报表
     */
    public static final String TASK_CARD_ITEM_REPORT_URL = getPtmUri() + "api/task/card/item/report";

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     */
    public static final String TASK_CARD_PREVIOUS_ITEM_URL = getPtmUri() + "api/task/card/previous/item";

    /**
     * 根据项目任务信息获取进行中的任务列表
     */
    public static final String TASK_CARD_TASK_BY_CONDITION_LIST_URL = getPtmUri() + "api/task/card/task-by-condition/list";

    /**
     * 批量终止任务
     */
    public static final String TASK_CARD_TERMINATE_URL = getPtmUri() + "api/task/card/terminate";

    /**
     * 获取待办的签核历程
     */
    public static final String V_2_BACKLOG_SIGN_PROCESS_BACKLOG_ID_BACKLOG_ID_URL = getPtmUri() + "v2/api/backlog/sign/process?backlogId={backlogId}";

    /**
     * 获取团队任务分组（用于移动端）
     */
    public static final String V_2_MOBILE_TASK_CARD_GROUP_URL = getPtmUri() + "v2/api/mobile/task/card/group";

    /**
     * 查询进行中的任务概要信息（项目id、项目名称，附属的任务id、任务名称等）
     */
    public static final String V_2_PROJECT_CARD_PROCESSING_LIST_URL = getPtmUri() + "v2/api/project/card/processing/list";
    /**
     * 查询决策模型是否完成
     */
    public static final String V_2_DECISION_BACKLOG_COMPLETED_URL = getPtmUri() + "v2/api/decision/backlog/data/completed?workItemId={workItemId}";

    /**
     * 根据待办id获取任务卡的data、stateData (批量)
     */
    public static final String TASK_CARD_DATA_BATCH_URL = getPtmUri() + "v2/api/task/card/data/batch";

    /**
     * 查询进行中的任务概要信息（任务id、任务名称等）
     */
    public static final String V_2_API_TASK_CARD_PROCESSING_LIST_URL = getPtmUri() + "v2/api/task/card/processing/list";

    /**
     * 获取workItem对应的backlogId
     */
    public static final String V_2_API_DECISION_WORKITEM_BACKLOG_URL = getPtmUri() + "v2/api/decision/workItem/backlog?workItemId={workItemId}";


    public static PtmResultDTO<List<PtmTaskCardItemRespDTO>> queryAllTaskCardList(BackLogListReqDTO backLogListReqDTO) {

        return DwSpringHttpUtil.post(TASK_CARD_LIST_URL, backLogListReqDTO, PtmTaskCardItemDTOListType);
    }

    public static PtmResultDTO<PtmActWithTaskAndProjectRespDTO> getActivityByWorkItemId(Long workItemId) {
        // URL 入参
        Map<String, Object> urlParam = new HashMap<>();
        urlParam.put("workItemId", workItemId);
        return DwSpringHttpUtil.get(TASK_ACTIVITY_BY_WORK_ITEM_ID_URL, PtmActWithTaskAndProjectDTOListType, urlParam);
    }

    public static PtmResultDTO<List<PtmTaskCardItemRespDTO>> queryTaskCardListByCodes(TaskCardListSimplifyListReqDTO taskCardListSimplifyListReqDTO) {

        return DwSpringHttpUtil.post(TASK_CARD_LIST_SIMPLIFYLIST_URL, taskCardListSimplifyListReqDTO, PtmTaskCardItemDTOListType);
    }

    public static PtmResultDTO<List<PtmTaskCardItemRespDTO>> queryTaskCardList(TaskCardProcessingListReqDTO taskCardProcessingListReqDTO) {
        return DwSpringHttpUtil.post(TASK_CARD_PROCESSING_LIST_URL, taskCardProcessingListReqDTO, PtmTaskCardItemDTOListType);
    }

    /**
     * 批量-获取项目 记录详情(ptm_project表)
     * <p>
     * projectRecordListReqDTO
     */
    public static PtmResultDTO<List<PtmProjectRecordRespDTO>> getProjectRecordByProjectIdsV2(ProjectTaskModelReqDTO projectTaskModel) {
        //请求接口
        return DwSpringHttpUtil.post(PROJECT_DATA_LIST_URL, projectTaskModel, PtmProjectRecordDTOListType);
    }

    public static PtmResultDTO<List<PtmTaskRecordRespDTO>> getTaskRecordByTaskIds(ProjectTaskModelReqDTO projectTaskModel) {
        //请求接口
        return DwSpringHttpUtil.post(TASK_LIST_URL, projectTaskModel, PtmTaskRecordDTOListType);

    }

    public static PtmResultDTO<List<PtmBacklogItemRespDTO>> getBacklogByBacklogIds(TaskCardListByBacklogIdReqDTO taskCardListByBacklogIdReqDTO) {
        return DwSpringHttpUtil.post(TASK_CARD_LIST_BATCH_URL, taskCardListByBacklogIdReqDTO, PtmBacklogItemDTOListType);
    }

    /**
     * 获取转派历程
     * <p>
     * backlogId 待办id
     */
    public static PtmResultDTO<List<PtmRessignTraceRespDTO>> getReassignTrace(Long backlogId) {
        // url 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("backlogId", backlogId);
        return DwSpringHttpUtil.get(REASSIGN_TRACE_URL, PtmRessignTraceRespDTOListType, urlParam);
    }

    /**
     * 获取项目记录详情(ptm_project表)
     * <p>
     * projectId
     */
    public static PtmResultDTO<PtmProjectRecordRespDTO> getProjectRecord(Long projectId) {
        // URL 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("projectId", projectId);
        return DwSpringHttpUtil.get(PROJECT_DATA_URL, PtmProjectRecordDTOType, urlParam);

    }

    /**
     * 获取项目卡记录详情（ptm_project_card表）
     */
    public static PtmResultDTO<PtmProjectCardRecordRespDTO> getProjectCardRecord(Long projectCardId) {
        // url 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("projectCardId", projectCardId);
        //请求地址
        return DwSpringHttpUtil.get(PROJECT_CARD_DATA_URL, PtmProjectCardRecordDTOType, urlParam);

    }

    /**
     * 批量 获取项目卡 记录详情（ptm_project_card表）
     * <p>
     * ptmProjectCardRecordReqDTO
     */
    public static PtmResultDTO<List<PtmProjectCardRecordRespDTO>> getProjectCardRecordByProjectCardIds(PtmProjectCardRecordReqDTO ptmProjectCardRecordReqDTO) {
        return DwSpringHttpUtil.post(PROJECT_CARD_DATA_LIST_URL, ptmProjectCardRecordReqDTO, PtmProjectCardRecordDTOListType);
    }

    /**
     * 获取任务记录详情(ptm_task表)
     * <p>
     * taskId
     */
    public static PtmResultDTO<PtmTaskRecordRespDTO> getTaskRecord(Long taskId) {
        // URL 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("taskId", taskId);
        return DwSpringHttpUtil.get(TASK_DATA_URL, PtmTaskRecordDTOType, urlParam);
    }


    /**
     * 获取活动记录详情(ptm_activity表)
     * <p>
     * activityId
     */
    public static PtmResultDTO<PtmActivityRecordRespDTO> getActivityRecord(Long activityId) {
        //入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("activityId", activityId);
        return DwSpringHttpUtil.get(TASK_ACTIVITY_URL, PtmActivityDTOType, urlParam);

    }


    /**
     * 获取事项的记录详情(ptm_task_activity_item 表记录)
     * <p>
     * workItemId
     */
    public static PtmResultDTO<PtmWorkItemRecordRespDTO> getWorkItemRecord(Long workItemId) {
        // url 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("workItemId", workItemId);
        return DwSpringHttpUtil.get(TASK_ACTIVITY_ITEM_URL, PtmWorkItemDTOType, urlParam);

    }


    /**
     * 获取待办的记录详情(ptm_backlog 表记录)
     * <p>
     * backlogId
     */
    public static PtmResultDTO<PtmBacklogRecordRespDTO> getBacklogRecord(Long backlogId) {
        // url 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("backlogId", backlogId);
        return DwSpringHttpUtil.get(ACTIVITY_ITEM_BACKLOG_URL, PtmBacklogDTOType, urlParam);
    }

    /**
     * 批量 获取待办的记录详情(ptm_backlog 表记录)
     * <p>
     * backlogIds
     */
    public static PtmResultDTO<List<PtmBacklogRecordRespDTO>> getBacklogRecordByBacklogIds(List<Long> backlogIds) {
        //入参
        Map<String, Object> param = new HashMap<>(1);
        param.put("idList", backlogIds);
        return DwSpringHttpUtil.post(ACTIVITY_ITEM_BACKLOG_LIST_URL, param, PtmBacklogListDTOType);

    }

    /**
     * 批量 获取事项 的记录详情(ptm_task_activity_item 表记录)
     * <p>
     * workItemIds
     */
    public static PtmResultDTO<List<PtmWorkItemRecordRespDTO>> getWorkItemRecordByWorkItemIds(List<Long> workItemIds) {
        //入参
        Map<String, Object> param = new HashMap<>(1);
        param.put("idList", workItemIds);
        return DwSpringHttpUtil.post(ACTIVITY_ITEM_LIST_URL, param, PtmWorkItemListDTOType);

    }


    /**
     * 批量 获取活动记录详情(ptm_activity表)
     * <p>
     * activityIds
     * 没有值慢返回空集合
     */
    public static PtmResultDTO<List<PtmActivityRecordRespDTO>> getActivityRecordByActivityIds(List<Long> activityIds) {
        //入参
        Map<String, Object> param = new HashMap<>(1);
        param.put("idList", activityIds);
        return DwSpringHttpUtil.post(TASK_ACTIVITY_LIST_URL, param, PtmActivityListDTOType);

    }

    /**
     * 根据活动id和任务id获取bpmdata
     * <p>
     * activityId
     * taskId
     */
    public static PtmResultDTO<Map<String, Object>> getBpmDataByActivityIdAndTaskId(Long activityId, Long taskId) {
        //入参
        Map<String, Object> rootPara = new HashMap<>(2);
        rootPara.put("taskId", taskId);
        rootPara.put("activityId", activityId);
        return DwSpringHttpUtil.post(TASK_VARIABLES_URL, rootPara, PtmMapType);

    }

    /**
     * 获取任务卡待办id集合
     *
     * @param ids  任务或项目 id集合
     * @param code 任务或项目code
     * @param type 任务或项目 (task/project)
     * @return 待办id列表
     */
    public PtmResultDTO<List<PtmBacklogIdRespDTO>> queryBacklogIds(List<Long> ids, String type, String code) {
        Map<String, Object> rootPara = new HashMap<>(3);
        rootPara.put("ids", ids);
        rootPara.put("type", type);
        rootPara.put("code", code);
        return DwSpringHttpUtil.post(BACKLOG_ID_LIST, rootPara, PtmMapListType);
    }

    /**
     * 根据bk和任务编号获取任务信息列表
     * @param tenantId 租户
     * @param bkInfo bk信息
     * @return
     */
    public PtmResultDTO<List<DataFootBacklogIdRespDTO>> queryByBk(String tenantId, JSONObject bkInfo) {
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("bkInfo", bkInfo);
        rootPara.put("tenantId", tenantId);
        return DwSpringHttpUtil.post(TASK_ID_LIST, rootPara, DataFootMapListType);
    }

    /**
     * 根据流程序号，关闭其所在的主项目。提前结束项目
     * <p>
     * map
     */
    public static PtmResultDTO<Boolean> closeProjectCard(List<String> processSerialNumbers) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("processSerialNumbers", processSerialNumbers);
        return DwSpringHttpUtil.post(PROJECT_CARD_CLOSE_URL, map, PtmBooleanType);
    }


    /**
     * 获取 项目卡 详情
     * <p>
     * projectCardId
     */
    public static PtmResultDTO<PtmProjectCardDetailRespDTO> getProjectCardDetail(Long projectCardId) {
        //入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("projectCardId", projectCardId);
        return DwSpringHttpUtil.get(PROJECT_CARD_DETAIL_ID_PROJECT_CARD_ID_URL, PtmProjectCardDetailRespDTOType, urlParam);
    }

    /**
     * 获取项目卡中指定任务的所有任务信息
     * <p>
     * projectCardId
     * taskDefCode
     */
    public static PtmResultDTO<List<PtmProjectCardTaskDetailRespDTO>> getProjectCardDetail(Long projectCardId, String taskDefCode) {
        //入参
        Map<String, Object> rootPara = new HashMap<>(2);
        rootPara.put("projectCardId", projectCardId);
        rootPara.put("taskDefCode", taskDefCode);
        return DwSpringHttpUtil.post(PROJECT_CARD_DETAIL_URL, rootPara, PtmProjectCardTaskDetailRespDTOListType);
    }

    /**
     * 获取项目卡的可视化面板数据
     * <p>
     * projectCardId
     */
    public static PtmResultDTO<PtmProjectCardPanelRespDTO> getProjectCardPanel(Long projectCardId) {
        // url 入参
        Map<String, Object> urlParam = new HashMap<>(1);
        urlParam.put("projectCardId", projectCardId);
        return DwSpringHttpUtil.get(PROJECT_CARD_PANEL_ID_PROJECT_CARD_ID_URL, PtmProjectCardPanelRespDTOType, urlParam);
    }


    /**
     * 查询ptm项目卡列表
     */
    public static PtmResultDTO<List<PtmProjectCardItemRespDTO>> queryProjectCard(ProjectCardQueryModelReqDTO projectCardQueryModelReqDTO) {

        return DwSpringHttpUtil.post(PROJECT_CARD_PROCESSING_LIST_URL, projectCardQueryModelReqDTO, PtmProjectCardItemRespDTOListType);

    }

    /**
     * 转派 项目卡
     * <p>
     * requestDTO
     */
    public static PtmResultDTO<Boolean> reassignProjectCard(PtmProjectCardReassignReqDTO requestDTO) {

        return DwSpringHttpUtil.post(PROJECT_CARD_REASSIGN_URL, requestDTO, PtmBooleanType);
    }

    /**
     * 查询指定任务可退回重签信息
     * <p>
     * requestDTO
     */
    public static PtmResultDTO<BpmTaskApprovePreviousActivityRespDTO> queryPreApprove(BpmTaskPreApproveReqDTO requestDTO) {
        return DwSpringHttpUtil.post(TASK_APPROVE_WORK_PREVIOUS_ACTIVITIES_URL, requestDTO, BpmTaskApprovePreviousActivityRespDTOType);
    }

    /**
     * 批量根据ptm_task.id查询所属的待办部分信息
     * <p>
     * taskIds
     */
    public static PtmResultDTO<List<PtmBacklogPartialRespDTO>> queryBacklogPartialByTaskIds(List<Long> taskIds) {
        //入参
        Map<String, Object> param = new HashMap<>(1);
        param.put("taskIds", taskIds);
        return DwSpringHttpUtil.post(TASK_BACKLOG_LIST_URL, param, PtmBacklogPartialRespDTOListType);
    }


    /**
     * 更新签核通知信息
     */
    public static PtmResultDTO<Boolean> updateSignInformNotice(Long activityId, Map<String, Object> informer) {
        //入参 Map<String,List<SignNotice>>
        Map<String, Object> param = new HashMap<>(2);
        param.put("activityId", activityId);
        param.put("informer", informer);
        return DwSpringHttpUtil.post(TASK_CARD_APPROVE_INFORMER_UPDATE, param, PtmBooleanType);
    }


    /**
     * 创建辅助执行者-待办
     * <p>
     * assistRequest
     */
    public static PtmResultDTO<Boolean> addAssistBacklog(PtmAssistBacklogReqDTO assistRequest) {
        return DwSpringHttpUtil.post(TASK_CARD_ASSIST_ADD_URL, assistRequest, PtmBooleanType);
    }


    /**
     * 多元交互-创建外部厂商个人租户待办
     * <p>
     * emailRequest
     */
    public static PtmResultDTO<Boolean> addCrossTenantBacklog(PtmEmailBacklogReqDTO emailRequest) {
        return DwSpringHttpUtil.post(TASK_CARD_CROSS_TENANT_ADD_URL, emailRequest, PtmBooleanType);

    }


    public static PtmResultDTO<List<PtmTaskCardDataRespDTO>> getTaskData(TaskDataQueryModelReqDTO taskDataQueryModelReqDTO) {
        return DwSpringHttpUtil.post(TASK_CARD_DATA_URL, taskDataQueryModelReqDTO, PtmTaskCardDataRespDTOListType);

    }


    /**
     * PTM 项目型报表
     * <p>
     * queryProjectReportReq
     */
    public static PtmResultDTO<List<PtmProjectReportItemRespDTO>> queryProjectReport(QueryProjectReportReqDTO queryProjectReportReq) {
        return DwSpringHttpUtil.post(TASK_CARD_ITEM_REPORT_URL, queryProjectReportReq, PtmProjectReportItemRespDTOListType);

    }

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     * <p>
     * type             0 或 null，同一个任务，指签核任务内；1-不是同一个任务
     * workItemId
     * approvalTaskCode 要查询的签核任务code
     * 可能为null
     */
    public static PtmResultDTO<PtmWorkItemRecordRespDTO> getReExecuteWorkItem(QueryReExecuteWorkItemReqDTO queryReExecuteWorkItemReqDTO) {

        return DwSpringHttpUtil.post(TASK_CARD_PREVIOUS_ITEM_URL, queryReExecuteWorkItemReqDTO, PtmWorkItemDTOType);

    }

    /**
     * 根据项目卡任务信息获取进行中的任务列表
     * <p>
     * data取的是ptm_task.data
     */
    public static PtmResultDTO<List<PtmBacklogItemRespDTO>> getBacklogItemList(QueryBacklogReqDTO queryBacklogReq) {

        return DwSpringHttpUtil.post(TASK_CARD_TASK_BY_CONDITION_LIST_URL, queryBacklogReq, PtmBacklogItemDTOListType);
    }


    /**
     * 批量终止任务
     * <p>
     * param
     */
    public static PtmResultDTO<Boolean> batchTerminateTask(Map param) {

        return DwSpringHttpUtil.post(TASK_CARD_TERMINATE_URL, param, PtmBooleanType);
    }

    /**
     * 获取待办的签核历程
     * <p>
     * backlogId
     * 没有内容返回空集合
     */
    public static PtmResultDTO<List<PtmBacklogApprovalRespDTO>> queryApprovalNew(Long backlogId) {
        //入参
        Map<String, Object> param = new HashMap<>();
        param.put("backlogId", backlogId);
        //请求地址
        return DwSpringHttpUtil.get(V_2_BACKLOG_SIGN_PROCESS_BACKLOG_ID_BACKLOG_ID_URL, PtmBacklogApprovalRespDTOListType, param);

    }

    /**
     * 获取团队任务分组（用于移动端）
     */
    public static PtmResultDTO<List<MobileBacklogGroupRespDTO>> getMobileDepartBacklogGroup(QueryMobileDepartBacklogGroupReqDTO queryMobileDepartBacklogGroupReqDTO) {
        return DwSpringHttpUtil.post(V_2_MOBILE_TASK_CARD_GROUP_URL, queryMobileDepartBacklogGroupReqDTO, MobileBacklogGroupRespDTOListType);

    }

    /**
     * 查询进行中的任务概要信息（项目id、项目名称，附属的任务id、任务名称等）
     * <p>
     * userIds        用户id列表
     * projectCardIds 项目卡id列表，可选
     */
    public static PtmResultDTO<List<ProjectCardItemSimpleInfoRespDTO>> queryProjectCardSimpleInfo(ProjectCardQueryModelReqDTO projectCardQueryModelReqDTO) {
        return DwSpringHttpUtil.post(V_2_PROJECT_CARD_PROCESSING_LIST_URL, projectCardQueryModelReqDTO, ProjectCardItemSimpleInfoRespDTOListType);
    }

    /**
     * 查询进行中的任务概要信息（任务id、任务名称等）
     * <p>
     * userIds        用户id列表
     * backlogIds     任务卡id列表，可选
     */
    public static PtmResultDTO<List<BacklogItemSimpleInfoRespDTO>> queryBackCardSimpleInfo(TaskCardQueryModelReqDTO taskCardQueryModelReqDTO) {

        return DwSpringHttpUtil.post(V_2_API_TASK_CARD_PROCESSING_LIST_URL, taskCardQueryModelReqDTO, BacklogItemSimpleInfoRespDTOListType);

    }

    /**
     * 查询决策模型是否完成
     * workitemId        事项ID
     */
    public static PtmResultDTO<WorkitemCompletedRespDTO> getDecisionBacklogCompleted(Long workItemId) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("workItemId", workItemId);
        return DwSpringHttpUtil.get(V_2_DECISION_BACKLOG_COMPLETED_URL, WorkitemCompletedRespType, map);
    }

    /**
     * 查询workitemId对应的backlog
     * workitemId        事项ID
     */
    public static PtmResultDTO<List<WorkitemBacklogRespDTO>> getDecisionWorkitemBacklog(Long workItemId) {
        Map<String, Object> map = new HashMap<>(1);
        map.put("workItemId", workItemId);
        return DwSpringHttpUtil.get(V_2_API_DECISION_WORKITEM_BACKLOG_URL, WorkitemBacklogRespListRespType, map);
    }

}
