package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * BPM 任务引擎签核历程返回类型
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BpmTaskApproveActivityRespDTO {

    private String bpmActivityOID;
    private String activityId;
    private String activityName;
    private String signType;
    private LocalDateTime startTime;
    private String completedTime;
    private Map informer;
    private int state;
    private int subState;
    private List<WorkItem> workitemList;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class WorkItem {
        private String workitemId;
        private String agentPerformerId;
        private Integer subState;
        private LocalDateTime createTime;
        private LocalDateTime closedTime;
        private Integer createType;
        private String comment;
        private Integer state;
        private String performerId;
        private Integer performerType;
        private List<ApprovelAttachmentRespDTO> attachments;
    }
}
