package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * BPM 任务引擎可退回重签信息
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BpmTaskApprovePreviousActivityRespDTO {

    private List<Activitie> activities;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Activitie {

        private String activityId;

        private String activityName;

        private String createdTime;

        private int index;

        private String uid;

        private List<BpmTaskApproveActivityRespDTO.WorkItem> workitemList;

        @Setter
        @Getter
        @SuperBuilder
        @AllArgsConstructor
        @NoArgsConstructor
        @Builder
        public static class WorkItem {
            private String agentPerformerId;
            private String performerId;
            private Integer performerType;
        }
    }

}
