package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 项目卡可视化面板实体
 */
@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PtmProjectCardPanelRespDTO {

    private ProjectCardDTO projectCard;
    private List<ProjectDTO> projects;
    private List<PhaseDTO> phases;
    private ProjectDefineDTO projectDefine;

    private Boolean expire;

    private Integer activityExceptionCount;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ProjectCardDTO {
        private Long id;
        private String projectDefCode;
        private String projectDefName;
        private String projectDefPattern;
        private String targetId;
        private String targetName;
        private String projectName;
        private Map<Object, Object> businessUnit;
        private Integer state;
        private String personInCharge;
        private String personInChargeName;
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private String sourceIds;
        private String sourceName;
        private LocalDateTime createTime;
        private LocalDateTime updatedTime;
        private String tenantId;

    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ProjectDTO {
        private Long id;
        private Long projectCardId;
        private String projectDefCode;
        private String projectDefName;
        private String projectName;
        private Integer state;
        private String eocCode;
        private String eocName;
        private Integer eocType;
        private Map<Object, Object> businessUnit;
        private LocalDateTime dueDate;
        private String dueDateName;
        private String sourceIds;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class PhaseDTO {
        private String code;
        private String name;
        private String type;
        private List<String> taskCodes;
        private List<String> inputStates;
        private List<TaskDTO> tasks;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class TaskDTO {
        private Long id;
        private Long projectId;
        private String taskName;
        private String taskDefCode;
        private String taskDefPattern;
        private String taskDefCategory;
        private Boolean exception;
        /**
         * 任务是否存在异常
         */
        private Boolean hasException;
        private LocalDateTime planEndTime;
        private LocalDateTime closedTime;
        private Integer state;
    }

    /**
     * TM的项目定义部分内容
     */
    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ProjectDefineDTO {

        /**
         * 任务名称键值对
         */
        private Map<Object, Object> taskNames;
    }
}
