package com.digiwin.athena.ptm.sdk.meta.dto.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * PTM 任务详情数据(task表记录)
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class PtmTaskRecordRespDTO {

    private Long id;
    private Long projectId;
    private Long projectCardId;

    private String taskName;
    private String taskType;
    private LocalDateTime planEndTime;
    private String signReason;
    private String taskDefCode;
    private String taskDefName;
    private String taskDefPattern;
    private String taskDefCategory;
    private String taskDefExecuteType;
    private Boolean milestone;
    private Integer state;
    private Integer subState;
    private String processSerialNumber;
    private String bpmnType;
    private String bpmTaskUid;
    private String bpmSourceTaskUid;
    private String engine;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private Map businessUnit;
    private String proxyToken;
    private String tenantId;
    private String createdBy;
    private LocalDateTime createdTime;
    private String updatedBy;
    private LocalDateTime updatedTime;
    private Integer version;
    private String entityState;
    private Integer deleted;
    private Map data;

}
