package com.digiwin.athena.taskengine.sdk.manager;

import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.taskengine.sdk.meta.dto.TaskEngineResultDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * task engine manager
 *
 * @author gengwei
 * @since 2024/9/2 10:28
 */
public class TaskEngineManager {

    private static String getPtmUri() {
        return JaProperty.get("taskEngineUri");
    }

    private static final ParameterizedTypeReference<TaskEngineResultDTO<Object>> ObjectType = new ParameterizedTypeReference<TaskEngineResultDTO<Object>>() {
    };
    /**
     * 批次关闭任务
     */
    public static final String TASK_TERMINATE_URL = getPtmUri() + "api/task/terminate";

    /**
     * 批次关闭任务
     */
    public static TaskEngineResultDTO<Object> batchTerminateTask(List<String> taskUids) {
        //入参
        Map<String, Object> rootPara = new HashMap<>();
        rootPara.put("taskUids", taskUids);
        return DwSpringHttpUtil.post(TASK_TERMINATE_URL, rootPara, ObjectType);

    }


}
