/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.bk.parser.instance;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.bk.parser.dto.BkNodeDto;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.MetadataUnit;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.MultiValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBkInstanceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBkInstanceParser.class);

    protected List<JSONObject> parse(MetadataUnit tempMetadata, JsonNode originalNode, String rootName) throws Exception {
        JsonNode dataNode = originalNode;
        String dataNodePath = rootName;
        if (dataNode.isObject()) {
            return this.parseWhenBkNodeIsObject(tempMetadata, dataNode, dataNodePath);
        }
        if (dataNode.isArray()) {
            return this.parseWhenBkNodeIsArray(tempMetadata, dataNode, dataNodePath);
        }
        LOGGER.error("\u6570\u636e\u8282\u70b9\u7c7b\u578b\u4e3a{}\uff0c\u975eObject/Array\u7c7b\u578b!", (Object)dataNode.getNodeType());
        throw ErrorCodeEnum.TASK_BK_DATANODE_GET_NODE_TYPE.getBusinessExceptionWithArgs(new Object[]{dataNode.getNodeType()});
    }

    private BkNodeDto getBkNode(MetadataUnit tempMetadata, JsonNode originalNode, String rootName) {
        boolean isSinglePath = tempMetadata.getShortestPath().indexOf(".") == -1;
        String dataNodePath = tempMetadata.getShortestPath();
        if (!isSinglePath) {
            dataNodePath = tempMetadata.getShortestPath().substring(0, tempMetadata.getShortestPath().lastIndexOf("."));
        }
        if (tempMetadata.isRoot()) {
            return new BkNodeDto(originalNode, dataNodePath);
        }
        JsonNode dataNode = originalNode.at("/" + rootName + "/" + dataNodePath.replace(".", "/"));
        if (dataNode.isObject()) {
            if (dataNodePath.indexOf(".") == -1) {
                return new BkNodeDto(originalNode.at("/" + rootName), dataNodePath);
            }
            String tempDataNodePath = dataNodePath.substring(0, dataNodePath.lastIndexOf("."));
            dataNode = originalNode.at("/" + rootName + "/" + tempDataNodePath.replace(".", "/"));
            return new BkNodeDto(dataNode, dataNodePath);
        }
        return new BkNodeDto(dataNode, dataNodePath);
    }

    private List<JSONObject> parseWhenBkNodeIsArray(MetadataUnit tempMetadata, JsonNode dataNode, String dataNodePath) {
        ArrayList<JSONObject> eventData = new ArrayList<JSONObject>();
        dataNode.elements().forEachRemaining(item -> {
            MultiValueMap eventContext = new MultiValueMap();
            this.parseBkInstanceData((JsonNode)item, dataNodePath, dataNodePath + ".0", eventContext, tempMetadata, 0);
            if (CollectionUtils.isEmpty((Map)eventContext)) {
                LOGGER.warn("\u8282\u70b9\u6570\u636e[{}]\u4e2d\u89e3\u6790\u7684\u5bf9\u5e94Bk\u6570\u636e\u4e3a\u7a7a,\u6570\u636e\u4e0d\u4e00\u81f4\u5904\u7406\u7ed3\u675f!", (Object)JsonUtils.objectToString((Object)item));
                return;
            }
            if (tempMetadata.isExistLongest()) {
                eventData.addAll(this.processBkWhenExistLongest(tempMetadata, eventContext));
            } else {
                eventData.addAll(this.processBkWhenNotExistLongest(tempMetadata, eventContext));
            }
        });
        return eventData;
    }

    private List<JSONObject> parseWhenBkNodeIsObject(MetadataUnit tempMetadata, JsonNode dataNode, String dataNodePath) throws Exception {
        ArrayList<JSONObject> eventData = new ArrayList<JSONObject>();
        MultiValueMap eventContext = new MultiValueMap();
        dataNode.elements().forEachRemaining(item -> this.parseBkInstanceData((JsonNode)item, dataNodePath, dataNodePath + ".0", eventContext, tempMetadata, 0));
        if (CollectionUtils.isEmpty((Map)eventContext)) {
            LOGGER.warn("\u8282\u70b9\u6570\u636e[{}]\u4e2d\u89e3\u6790\u7684\u5bf9\u5e94Bk\u6570\u636e\u4e3a\u7a7a,\u6570\u636e\u4e0d\u4e00\u81f4\u5904\u7406\u7ed3\u675f!", (Object)JsonUtils.objectToString((Object)dataNode));
            throw ErrorCodeEnum.TASK_BK_DATA_EMPTY.getBusinessExceptionWithArgs(new Object[]{JsonUtils.objectToString((Object)dataNode)});
        }
        if (tempMetadata.isExistLongest()) {
            eventData.addAll(this.processBkWhenExistLongest(tempMetadata, eventContext));
        } else {
            eventData.addAll(this.processBkWhenNotExistLongest(tempMetadata, eventContext));
        }
        return eventData;
    }

    private List<JSONObject> processBkWhenExistLongest(MetadataUnit metadataUnit, MultiValueMap valueMap) {
        ArrayList<JSONObject> tempResult = new ArrayList<JSONObject>();
        List longestObjects = (List)valueMap.getCollection((Object)metadataUnit.getPathInstance());
        for (JSONObject obj : longestObjects) {
            JSONObject singleObject = new JSONObject();
            for (Map.Entry<String, String> entry : metadataUnit.getBkFields().entrySet()) {
                if (entry.getValue().equals(metadataUnit.getPathInstance())) {
                    singleObject.put((Object)entry.getKey(), (Object)obj.getString("value"));
                    continue;
                }
                List tempObjects = (List)valueMap.getCollection((Object)entry.getValue());
                String tempValue = this.getBkValue(tempObjects, obj.getString("indexJsonPathVal"), entry.getValue());
                if ("emptyString".equals(tempValue)) {
                    LOGGER.error("\u901a\u8fc7\u5b9e\u4f8b\u8def\u5f84[{}]\u83b7\u53d6\u76ee\u6807jsonPath[{}]\u5bf9\u5e94\u5c5e\u6027\u503c\u5931\u8d25, \u8bf7\u67e5\u770b\uff01", (Object)obj.getString("indexJsonPathVal"), (Object)entry.getValue());
                    singleObject.clear();
                    continue;
                }
                singleObject.put((Object)entry.getKey(), (Object)tempValue);
            }
            if (!CollectionUtils.isNotEmpty((Map)singleObject)) continue;
            tempResult.add(singleObject);
        }
        return tempResult;
    }

    private String getBkValue(List<JSONObject> bkInfo, String insInxJsonPath, String targetJsonPath) {
        String relativePath = targetJsonPath.substring(0, targetJsonPath.lastIndexOf("."));
        String propName = targetJsonPath.substring(targetJsonPath.lastIndexOf(".") + 1);
        String parentPropName = relativePath.substring(relativePath.lastIndexOf(".") + 1);
        if (insInxJsonPath.indexOf(parentPropName) < 0) {
            return "emptyString";
        }
        String relativeInxJsonPath = insInxJsonPath.substring(0, insInxJsonPath.indexOf(parentPropName) + parentPropName.length() + 3) + propName;
        for (JSONObject object : bkInfo) {
            if (!object.getString("indexJsonPathVal").equals(relativeInxJsonPath)) continue;
            return object.getString("value");
        }
        return "emptyString";
    }

    private List<JSONObject> processBkWhenNotExistLongest(MetadataUnit metadataUnit, MultiValueMap valueMap) {
        int insMaxSize = ((List)valueMap.get((Object)metadataUnit.getPathInstance())).size();
        ArrayList<JSONObject> eventBk = new ArrayList<JSONObject>();
        for (int i = 0; i < insMaxSize; ++i) {
            JSONObject tempObj = new JSONObject();
            for (Map.Entry<String, String> entry : metadataUnit.getBkFields().entrySet()) {
                List tempVal = (List)valueMap.get((Object)entry.getValue());
                tempObj.put((Object)entry.getKey(), (Object)((JSONObject)tempVal.get(i)).getString("value"));
            }
            eventBk.add(tempObj);
        }
        return eventBk;
    }

    private void parseBkInstanceData(JsonNode dataNode, String currentJsonPath, String currentJsonIndexPath, MultiValueMap eventContext, MetadataUnit metadataUnit, int index) {
        if (dataNode.isObject()) {
            ObjectNode object = (ObjectNode)dataNode;
            Iterator iterator = object.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String tempCurrentPath = currentJsonPath + "." + (String)entry.getKey();
                String tempCurrentIndexPath = currentJsonIndexPath + "." + (String)entry.getKey();
                this.parseBkInstanceData((JsonNode)entry.getValue(), tempCurrentPath, tempCurrentIndexPath, eventContext, metadataUnit, index);
            }
        } else if (dataNode.isArray()) {
            ArrayNode tempNode = (ArrayNode)dataNode;
            Iterator iterator = tempNode.elements();
            int i = 0;
            while (iterator.hasNext()) {
                JsonNode temp = (JsonNode)iterator.next();
                this.parseBkInstanceData(temp, currentJsonPath, currentJsonIndexPath + "." + i, eventContext, metadataUnit, i);
                ++i;
            }
        } else {
            currentJsonPath = currentJsonPath.substring(currentJsonIndexPath.indexOf(".") + 1);
            if (metadataUnit.getAllJsonPath().contains(currentJsonPath)) {
                JSONObject temp = new JSONObject();
                temp.put((Object)"value", (Object)dataNode.asText());
                temp.put((Object)"indexJsonPathVal", (Object)currentJsonIndexPath);
                eventContext.put((Object)currentJsonPath, (Object)temp);
            }
        }
    }

    protected JsonNode getNode(JSONObject data) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(JsonUtils.objectToString((Object)data));
        }
        catch (Exception e) {
            LOGGER.error(ErrorCodeEnum.TASK_BK_DATA_NODE_EXCEPTION.getErrMsg(), (Throwable)e);
            throw ErrorCodeEnum.TASK_BK_DATA_NODE_EXCEPTION.getBusinessExceptionWithArgs(new Object[0]);
        }
    }
}

