/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.bk.parser.metadata;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.MetadataUnit;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class AbstractBkMetadataParser {
    public static MetadataUnit constructMetadata(JSONObject metaObj, String rootName) {
        String entityName = metaObj.getString("entityName");
        JSONArray bks = metaObj.getJSONArray("bk");
        String source = "";
        if (metaObj.containsKey((Object)source)) {
            source = metaObj.getString("source");
        }
        boolean isRoot = false;
        HashMap<String, String> bkFields = new HashMap<String, String>(8);
        for (Object bk : bks) {
            JSONObject tempBk = (JSONObject)bk;
            if ("object".equals(tempBk.getString("dataType"))) {
                String parentPath = tempBk.getString("dataName") + ".";
                JSONArray fieldBks = tempBk.getJSONArray("field");
                fieldBks.forEach(fieldBk -> AbstractBkMetadataParser.recursion((JSONObject)fieldBk, bkFields, parentPath));
            }
            if ("object".equals(tempBk.getString("dataType"))) continue;
            String bkName = tempBk.getString("bkName");
            if (StringUtils.isBlank((CharSequence)bkName) || "null".equalsIgnoreCase(bkName)) {
                bkName = tempBk.getString("dataName");
            }
            bkFields.put(bkName, rootName + "." + tempBk.getString("dataName"));
            isRoot = true;
        }
        if (isRoot) {
            bkFields.entrySet().forEach(entry -> {
                if (!((String)entry.getValue()).startsWith(rootName)) {
                    entry.setValue(rootName + "." + (String)entry.getValue());
                }
            });
        }
        return new MetadataUnit(source, entityName, bkFields, isRoot);
    }

    private static void recursion(JSONObject tempBk, Map<String, String> bkFields, String parentPath) {
        if ("object".equals(tempBk.getString("dataType"))) {
            String tempParentPath = parentPath + tempBk.getString("dataName") + ".";
            JSONArray fieldBks = tempBk.getJSONArray("field");
            fieldBks.forEach(fieldBk -> AbstractBkMetadataParser.recursion((JSONObject)fieldBk, bkFields, tempParentPath));
        }
        if (!"object".equals(tempBk.getString("dataType"))) {
            String bkName = tempBk.getString("bkName");
            if (StringUtils.isBlank((CharSequence)bkName) || "null".equalsIgnoreCase(bkName)) {
                bkName = tempBk.getString("dataName");
            }
            bkFields.put(bkName, parentPath + tempBk.getString("dataName"));
        }
    }
}

