/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.backlog;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.common.bk.service.BusinessKeyService;
import com.digiwin.athena.atmc.common.dao.BacklogMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityStepMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.dao.ptm.PtmBacklogMapper;
import com.digiwin.athena.atmc.common.dao.route.RouteDetailMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivity;
import com.digiwin.athena.atmc.common.domain.BpmActivityStep;
import com.digiwin.athena.atmc.common.domain.BpmActivityWorkitem;
import com.digiwin.athena.atmc.common.domain.BpmWorkitemAppendix;
import com.digiwin.athena.atmc.common.domain.ptm.PtmBacklog;
import com.digiwin.athena.atmc.common.domain.route.RouteDetail;
import com.digiwin.athena.atmc.common.enums.ActivityWorkitemSubState;
import com.digiwin.athena.atmc.common.enums.BpmEngineCategory;
import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.service.bpmworkitemappendix.BpmWorkitemAppendixService;
import com.digiwin.athena.atmc.common.service.ptm.PtmBacklogTransformService;
import com.digiwin.athena.atmc.common.service.ptm.PtmTransformService;
import com.digiwin.athena.atmc.common.util.PatternCategoryUtil;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.domain.Backlog;
import com.digiwin.athena.atmc.http.domain.task.ActivityDataDTO;
import com.digiwin.athena.atmc.http.restful.bpm.BpmService;
import com.digiwin.athena.atmc.http.restful.bpm.TaskEngineService;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskPreApproveRequestDTO;
import com.digiwin.athena.atmc.http.restful.ptm.PtmService;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWorkItemRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskCategory;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskPattern;
import com.github.pagehelper.util.StringUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BacklogActionCreateService {
    @Autowired
    private BpmActivityMapper bpmActivityMapper;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private BpmActivityStepMapper bpmActivityStepMapper;
    @Autowired
    private BpmService bpmService;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private RouteDetailMapper routeDetailMapper;
    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;
    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private TaskEngineService taskEngineService;
    @Autowired
    private PtmTransformService ptmTransformService;
    @Autowired
    private BusinessKeyService businessKeyService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory) {
        void var10_12;
        ActivityDataDTO backLogMap = null;
        Boolean isPtm = true;
        List<Object> list = this.ptmTransformService.getActivityDataByBacklogId(workitemId, isHistory);
        if (CollectionUtils.isEmpty(list)) {
            list = this.backlogMapper.getActivityDatasByBacklogId(workitemId);
            isPtm = false;
        }
        BpmActivityWorkitem abnormalWorkitem = null;
        if (!isPtm.booleanValue() && (abnormalWorkitem = (BpmActivityWorkitem)this.bpmActivityWorkitemMapper.selectById(Long.valueOf(workitemId))) != null && abnormalWorkitem.getType() == 89) {
            list = this.backlogMapper.getActivityDatasByBacklogId(abnormalWorkitem.getSourceWorkitemId());
        }
        if (list.size() > 1) {
            if (!isPtm.booleanValue()) {
                Optional<ActivityDataDTO> mainWorkItem = list.stream().filter(item -> item.getGroupId() == null || item.getGroupId() == 0L).findFirst();
                if (mainWorkItem.isPresent()) {
                    backLogMap = mainWorkItem.get();
                }
                list = list.stream().filter(item -> item.getGroupId() != null && item.getGroupId() > 0L).collect(Collectors.toList());
            } else {
                backLogMap = list.get(0);
            }
        } else if (list.size() == 1) {
            backLogMap = list.get(0);
        }
        if (null == backLogMap && (backLogMap = this.backlogMapper.getInternalErrorActivityDataByBacklogId(workitemId)) != null) {
            isPtm = false;
            backLogMap.setTmPattern("BUSINESS");
            backLogMap.setTmCategory("ERROR");
            backLogMap.setTmShowFlow(Boolean.FALSE);
            backLogMap.setProcessCreateTime(backLogMap.getTaskStartTime());
            backLogMap.setTmTaskId("__uibot__");
            backLogMap.setTmActivityId("uibotInternalError");
        }
        if (backLogMap == null) {
            throw ErrorCodeEnum.ACTIVITY_CAN_NOT_FIND.getBusinessExceptionWithArgs(new Object[]{workitemId});
        }
        if (backLogMap.getOverdueWorkitemId() != null && backLogMap.getOverdueWorkitemId() > 0L) {
            backLogMap.setTmTaskId("__uibot__");
            backLogMap.setTmActivityId("uibot_overdue_task");
            backLogMap.setTmPattern("UIBOT");
            backLogMap.setTmCategory("UIBOT");
            backLogMap.setTmShowFlow(Boolean.valueOf(false));
            if (!Objects.equals(backLogMap.getDataFrom(), "PTM")) {
                Backlog originalBacklog = this.backlogMapper.selectFirstByActivityStepId(backLogMap.getStepId());
                backLogMap.setPerformerId(originalBacklog.getPerformerId());
                backLogMap.setPerformerName(originalBacklog.getPerformerName());
                backLogMap.setPlanEndTime(originalBacklog.getEndTime());
            }
            backLogMap.setTmActivityName("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}");
            backLogMap.setBacklogName("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}");
            backLogMap.setProxyToken(null);
        }
        if (abnormalWorkitem != null) {
            backLogMap.setType(abnormalWorkitem.getType());
        }
        for (ActivityDataDTO activityDataDTO : list) {
            if (!isPtm.booleanValue()) {
                BpmActivityWorkitem workItem = BpmActivityWorkitem.builder().id(activityDataDTO.getWorkItemId()).activityStepId(activityDataDTO.getStepId()).performerId(activityDataDTO.getPerformerId()).performerName(activityDataDTO.getPerformerName()).workitemId(activityDataDTO.getBpmWorkItemId()).sourceWorkitemId(activityDataDTO.getSourceWorkitemId()).createType(activityDataDTO.getCreateType()).state(activityDataDTO.getState()).subState(activityDataDTO.getSubState()).agentPerformerId(activityDataDTO.getAgentPerformerId()).agentPerformerName(activityDataDTO.getAgentPerformerName()).comment(activityDataDTO.getComment()).performerType(activityDataDTO.getPerformerType()).overdueWorkitemId(activityDataDTO.getOverdueWorkitemId()).type(activityDataDTO.getType()).createType(activityDataDTO.getCreateType()).groupId(activityDataDTO.getGroupId()).build();
                if (activityDataDTO != null) {
                    if (Objects.equals(activityDataDTO.getType(), 11)) {
                        List<BpmActivityWorkitem> workitemList = this.bpmActivityWorkitemMapper.selectNormalByStepSqlId(workItem.getActivityStepId());
                        if (CollectionUtils.isEmpty(workitemList)) {
                            activityDataDTO.setWorkitemList("[" + JsonUtils.objectToString((Object)workItem) + "]");
                        } else {
                            activityDataDTO.setWorkitemList("[" + JsonUtils.objectToString((Object)workitemList.get(0)) + "]");
                        }
                    } else {
                        activityDataDTO.setWorkitemList("[" + JsonUtils.objectToString((Object)workItem) + "]");
                    }
                } else {
                    activityDataDTO.setWorkitemList(null);
                }
            }
            if (backLogMap.getType() != 89) continue;
            activityDataDTO.setBacklogName("{\"zh_TW\":\"\u696d\u52d9\u6578\u64da\u4e0d\u4e00\u81f4\u7570\u5e38\u6392\u9664\",\"en_US\":\"Abnormal Exclude\",\"zh_CN\":\"\u4e1a\u52a1\u6570\u636e\u4e0d\u4e00\u81f4\u5f02\u5e38\u6392\u9664\"}");
            activityDataDTO.setPlanEndTime(null);
        }
        Map<String, Object> map = this.getActions(list, "", isPtm);
        map.put("dataFrom", backLogMap.getDataFrom());
        this.processSolve(workitemId, backLogMap, map);
        this.processApproval(workitemId, backLogMap, map);
        this.processReplyInvite(workitemId, backLogMap.getTmCategory(), map);
        this.processApprove(backLogMap, map);
        BpmActivityWorkitem bpmActivityWorkitem = this.bpmActivityWorkitemMapper.selectReapprovalInfoById(workitemId);
        if (bpmActivityWorkitem == null) {
            BpmActivityWorkitem bpmActivityWorkitem2 = this.ptmTransformService.getReapprovalInfoById(workitemId);
        }
        map.put("reapprovalInfo", var10_12);
        List<Long> workitemIdList = list.stream().map(ActivityDataDTO::getWorkItemId).collect(Collectors.toList());
        List<Map> differentDataList = this.businessKeyService.queryDifferentDataByWorkitemId(authoredUser.getTenantId(), workitemIdList);
        List<BpmActivityWorkitem> dataUniformifyTask = this.businessKeyService.queryDataUniformifyTasks(workitemId);
        map.put("abnormalData", differentDataList);
        map.put("abnormalCards", dataUniformifyTask);
        map.put("type", backLogMap.getType());
        map.put("abnormalWorkitemId", workitemId);
        map.put("submitId", this.getSubmitId(workitemId));
        return map;
    }

    private Integer getSubmitId(Long workItemId) {
        Integer submitId = null;
        if (workItemId != null) {
            PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(workItemId));
            submitId = ptmBacklog != null ? ptmBacklog.getSubmitId() : null;
        }
        return submitId;
    }

    private void processApproval(long workitemId, ActivityDataDTO backLogMap, Map<String, Object> map) {
        String tmActivityId;
        if (Objects.equals(backLogMap.getTmCategory(), TmTaskCategory.SOLVE.getValue())) {
            return;
        }
        String tmTaskId = backLogMap.getTmTaskId();
        String targetApproveActivity = this.getTargetApproveActivity(tmTaskId, tmActivityId = backLogMap.getTmActivityId());
        if (StringUtils.isBlank((String)targetApproveActivity)) {
            return;
        }
        HashMap<String, Object> signProgressMap = new HashMap<String, Object>();
        signProgressMap.put("processSerialNumber", backLogMap.getProcessSerialNumber());
        ArrayList<String> activityIds = new ArrayList<String>();
        activityIds.add(targetApproveActivity);
        signProgressMap.put("tmActivityIds", activityIds);
        signProgressMap.put("workitemId", workitemId);
        List tasks = (List)map.get("tasks");
        if (!CollectionUtils.isEmpty((Collection)tasks)) {
            Map task = (Map)tasks.get(0);
            task.put("relationApproval", signProgressMap);
        }
    }

    private void processReplyInvite(long workitemId, String tmCategory, Map<String, Object> map) {
        BpmWorkitemAppendix appendix;
        if (Objects.equals(tmCategory, TmTaskCategory.REPLY.getValue()) && (appendix = this.bpmWorkitemAppendixService.getByBacklogId(workitemId)) != null && !Objects.equals(appendix.getErrorCode(), WorkitemAppendixType.ReSend.getValue())) {
            HashMap<String, Object> appendixMap = new HashMap<String, Object>();
            appendixMap.put("backlogId", appendix.getId());
            appendixMap.put("errorCode", appendix.getErrorCode());
            appendixMap.put("email", appendix.getEmail());
            appendixMap.put("supplierName", appendix.getSupplierName());
            List tasks = (List)map.get("tasks");
            if (!CollectionUtils.isEmpty((Collection)tasks)) {
                Map task = (Map)tasks.get(0);
                task.put("replyInvite", appendixMap);
            }
        }
    }

    private void processSolve(long workitemId, ActivityDataDTO backLogMap, Map<String, Object> map) {
        if (Objects.equals(TmTaskPattern.BUSINESS.getValue(), backLogMap.getTmPattern()) && Objects.equals(TmTaskCategory.SOLVE.getValue(), backLogMap.getTmCategory())) {
            List tasks;
            JSONArray jsonArray = new JSONArray();
            HashMap<String, List<String>> startApproveMap = new HashMap<String, List<String>>();
            List<Map> actList = this.bpmActivityMapper.selectNoFinishedListByOriginBacklogId(workitemId);
            if (CollectionUtils.isEmpty(actList)) {
                actList = this.ptmBacklogTransformService.selectNoFinishedListByOriginBacklogIdForSolve(workitemId);
            }
            for (Map m : actList) {
                JSONObject dataJson = JSONObject.fromObject(m.get("data"));
                if (!dataJson.containsKey((Object)"originalQueryVariableName")) continue;
                String detailField = null;
                if (dataJson.containsKey((Object)"detailField") && dataJson.get("detailField") != null) {
                    detailField = dataJson.getString("detailField");
                }
                String tmTaskId = m.get("tm_task_id").toString();
                String tmActivityId = m.get("tm_activity_id").toString();
                List<String> startApproveIdList = null;
                if (startApproveMap.containsKey(tmActivityId)) {
                    startApproveIdList = (List<String>)startApproveMap.get(tmActivityId);
                } else {
                    startApproveIdList = this.getStartApproveActivity(tmTaskId, tmActivityId);
                    startApproveMap.put(tmActivityId, startApproveIdList);
                }
                if (CollectionUtils.isEmpty(startApproveIdList) || !startApproveIdList.contains(backLogMap.getTmActivityId())) continue;
                HashMap<String, Object> terminateMap = new HashMap<String, Object>();
                if (m.containsKey("dataFrom") && Objects.equals(m.get("dataFrom"), "PTM")) {
                    terminateMap.put("serialNumber", m.get("processSerialNumber"));
                    terminateMap.put("performerId", m.get("personInCharge"));
                    terminateMap.put("performerType", 0);
                    terminateMap.put("comment", "");
                } else {
                    BpmActivityStep activityStep = this.bpmActivityStepMapper.selectNoCompletedByBpmActivitySqlId(Long.valueOf(m.get("bpmActivitySqlId").toString()));
                    JSONObject workItem = activityStep.getWorkitemList().getJSONObject(0);
                    terminateMap.put("processSerialNumber", m.get("process_serial_number"));
                    terminateMap.put("performerId", workItem.get("performerId"));
                    terminateMap.put("workitemId", workItem.get("workitemId"));
                    terminateMap.put("comment", "");
                    terminateMap.put("locale", LocaleContextHolder.getLocale().toString());
                }
                JSONArray dataKeys = dataJson.getJSONArray(dataJson.getString("originalQueryVariableName"));
                List<JSONObject> detailAllDataKeys = this.getDetailAllDataKeys(dataKeys, detailField);
                for (int i = 0; i < dataKeys.size(); ++i) {
                    JSONObject dkJson = dataKeys.getJSONObject(i);
                    if (detailField != null && dkJson.containsKey((Object)detailField)) {
                        JSONArray subKeys = dkJson.getJSONArray(detailField);
                        for (Object o : subKeys) {
                            JSONObject kv = new JSONObject();
                            kv.put((Object)"dataKey", o);
                            kv.put((Object)"processParameter", terminateMap);
                            kv.put((Object)"allKey", detailAllDataKeys);
                            jsonArray.add((Object)kv);
                        }
                        continue;
                    }
                    JSONObject kv = new JSONObject();
                    kv.put((Object)"dataKey", (Object)dkJson);
                    kv.put((Object)"processParameter", terminateMap);
                    kv.put((Object)"allKey", (Object)dataKeys);
                    jsonArray.add((Object)kv);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)jsonArray) && !CollectionUtils.isEmpty((Collection)(tasks = (List)map.get("tasks")))) {
                tasks.forEach(task -> {
                    Map taskMap = (Map)task;
                    taskMap.put("abortDataKeys", jsonArray);
                });
            }
        }
    }

    private List<JSONObject> getDetailAllDataKeys(JSONArray dataKeys, String detailField) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (int i = 0; i < dataKeys.size(); ++i) {
            JSONObject dkJson = dataKeys.getJSONObject(i);
            if (detailField == null || !dkJson.containsKey((Object)detailField)) continue;
            result.addAll((Collection<JSONObject>)dkJson.getJSONArray(detailField));
        }
        return result;
    }

    private void processApprove(ActivityDataDTO backLogMap, Map<String, Object> map) {
        if (backLogMap == null || org.springframework.util.StringUtils.isEmpty((Object)backLogMap.getWorkitemList()) || !PatternCategoryUtil.isApproval(backLogMap.getTmCategory())) {
            return;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)backLogMap.getWorkitemList());
        String workItemId = jsonArray.getJSONObject(0).getString("workitemId");
        if (org.springframework.util.StringUtils.isEmpty((Object)workItemId)) {
            return;
        }
        if (!Objects.equals("PTM", backLogMap.getDataFrom())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)this.getPreApproveList(workItemId).getActivities())) {
            return;
        }
        map.put("hasApprove", true);
    }

    private BpmTaskApprovePreviousActivityDTO getPreApproveList(String workItemId) {
        BpmTaskPreApproveRequestDTO requestDTO = BpmTaskPreApproveRequestDTO.builder().locale(LocaleContextHolder.getLocale().toLanguageTag()).workitemId(workItemId).build();
        return this.taskEngineService.queryPreApprove(requestDTO);
    }

    private List<String> getStartApproveActivity(String tmTaskId, String tmActivityId) {
        TmActivityResponseDTO resonse = this.themeMapService.getActivityAction(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
        return resonse.getStartApproveActivity();
    }

    private String getTargetApproveActivity(String tmTaskId, String tmActivityId) {
        return this.themeMapService.getActivityTargetCode(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
    }

    public Object getViewActions(long taskId, String tmActivityId) {
        List<ActivityDataDTO> activityDataDTOS = null;
        boolean isPtm = true;
        activityDataDTOS = this.ptmTransformService.getViewActionsByProjectId(taskId, tmActivityId);
        if (CollectionUtils.isEmpty(activityDataDTOS)) {
            activityDataDTOS = this.bpmActivityMapper.selectActivityDataByTaskId(taskId, tmActivityId);
            isPtm = false;
        }
        return this.getActions(activityDataDTOS, "", isPtm);
    }

    public Object getTaskEngineViewActions(String taskIds, String tmActivityId, String activityPass, String routeIds) {
        List<ActivityDataDTO> activityDataDTOS = null;
        if (StringUtil.isNotEmpty((String)taskIds) && StringUtil.isNotEmpty((String)tmActivityId)) {
            Object[] taskIdArr = taskIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"pass", (Object)activityPass);
            queryWrapper.in((Object)"task_id", taskIdArr);
            List routeDetailList = this.routeDetailMapper.selectList((Wrapper)queryWrapper);
            if (routeDetailList != null && routeDetailList.size() > 0) {
                ArrayList<Long> bpmActivityIdList = new ArrayList<Long>();
                for (RouteDetail routeDetail : routeDetailList) {
                    bpmActivityIdList.add(routeDetail.getBpmActivityId());
                }
                activityDataDTOS = this.bpmActivityMapper.selectTaskEngineTaskActivityData(tmActivityId, taskIds.split(","), bpmActivityIdList);
            }
        }
        boolean isPtm = false;
        if (CollectionUtils.isEmpty(activityDataDTOS)) {
            activityDataDTOS = this.ptmTransformService.selectTaskEngineProjectCardActivityData(taskIds, activityPass);
            isPtm = true;
        }
        return this.getActions(activityDataDTOS, BpmEngineCategory.TaskEngine.getCategory(), isPtm);
    }

    private Map<String, Object> getActions(List<ActivityDataDTO> list, String engineType, boolean isPtm) {
        if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
            return null;
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        ActivityDataDTO activityDataDTO = list.get(0);
        HashMap<String, Object> project = new HashMap<String, Object>();
        root.put("project", project);
        project.put("projectId", activityDataDTO.getTaskId());
        project.put("tmProjectId", activityDataDTO.getTmTaskId());
        project.put("chargeId", activityDataDTO.getChargeId());
        project.put("chargeName", activityDataDTO.getChargeName());
        project.put("tenantId", activityDataDTO.getTenantId());
        project.put("startTime", activityDataDTO.getTaskStartTime());
        project.put("endTime", activityDataDTO.getTaskEndTime());
        project.put("projectName", activityDataDTO.getTaskName());
        project.put("processCreateTime", activityDataDTO.getProcessCreateTime());
        project.put("projectBpmData", activityDataDTO.getProjectBpmData() == null ? null : JsonUtils.jsonToObject((String)activityDataDTO.getProjectBpmData(), Map.class));
        if (!org.springframework.util.StringUtils.isEmpty((Object)activityDataDTO.getTaskSourceIds())) {
            ArrayList<String> ids = new ArrayList<String>();
            for (String item : activityDataDTO.getTaskSourceIds().split(",")) {
                ids.add(item);
            }
            project.put("sourceIds", ids);
        }
        ArrayList<String> processSerialNumberList = new ArrayList<String>();
        for (ActivityDataDTO dataDTO : list) {
            String key = dataDTO.getProcessSerialNumber() + dataDTO.getTaskUid();
            if (processSerialNumberList.contains(key)) continue;
            processSerialNumberList.add(key);
        }
        ArrayList tasks = new ArrayList();
        root.put("tasks", tasks);
        block2: for (String processSerialNumber : processSerialNumberList) {
            List activities = list.stream().filter(x -> (x.getProcessSerialNumber() + x.getTaskUid()).equals(processSerialNumber)).collect(Collectors.toList());
            Collections.sort(activities, (o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                }
                return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
            });
            Optional activityOpt = activities.stream().findFirst();
            if (activityOpt.isPresent()) {
                activityDataDTO = (ActivityDataDTO)activityOpt.get();
            }
            HashMap<String, Object> taskObject = new HashMap<String, Object>();
            tasks.add(taskObject);
            taskObject.put("processSerialNumber", activityDataDTO.getProcessSerialNumber());
            taskObject.put("bpmActivitySqlId", activityDataDTO.getBpmActivitySqlId());
            taskObject.put("bpmData", activityDataDTO.getBpmData() == null ? null : JsonUtils.jsonToObject((String)activityDataDTO.getBpmData(), Map.class));
            taskObject.put("stateData", activityDataDTO.getBpmStateData() == null ? null : JsonUtils.jsonToObject((String)activityDataDTO.getBpmStateData(), Map.class));
            taskObject.put("tmActivityId", activityDataDTO.getTmActivityId());
            taskObject.put("compositionId", activityDataDTO.getCompositionId());
            taskObject.put("tmCategory", activityDataDTO.getTmCategory());
            taskObject.put("tmPattern", activityDataDTO.getTmPattern());
            taskObject.put("bpmActivityId", activityDataDTO.getBpmActivityId());
            taskObject.put("bpmActivityType", activityDataDTO.getBpmActivityType());
            taskObject.put("performerIds", activityDataDTO.getPerformerIds() == null ? null : JsonUtils.jsonToObject((String)activityDataDTO.getPerformerIds(), new ArrayList().getClass()));
            taskObject.put("businessUnit", activityDataDTO.getBusinessUnit() == null ? null : JsonUtils.jsonToObject((String)activityDataDTO.getBusinessUnit(), Map.class));
            taskObject.put("tmActivityName", activityDataDTO.getTmActivityName());
            taskObject.put("proxyToken", activityDataDTO.getProxyToken());
            taskObject.put("traceId", activityDataDTO.getTraceId());
            taskObject.put("type", activityDataDTO.getType());
            taskObject.put("taskUid", activityDataDTO.getTaskUid());
            ArrayList<String> eocNames = new ArrayList<String>();
            if (!org.springframework.util.StringUtils.isEmpty((Object)activityDataDTO.getEocName()) && !eocNames.contains(activityDataDTO.getEocName())) {
                eocNames.add(activityDataDTO.getEocName());
            }
            taskObject.put("eocName", eocNames);
            if (!org.springframework.util.StringUtils.isEmpty((Object)activityDataDTO.getApprovalState())) {
                taskObject.put("approvalState", GlobalConstant.backlogStatusMap.getOrDefault(activityDataDTO.getApprovalState(), ""));
                taskObject.put("isRapprovalInfoShow", activityDataDTO.getApprovalState());
            }
            ArrayList backlogs = new ArrayList();
            taskObject.put("backlog", backlogs);
            for (ActivityDataDTO dataDTO : activities) {
                if (dataDTO.getBacklogId() == null) continue;
                PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(dataDTO.getPtmBacklogId()));
                HashMap<String, Object> backlog = new HashMap<String, Object>();
                backlogs.add(backlog);
                backlog.put("backlogId", dataDTO.getWorkItemId());
                backlog.put("targetTenantId", dataDTO.getTargetTenantId());
                backlog.put("performerId", dataDTO.getPerformerId());
                backlog.put("performerName", dataDTO.getPerformerName());
                backlog.put("performerState", dataDTO.getPerformerState());
                backlog.put("readCount", dataDTO.getReadCount());
                backlog.put("startTime", dataDTO.getStartTime());
                backlog.put("planEndTime", dataDTO.getPlanEndTime());
                backlog.put("endTime", dataDTO.getEndTime());
                backlog.put("closed", dataDTO.getBacklogClosed());
                backlog.put("backlogName", dataDTO.getBacklogName());
                backlog.put("ptmBacklogId", dataDTO.getPtmBacklogId());
                backlog.put("submitId", ptmBacklog != null ? ptmBacklog.getSubmitId() : null);
                backlog.put("ptmWorkItemId", dataDTO.getPtmWorkItemId());
                backlog.put("merge", dataDTO.getMerge());
                backlog.put("planEndTimeMin", dataDTO.getPlanEndTimeMin());
                backlog.put("planEndTimeMax", dataDTO.getPlanEndTimeMax());
                backlog.put("createType", dataDTO.getCreateType());
                if (!org.springframework.util.StringUtils.isEmpty((Object)dataDTO.getEocName()) && !eocNames.contains(dataDTO.getEocName())) {
                    eocNames.add(dataDTO.getEocName());
                }
                if (dataDTO.getEndTime() == null) {
                    if (dataDTO.getMerge().booleanValue() && isPtm) {
                        backlog.put("remainTime", TimeUtils.dateInterval((LocalDateTime)LocalDateTime.now(), (LocalDateTime)dataDTO.getPlanEndTimeMin()));
                        backlog.put("overdueDate", TimeUtils.dateInterval((LocalDateTime)dataDTO.getPlanEndTimeMin(), (LocalDateTime)LocalDateTime.now()));
                    } else {
                        backlog.put("remainTime", TimeUtils.dateInterval((LocalDateTime)LocalDateTime.now(), (LocalDateTime)dataDTO.getPlanEndTime()));
                        backlog.put("overdueDate", TimeUtils.dateInterval((LocalDateTime)dataDTO.getPlanEndTime(), (LocalDateTime)LocalDateTime.now()));
                    }
                }
                backlog.put("workitemList", dataDTO.getWorkitemList() == null ? null : JsonUtils.jsonToObject((String)dataDTO.getWorkitemList(), tasks.getClass()));
                backlog.put("finishedActionId", dataDTO.getFinishedActionId());
                if (org.springframework.util.StringUtils.isEmpty((Object)dataDTO.getFinishedActionId()) && Objects.equals(3, dataDTO.getStepState())) {
                    if (Objects.equals(ActivityWorkitemSubState.END_TASK_UNDO.getValue(), dataDTO.getStepSubState())) {
                        backlog.put("finishedActionId", "athena_bpm_cancel");
                    } else {
                        backlog.put("finishedActionId", "uibot_action_id_finished");
                    }
                }
                backlog.put("bpmSignReason", dataDTO.getStepSignReason());
                if (Objects.equals(engineType, BpmEngineCategory.TaskEngine.getCategory())) continue;
                continue block2;
            }
        }
        return root;
    }

    public void reassignTask(BpmActivityWorkitem workitem, String newPerformerId, String comment, AuthoredUser user) {
        BpmActivityStep step = (BpmActivityStep)((Object)this.bpmActivityStepMapper.selectById(workitem.getActivityStepId()));
        BpmActivity bpmActivity = (BpmActivity)((Object)this.bpmActivityMapper.selectById(step.getActivityId()));
        String processSerialNumber = bpmActivity.getProcessSerialNumber();
        String performerId = workitem.getPerformerId();
        String workitemId = workitem.getWorkitemId();
        String bpmActivityId = step.getBpmActivityId();
        this.bpmService.reassignWorkitem(processSerialNumber, bpmActivityId, workitemId, performerId, newPerformerId, comment);
    }

    public Map<String, Object> getMainEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory) {
        BpmActivityWorkitem bpmActivityWorkitem = (BpmActivityWorkitem)this.bpmActivityWorkitemMapper.selectById(Long.valueOf(workitemId));
        if (bpmActivityWorkitem != null) {
            workitemId = bpmActivityWorkitem.getGroupId() != 0L ? bpmActivityWorkitem.getGroupId() : workitemId;
        } else {
            PtmWorkItemRecordDTO ptmWorkItemRecor = this.ptmService.getWorkItemRecord(Long.valueOf(workitemId));
            if (ptmWorkItemRecor != null) {
                workitemId = ptmWorkItemRecor.getBacklogId();
            }
        }
        return this.getEditActions(authoredUser, workitemId, isHistory);
    }
}

