/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.bpmworkitemappendix.impl;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.dao.BpmWorkitemAppendixMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivityWorkitem;
import com.digiwin.athena.atmc.common.domain.BpmWorkitemAppendix;
import com.digiwin.athena.atmc.common.domain.backlog.ReplyTaskMessageDTO;
import com.digiwin.athena.atmc.common.domain.ptm.PtmBacklog;
import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.service.bpmworkitemappendix.BpmWorkitemAppendixService;
import com.digiwin.athena.atmc.common.service.ptm.PtmBacklogTransformService;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BpmWorkitemAppendixServiceImpl
implements BpmWorkitemAppendixService {
    private static final Logger log = LoggerFactory.getLogger(BpmWorkitemAppendixServiceImpl.class);
    @Autowired
    private BpmWorkitemAppendixMapper bpmWorkitemAppendixMapper;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;
    private static MessageUtils staticMessageUtils;

    @Override
    public BpmWorkitemAppendix addReplyTaskByBpmWorkItemId(WorkitemAppendixType workitemAppendixType, Long workItemId, String email, String supplierName) {
        return this.addReplyTask(workitemAppendixType, workItemId, email, supplierName);
    }

    @Override
    public BpmWorkitemAppendix addReplyTaskByPtmBacklogId(WorkitemAppendixType workitemAppendixType, Long ptmBacklogId, String contact, String supplierName) {
        return this.addReplyTask(workitemAppendixType, ptmBacklogId, contact, supplierName);
    }

    private BpmWorkitemAppendix addReplyTask(WorkitemAppendixType workitemAppendixType, Long originalId, String contact, String supplierName) {
        if (workitemAppendixType != WorkitemAppendixType.Normal) {
            BpmWorkitemAppendix appendix = BpmWorkitemAppendix.builder().id(originalId).errorCode(workitemAppendixType.getValue()).email(contact).supplierName(supplierName).build();
            this.bpmWorkitemAppendixMapper.insert((Object)appendix);
            return (BpmWorkitemAppendix)((Object)this.bpmWorkitemAppendixMapper.selectById(appendix.getId()));
        }
        return null;
    }

    @Override
    public BpmWorkitemAppendix getByBacklogId(Long backlogId) {
        BpmWorkitemAppendix result = null;
        Long originalBacklogId = null;
        BpmActivityWorkitem workitem = this.bpmActivityWorkitemMapper.selectPartialById(backlogId);
        if (workitem != null) {
            List<BpmActivityWorkitem> workitemList = this.bpmActivityWorkitemMapper.selectAllByStepSqlId(workitem.getActivityStepId());
            if (CollectionUtils.isNotEmpty(workitemList)) {
                for (BpmActivityWorkitem wi : workitemList) {
                    if (!Objects.equals(wi.getType(), 1) || Objects.equals(wi.getId(), backlogId)) continue;
                    originalBacklogId = wi.getId();
                    break;
                }
            }
        } else {
            PtmBacklog backlog = this.ptmBacklogTransformService.getReplyOriginalBacklog(backlogId);
            if (backlog != null) {
                originalBacklogId = backlog.getBacklogId();
            }
        }
        if (originalBacklogId != null) {
            result = (BpmWorkitemAppendix)((Object)this.bpmWorkitemAppendixMapper.selectById(originalBacklogId));
        }
        return result;
    }

    @Override
    public ReplyTaskMessageDTO getReplyTaskMessage(Long backlogId) {
        ReplyTaskMessageDTO result = ReplyTaskMessageDTO.builder().code(0).build();
        BpmWorkitemAppendix appendix = this.getByBacklogId(backlogId);
        if (appendix != null) {
            result = BpmWorkitemAppendixServiceImpl.translateReplyTaskMessage(appendix.getErrorCode());
        }
        return result;
    }

    public static ReplyTaskMessageDTO translateReplyTaskMessage(Integer workitemAppendixType) {
        if (staticMessageUtils == null) {
            staticMessageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        }
        ReplyTaskMessageDTO result = ReplyTaskMessageDTO.builder().code(0).build();
        if (workitemAppendixType != null) {
            result.setCode(workitemAppendixType);
            switch (workitemAppendixType) {
                case 1001: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoEmail.1001"));
                    break;
                }
                case 1002: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoRegister.1002"));
                    break;
                }
                case 1003: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoPermission.1003"));
                    break;
                }
                case 1004: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.PermissionFull.1004"));
                    break;
                }
                case 1005: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.NoTenant.1005"));
                    break;
                }
                case 1006: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.Invited.1006"));
                    break;
                }
                case 1007: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.Inviting.1007"));
                    break;
                }
                case 1008: {
                    result.setMessage(staticMessageUtils.getMessage("reply.email.ReSend.1008"));
                }
            }
        }
        return result;
    }
}

