/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.bk.service;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.bk.domain.TEProjectBKLackData;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.mongodb.MongoDbQueryService;
import com.digiwin.athena.atmc.common.mongodb.MongodbService;
import com.digiwin.athena.atmc.common.mongodb.data.IndexData;
import com.digiwin.athena.atmc.common.util.BKUtils;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.restful.ptm.PtmService;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.github.pagehelper.util.StringUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BkTaskActivityService {
    private static final Logger log = LoggerFactory.getLogger(BkTaskActivityService.class);
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private MongodbService mongodbService;
    @Autowired
    private MongoDbQueryService mongoDbQueryService;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private PtmService ptmService;
    Map<String, Object> tmActivityDataSourceMap = new HashMap<String, Object>();

    public void insertOriBk(List<JSONObject> oriBkList, List<Object> oriObjBkList, Long cardId, String tenantId, String type) {
        this.insertOriBk(oriBkList, oriObjBkList, cardId, tenantId, type, "ori");
    }

    public void insertOriBk(List<JSONObject> oriBkList, List<Object> oriObjBkList, Long cardId, String tenantId, String type, String source) {
        HashMap<String, Object> dataMap;
        String collectionName = tenantId;
        IndexData indexData = new IndexData();
        indexData.append("cardId", 1);
        indexData.append("bkSearch.index", 1);
        this.mongodbService.createCollectionLock(collectionName, indexData.getIndexList());
        ArrayList<Map> dataList = new ArrayList<Map>();
        for (JSONObject jSONObject : oriBkList) {
            dataMap = new HashMap<String, Object>();
            String bkStr = JsonUtils.objectToString((Object)jSONObject);
            String bkContent = bkStr.replaceAll("[{}\\\"]", "").replace(",", "&");
            TreeMap treeMap = (TreeMap)JsonUtils.jsonToObject((String)bkStr, TreeMap.class);
            dataMap.put("bk", treeMap);
            TreeMap bkSortMap = BKUtils.recursionToTreeMap((Map<String, Object>)jSONObject);
            String searchJsonStr = JsonUtils.objectToString((Object)bkSortMap);
            String searchContent = searchJsonStr.replaceAll("[{}\\\"]", "").replace(",", "&");
            dataMap.put("searchContent", searchContent);
            dataMap.put("bkContent", bkContent);
            dataMap.put("cardId", cardId);
            dataMap.put("type", type);
            dataMap.put("tenantId", tenantId);
            dataMap.put("CREATE_DATE", LocalDateTime.now());
            dataMap.put("modifyDate", LocalDateTime.now());
            dataMap.put("source", source);
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndex((Map<String, Object>)jSONObject);
            dataMap.put("bkSearch", bkSearchList);
            dataMap.put("indexState", 1);
            dataList.add(dataMap);
        }
        for (Object object : oriObjBkList) {
            dataMap = new HashMap();
            dataMap.put("bk", object);
            dataMap.put("bkContent", object);
            dataMap.put("cardId", cardId);
            dataMap.put("type", type);
            dataMap.put("tenantId", tenantId);
            dataMap.put("CREATE_DATE", LocalDateTime.now());
            dataMap.put("modifyDate", LocalDateTime.now());
            dataMap.put("source", source);
            List<Map<String, Object>> bkSearchList = BKUtils.convertBkIndexSimple(object);
            dataMap.put("bkSearch", bkSearchList);
            dataMap.put("indexState", 1);
            dataList.add(dataMap);
        }
        log.info("{}", (Object)cardId);
        this.mongodbService.insert(dataList, collectionName);
    }

    public void updateBkTaskActivity(String collectionName, String bk, Long cardId, Map<String, Object> updateDataMap) {
        if (StringUtil.isEmpty((String)collectionName) || StringUtil.isEmpty((String)bk) || cardId == null) {
            throw ErrorCodeEnum.TASK_BK_PARAM_EMPTY.getBusinessException();
        }
        if (updateDataMap == null || updateDataMap.size() == 0) {
            return;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"bk").is((Object)bk).and("cardId").is((Object)cardId));
        Update update = new Update();
        for (Map.Entry<String, Object> entry : updateDataMap.entrySet()) {
            update.set(entry.getKey(), entry.getValue());
        }
        this.mongodbService.updateFirst(collectionName, query, update);
    }

    public List<Long> selectTaskIdByBusinessKey(String collectionName, List<Map> bkList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("bk").in(bkList));
        query.fields().include("bk").include("cardId").exclude("_id");
        List<Map> list = this.mongodbService.query(collectionName, query);
        return list.stream().map(y -> (Long)y.get("cardId")).collect(Collectors.toList());
    }

    public List<Long> selectTaskIdByBusinessKeyFuzzy(String collectionName, List<Map> bkList) {
        List<Map> list = this.selectTaskIdByBusinessKeyFuzzyV2(collectionName, bkList);
        return list.stream().map(y -> (Long)y.get("cardId")).collect(Collectors.toList());
    }

    public List<Map> selectTaskIdByBusinessKeyFuzzyV2(String collectionName, List<Map> bkList) {
        return this.selectTaskIdByBusinessKeyFuzzyV2(collectionName, "workitem", bkList);
    }

    public List<Map> selectTaskIdByBusinessKeyFuzzyV2(String collectionName, String type, List<Map> bkList) {
        return this.selectWithMultipleBusinessKeys(collectionName, type, bkList);
    }

    public List<Map> selectWithMultipleBusinessKeys(String collectionName, String type, List<Map> bkList) {
        List<List<String>> indexList = BKUtils.bkObjectToIndexList(bkList);
        ArrayList finalBkList = new ArrayList();
        for (List<String> tempList : indexList) {
            HashMap indexAndMap = new HashMap(1);
            ArrayList singleList = new ArrayList();
            for (String temp : tempList) {
                HashMap<String, String> singleMap = new HashMap<String, String>(1);
                singleMap.put("bkSearch.index", temp);
                singleList.add(singleMap);
            }
            indexAndMap.put("$and", singleList);
            finalBkList.add(indexAndMap);
        }
        HashMap filter = new HashMap();
        HashMap<String, String> andMap = new HashMap<String, String>();
        andMap.put("type", type);
        HashMap orMap = new HashMap();
        orMap.put("$or", finalBkList);
        ArrayList<HashMap<String, Object>> andList = new ArrayList<HashMap<String, Object>>();
        andList.add(andMap);
        andList.add(orMap);
        filter.put("$and", andList);
        HashMap<String, Integer> projectMap = new HashMap<String, Integer>();
        projectMap.put("bkSearch", 0);
        projectMap.put("indexState", 0);
        Map command = this.mongoDbQueryService.getExecuteQueryCommand(collectionName, filter, projectMap);
        log.info("selectWithMultipleBusinessKeys-command:{}", (Object)JsonUtils.objectToString((Object)command));
        List<Map> list = this.mongodbService.executeQueryCommand(command);
        return list;
    }

    public List<Long> queryCardWithSearchInfos(String collectionName, List<Map> bkList, String type) {
        Query query = new Query();
        if (StringUtil.isNotEmpty((String)type)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        }
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (Map tempMap : bkList) {
            TreeMap sortMap = BKUtils.recursionToTreeMap(tempMap);
            String tempJson = JsonUtils.objectToString((Object)sortMap);
            String searchContent = tempJson.replaceAll("\\{|}|\"", "").replace(",", "&");
            Criteria criteria = Criteria.where((String)"searchContent").is((Object)searchContent);
            criteriaList.add(criteria);
        }
        Criteria[] orCriteriaArr = new Criteria[criteriaList.size()];
        criteriaList.toArray(orCriteriaArr);
        Criteria criteria = new Criteria().orOperator(orCriteriaArr);
        query.addCriteria((CriteriaDefinition)criteria);
        List<Map> retList = this.mongodbService.query(collectionName, query);
        return retList.stream().map(y -> (Long)y.get("cardId")).collect(Collectors.toList());
    }

    public List<Map> selectBusinessKeyByTaskId(String collectionName, Long workitemId) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(workitemId);
        return this.selectBusinessKeyByTaskId(collectionName, list);
    }

    public List<Map> selectBusinessKeyByTaskId(String collectionName, List<Long> workitemIdList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(workitemIdList));
        query.fields().include("bk").include("cardId").include("cardId").exclude("_id");
        return this.mongodbService.query(collectionName, query);
    }

    public List<Map> selectBusinessKeyByProjectId(String collectionName, List<Long> projectIdList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"task").and("cardId").in(projectIdList));
        query.fields().include("bk").include("cardId").include("cardId").exclude("_id");
        return this.mongodbService.query(collectionName, query);
    }

    public List<Map> selectBusinessKeyByTaskIdIgnoreSource(String collectionName, List<Long> workitemIdList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"type").is((Object)"workitem").and("cardId").in(workitemIdList));
        query.fields().include("bk").include("cardId").include("cardId").exclude("_id");
        return this.mongodbService.query(collectionName, query);
    }

    public List<Map> selectByParam(String collectionName, String paramStr, String type) {
        return this.selectByParamWithIndex(collectionName, paramStr, type);
    }

    public List<Map> selectByParamWithIndex(String collectionName, String paramStr, String type) {
        boolean isJson;
        Query query = new Query();
        if (StringUtil.isNotEmpty((String)type)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)type));
        }
        if (!(isJson = BKUtils.checkJsonStr(paramStr))) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"bkSearch.index").is((Object)paramStr));
        } else {
            Map bkParam = (Map)JsonUtils.jsonToObject((String)paramStr, Map.class);
            List<String> bkIndexList = BKUtils.bkObjectToIndex(bkParam);
            Criteria singleCriteria = new Criteria();
            ArrayList criteriaList = new ArrayList();
            bkIndexList.forEach(x -> {
                Criteria criteria = Criteria.where((String)"bkSearch.index").is(x);
                criteriaList.add(criteria);
            });
            singleCriteria.andOperator(criteriaList.toArray(new Criteria[0]));
            query.addCriteria((CriteriaDefinition)singleCriteria);
        }
        query.fields().exclude("bkSearch").exclude("indexState");
        log.debug("query:{}", (Object)query);
        return this.mongodbService.query(collectionName, query);
    }

    public <T> List<Map> selectByParamV2(String collectionName, List<T> businessKeys, String type) {
        List bkList = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(businessKeys), Map.class);
        return this.selectTaskIdByBusinessKeyFuzzyV2(collectionName, bkList);
    }

    private List<String> dealParamJson(String param) {
        ArrayList<String> resultList = new ArrayList<String>();
        Map paramMap = (Map)JsonUtils.jsonToObject((String)param, Map.class);
        for (Map.Entry entry : paramMap.entrySet()) {
            this.getChildrenParam(resultList, (String)entry.getKey(), entry.getValue());
        }
        return resultList;
    }

    private void getChildrenParam(List<String> paramList, String key, Object object) {
        String param = "";
        if (object instanceof Collection) {
            List list = (List)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)object), List.class);
            for (Object obj : list) {
                this.getChildrenParam(paramList, key, obj);
            }
        } else if (object instanceof Map) {
            Map map = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)object), Map.class);
            for (Map.Entry entry : map.entrySet()) {
                this.getChildrenParam(paramList, (String)entry.getKey(), entry.getValue());
            }
        } else {
            param = key + ":" + object;
            paramList.add(param);
        }
    }

    public void deleteIndexFromCollections(String deleteIndexName) {
        this.mongodbService.deleteIdexFromCollections(deleteIndexName);
    }

    public void insertIndexFromCollections(Map<String, Object> indexMap) {
        this.mongodbService.insertIndex(indexMap);
    }

    public Map<String, Object> getTmBusinessKeyNew(String tmTaskId, String tmActivityId, JSONObject bpmData) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<JSONObject> bkValueList = new ArrayList<JSONObject>();
        ArrayList<Object> bkObjectValueList = new ArrayList<Object>();
        Map dataSourcesMap = null;
        if (this.tmActivityDataSourceMap.containsKey(tmTaskId + tmActivityId) && this.tmActivityDataSourceMap.get(tmTaskId + tmActivityId) != null) {
            dataSourcesMap = (Map)this.tmActivityDataSourceMap.get(tmTaskId + tmActivityId);
        } else {
            Map tmActivityMap = this.themeMapService.getActivityAction2(tmTaskId, tmActivityId, TmPageName.TASK_DETAIL_NAME.getValue());
            if (tmActivityMap != null && tmActivityMap.size() > 0) {
                Map map = dataSourcesMap = tmActivityMap.containsKey("dataSources") ? (Map)tmActivityMap.get("dataSources") : null;
            }
        }
        if (dataSourcesMap == null || dataSourcesMap.size() == 0) {
            return resultMap;
        }
        HashSet<String> businessKeySet = new HashSet<String>();
        for (Map.Entry entry : dataSourcesMap.entrySet()) {
            this.getTmActivityParams(businessKeySet, entry.getValue());
        }
        for (String key : businessKeySet) {
            if (!bpmData.containsKey((Object)key) || bpmData.get(key) == null) continue;
            if (bpmData.get(key) instanceof Collection) {
                JSONArray jsonArray = bpmData.getJSONArray(key);
                jsonArray.forEach(obj -> bkValueList.add(JSONObject.fromObject((Object)JsonUtils.objectToString((Object)obj))));
                continue;
            }
            if (bpmData.get(key) instanceof Map) {
                bkValueList.add(bpmData.getJSONObject(key));
                continue;
            }
            bkObjectValueList.add(bpmData.get(key));
        }
        if (!CollectionUtils.isEmpty(bkValueList)) {
            resultMap.put("complex", bkValueList);
        }
        if (!CollectionUtils.isEmpty(bkValueList)) {
            resultMap.put("simple", bkObjectValueList);
        }
        return resultMap;
    }

    public String getVariableName(String tmTaskId, String tmActivityId) {
        Map dataSourcesMap = null;
        if (this.tmActivityDataSourceMap.containsKey(tmTaskId + tmActivityId) && this.tmActivityDataSourceMap.get(tmTaskId + tmActivityId) != null) {
            dataSourcesMap = (Map)this.tmActivityDataSourceMap.get(tmTaskId + tmActivityId);
        } else {
            Map tmActivityMap = this.themeMapService.getActivityAction2(tmTaskId, tmActivityId, TmPageName.TASK_DETAIL_NAME.getValue());
            if (tmActivityMap != null && tmActivityMap.size() > 0) {
                Map map = dataSourcesMap = tmActivityMap.containsKey("dataSources") ? (Map)tmActivityMap.get("dataSources") : null;
            }
        }
        if (dataSourcesMap == null || dataSourcesMap.size() == 0) {
            return null;
        }
        HashSet<String> businessKeySet = new HashSet<String>();
        for (Map.Entry entry : dataSourcesMap.entrySet()) {
            this.getTmActivityParams(businessKeySet, entry.getValue());
        }
        if (CollectionUtils.isEmpty(businessKeySet)) {
            return null;
        }
        Optional businessKeyOptional = businessKeySet.stream().findFirst();
        return businessKeyOptional.orElse(null);
    }

    public Map<String, String> getVariableName(String tmTaskId, List<String> tmActivityIdList) {
        HashMap<String, String> taskVariableMap = new HashMap<String, String>();
        Map tmActivityMap = this.themeMapService.getActivityDefinitionListByPageCode(tmTaskId, tmActivityIdList, TmPageName.TASK_DETAIL_NAME.getValue());
        if (MapUtils.isEmpty((Map)tmActivityMap)) {
            return taskVariableMap;
        }
        for (String tmActivityId : tmActivityIdList) {
            Optional businessKeyOptional;
            Map dataSourcesMap;
            Map tmActivity = (Map)tmActivityMap.get(tmActivityId);
            if (MapUtils.isEmpty((Map)tmActivity) || MapUtils.isEmpty((Map)(dataSourcesMap = (Map)tmActivity.get("dataSources")))) continue;
            HashSet<String> businessKeySet = new HashSet<String>();
            for (Map.Entry entry : dataSourcesMap.entrySet()) {
                this.getTmActivityParams(businessKeySet, entry.getValue());
            }
            if (CollectionUtils.isEmpty(businessKeySet) || !(businessKeyOptional = businessKeySet.stream().findFirst()).isPresent()) continue;
            taskVariableMap.put(tmActivityId, (String)businessKeyOptional.get());
        }
        return taskVariableMap;
    }

    private void getTmActivityParams(Set<String> businessKeySet, Object dataObj) {
        block5: {
            block6: {
                if (!(dataObj instanceof Collection)) break block6;
                JSONArray list = JSONArray.fromObject((Object)dataObj);
                for (Object object : list) {
                    this.getTmActivityParams(businessKeySet, object);
                }
                break block5;
            }
            if (!(dataObj instanceof Map)) break block5;
            JSONObject map = JSONObject.fromObject((Object)dataObj);
            if (!map.containsKey("actionParams") || map.get("actionParams") == null) {
                for (Map.Entry entry : map.entrySet()) {
                    this.getTmActivityParams(businessKeySet, entry.getValue());
                }
            } else {
                JSONArray tmActionParameterDTOS = JSONArray.fromObject(map.get("actionParams"));
                for (JSONObject parameterDTO : tmActionParameterDTOS) {
                    if (!"PROCESS_VARIABLE".equals(parameterDTO.get("type"))) continue;
                    businessKeySet.add(parameterDTO.getString("value"));
                    break;
                }
            }
        }
    }

    public List<Long> insertLackDataByParam(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0 || !paramMap.containsKey("tenantId") || paramMap.get("tenantId") == null) {
            return new ArrayList<Long>();
        }
        String tenantId = paramMap.get("tenantId").toString();
        List<Map<String, Object>> workitemList = this.bpmActivityWorkitemMapper.selectWorkitemByParam(paramMap);
        if (CollectionUtils.isEmpty(workitemList)) {
            return new ArrayList<Long>();
        }
        return this.insertWorkitemBk(tenantId, workitemList);
    }

    private List<Long> insertWorkitemBk(String tenantId, List<Map<String, Object>> workitemList) {
        ArrayList<Long> errorWorkitem = new ArrayList<Long>();
        ArrayList<Long> workitemIdList = new ArrayList<Long>();
        HashMap<Long, Map<String, Object>> workitemMap = new HashMap<Long, Map<String, Object>>();
        for (Map<String, Object> workitemData : workitemList) {
            Long l = Long.valueOf(workitemData.get("id").toString());
            workitemIdList.add(l);
            workitemMap.put(l, workitemData);
        }
        List<Map> dataList = this.selectBusinessKeyByTaskId(tenantId, workitemIdList);
        if (!CollectionUtils.isEmpty(dataList)) {
            for (Map map : dataList) {
                Long workitemId = Long.valueOf(map.get("cardId").toString());
                workitemIdList.remove(workitemId);
            }
        }
        for (Long l : workitemIdList) {
            try {
                Map workitemData = (Map)workitemMap.get(l);
                String tmTaskId = workitemData.get("tmTaskId").toString();
                String tmActivityId = workitemData.get("tmActivityId").toString();
                Object data = workitemData.get("bpmData");
                if (data == null) continue;
                JSONObject bpmData = JSONObject.fromObject((Object)JsonUtils.objectToString(data));
                Map<String, Object> bkMap = this.getTmBusinessKeyNew(tmTaskId, tmActivityId, bpmData);
                JSONArray bkValueList = new ArrayList();
                if (bkMap.containsKey("complex")) {
                    bkValueList = JSONArray.fromObject((Object)bkMap.get("complex"));
                }
                JSONArray bkObjectValueList = new ArrayList();
                if (bkMap.containsKey("simple")) {
                    bkObjectValueList = JSONArray.fromObject((Object)bkMap.get("simple"));
                }
                this.insertOriBk((List<JSONObject>)bkValueList, (List<Object>)bkObjectValueList, l, tenantId, "workitem");
            }
            catch (Exception e) {
                errorWorkitem.add(l);
            }
        }
        return errorWorkitem;
    }

    public Object insertLackDataForTaskEngine(TEProjectBKLackData teProjectBKLackData) {
        if (!StringUtils.equals((String)teProjectBKLackData.getPassword(), (String)"majfa14537")) {
            throw BusinessException.create((String)"\u5bc6\u7801\u9519\u8bef");
        }
        HashMap<String, List> notFindProjects = new HashMap<String, List>();
        HashMap<String, List> lackBpmDataProjects = new HashMap<String, List>();
        Map<String, String> tenantTokenMap = teProjectBKLackData.getTokens().stream().collect(Collectors.toMap(TEProjectBKLackData.TenantToken::getTenantId, TEProjectBKLackData.TenantToken::getToken, (oldValue, newValue) -> oldValue));
        HashMap tenantProjectIdMap = new HashMap();
        teProjectBKLackData.getProjects().stream().forEach(project -> tenantProjectIdMap.computeIfAbsent(project.getTenantId(), tenantId -> new ArrayList()).add(project.getId()));
        HashMap<String, List> existBKProjects = new HashMap<String, List>();
        for (Map.Entry tenantProjectIds : tenantProjectIdMap.entrySet()) {
            String tenantId2 = (String)tenantProjectIds.getKey();
            List<Map> maps = this.selectBusinessKeyByProjectId(tenantId2, (List)tenantProjectIds.getValue());
            if (CollectionUtils.isEmpty(maps)) continue;
            Set cardIds = maps.stream().map(map -> (Long)MapUtil.get((Map)map, (Object)"cardId", Long.class)).collect(Collectors.toSet());
            existBKProjects.computeIfAbsent(tenantId2, key -> new ArrayList()).addAll(cardIds);
        }
        for (TEProjectBKLackData.TEProjectBKData project2 : teProjectBKLackData.getProjects()) {
            if (null != existBKProjects.get(project2.getTenantId()) && ((List)existBKProjects.get(project2.getTenantId())).contains(project2.getId())) continue;
            String token = tenantTokenMap.get(project2.getTenantId());
            PtmProjectRecordDTO projectRecord = this.getProjectRecord(project2.getId(), token);
            if (null != projectRecord) {
                if (null != projectRecord.getData() && null != projectRecord.getData().get("data")) {
                    List<JSONObject> bkDataList = this.parseBKData(projectRecord.getData().get("data"), teProjectBKLackData.getBkFields());
                    if (CollectionUtils.isEmpty(bkDataList)) continue;
                    this.insertOriBk(bkDataList, Collections.emptyList(), project2.getId(), project2.getTenantId(), "task");
                    continue;
                }
                lackBpmDataProjects.computeIfAbsent(project2.getTenantId(), tenantId -> new ArrayList()).add(project2.getId());
                continue;
            }
            notFindProjects.computeIfAbsent(project2.getTenantId(), tenantId -> new ArrayList()).add(project2.getId());
        }
        HashMap<String, HashMap<String, List>> result = new HashMap<String, HashMap<String, List>>();
        result.put("notFindProjects", notFindProjects);
        result.put("lackBpmDataProjects", lackBpmDataProjects);
        result.put("existBKProjects", existBKProjects);
        return result;
    }

    private List<JSONObject> parseBKData(Object bpmDataObj, List<String> bkFields) {
        ArrayList<JSONObject> bkDataList = new ArrayList<JSONObject>();
        ArrayList<Map> bpmDataList = new ArrayList<Map>();
        if (bpmDataList instanceof Collection) {
            bpmDataList.addAll((List)bpmDataObj);
        } else {
            bpmDataList.add((Map)bpmDataObj);
        }
        for (Map bpmData : bpmDataList) {
            JSONObject bkData = new JSONObject();
            for (String bkField : bkFields) {
                bkData.put((Object)bkField, MapUtil.get((Map)bpmData, (Object)bkField, Object.class));
            }
            bkDataList.add(bkData);
        }
        return bkDataList;
    }

    private PtmProjectRecordDTO getProjectRecord(Long projectCardId, String token) {
        this.resetAuthoredUser(token);
        try {
            return this.ptmService.getProjectRecord(projectCardId);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void resetAuthoredUser(String token) {
        AppAuthContextHolder.getContext().setAuthoredUser(null);
        AuthoredUser user = new AuthoredUser();
        user.setToken(token);
        AppAuthContextHolder.getContext().setAuthoredUser(user);
    }
}

