/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.mongodb;

import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;

public abstract class DistributeLocker {
    private static final Logger log = LoggerFactory.getLogger(DistributeLocker.class);
    private static final long TOTAL_SLEEP = 200L;
    private static final long SLEEP_STEP = 50L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryLock30s(RedisTemplate redisTemplate, String lockName, Action action) {
        boolean isLocked = false;
        String lockVal = UUID.randomUUID().toString();
        try {
            isLocked = DistributeLocker.tryLock(redisTemplate, lockName, lockVal, 30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            log.info("lockName\uff1a{},{}", (Object)lockName, (Object)ex);
            Thread.currentThread().interrupt();
        }
        if (isLocked) {
            try {
                action.action();
            }
            finally {
                DistributeLocker.releaseLock(redisTemplate, lockName);
            }
        }
    }

    public static boolean tryLock(RedisTemplate redisTemplate, String lockKey, String lockVal, long expireTime, TimeUnit timeUnit) throws InterruptedException {
        Boolean isLocked = redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)lockVal, expireTime, timeUnit);
        for (long totalSleep = 0L; !(null != isLocked && isLocked.booleanValue() || totalSleep >= 200L); totalSleep += 50L) {
            Thread.sleep(50L);
            isLocked = redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)lockVal, expireTime, timeUnit);
        }
        return BooleanUtils.isTrue((Boolean)isLocked);
    }

    public static void safeReleaseLock(RedisTemplate redisTemplate, String lockKey, String lockVal) {
        String script = "if ARGV[1]==redis.call('get', KEYS[1]) then redis.call('del', KEYS[1]) end return 'OK'";
        RedisScript redisScript = RedisScript.of((String)script, String.class);
        redisTemplate.execute(redisScript, Collections.singletonList(lockKey), new Object[]{lockVal});
        redisTemplate.delete((Object)lockKey);
    }

    public static void releaseLock(RedisTemplate redisTemplate, String lockKey) {
        redisTemplate.delete((Object)lockKey);
    }

    public static interface Action {
        public void action();
    }
}

