/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.backlog;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.common.dao.BacklogMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.dao.TaskWorkitemMessageMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivity;
import com.digiwin.athena.atmc.common.domain.TaskWorkitemMessage;
import com.digiwin.athena.atmc.common.domain.backlog.CardAbstractDTO;
import com.digiwin.athena.atmc.common.domain.ptm.PtmDataInfo;
import com.digiwin.athena.atmc.common.domain.task.BacklogDTO;
import com.digiwin.athena.atmc.common.mock.MockData;
import com.digiwin.athena.atmc.common.service.backlog.BacklogActionCreateService;
import com.digiwin.athena.atmc.common.service.backlog.BpmBacklogActionCreateService;
import com.digiwin.athena.atmc.common.service.bpmworkitemappendix.BpmWorkitemAppendixService;
import com.digiwin.athena.atmc.common.service.project.CommonProjectHandleService;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.common.util.ActivityUtils;
import com.digiwin.athena.atmc.common.util.BacklogAbstractUtil;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.constant.GlobalConstant;
import com.digiwin.athena.atmc.http.domain.Backlog;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActionDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActionParameterDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmReasonDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskCategory;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskPattern;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class CommonBacklogAbstractService {
    private static final Logger log = LoggerFactory.getLogger(CommonBacklogAbstractService.class);
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AglieService aglieService;
    @Autowired
    private BacklogActionCreateService backlogActionCreateService;
    @Autowired
    private BpmBacklogActionCreateService bpmBacklogActionCreateService;
    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Autowired
    private BpmActivityMapper bpmActivityMapper;
    @Autowired
    private BacklogMapper backlogMapper;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    TaskWorkitemMessageMapper taskWorkitemMessageMapper;
    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;
    @Resource
    private CommonProjectHandleService commonProjectHandleService;
    private static final String SUMMARY_LAYOUT_STR = "summaryLayoutStr";
    private static final String BACKLOG_OVERDUE_TASK_MSG = "backlog.overdue.task.msg";
    public static final String PTM_BACKLOG = "ptmBacklog";

    public TmActivityResponseDTO getTaskCardPageDefineByWorkItemId(long workItemId) {
        BacklogDTO backlogDTO = this.backlogMapper.selectBacklogForCard(workItemId);
        if (null == backlogDTO) {
            backlogDTO = this.commonPtmTransformService.selectBacklogForCard(workItemId);
            if (null == backlogDTO) {
                return null;
            }
            backlogDTO.setDataFrom("PTM");
        }
        if ("__uibot__".equals(backlogDTO.getTmTaskId())) {
            String tmActivityId;
            String bpmData = backlogDTO.getBpmData();
            if (StringUtils.isEmpty((String)bpmData)) {
                return null;
            }
            JSONObject bpmDataObj = JSONObject.fromObject((Object)bpmData);
            if (!bpmDataObj.containsKey((Object)"taskCode") && !bpmDataObj.containsKey((Object)"tmActivityId")) {
                return null;
            }
            String string = tmActivityId = StringUtils.isEmpty((String)bpmDataObj.getString("taskCode")) ? bpmDataObj.getString("tmActivityId") : bpmDataObj.getString("taskCode");
            if ("uibotManualTask".equals(tmActivityId)) {
                return null;
            }
            backlogDTO.setCalendar(true);
            backlogDTO.setTmActivityId(tmActivityId);
        }
        if (backlogDTO.getOverdueWorkitemId() != null && backlogDTO.getOverdueWorkitemId() > 0L) {
            backlogDTO.setTmTaskId("__uibot__");
            backlogDTO.setTmActivityId("uibot_overdue_task");
        }
        return this.themeMapService.getActivityAction(backlogDTO.getTmTaskId(), backlogDTO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
    }

    private Map<String, Object> initMap(Map<String, Object> result) {
        if (result == null) {
            return new HashMap<String, Object>();
        }
        return result;
    }

    public Map<String, Object> getCardTitle(PtmDataInfo ptmDataInfo) {
        Map result;
        Map<String, Object> workItem;
        Map<String, Object> activity;
        Map<String, Object> project;
        Map<String, Object> task = ptmDataInfo.getTask();
        if (task == null) {
            task = new HashMap<String, Object>();
            ptmDataInfo.setTask(task);
        }
        if ((project = ptmDataInfo.getProject()) == null) {
            project = new HashMap<String, Object>();
            ptmDataInfo.setProject(project);
        }
        if ((activity = ptmDataInfo.getActivity()) == null) {
            activity = new HashMap<String, Object>();
            ptmDataInfo.setActivity(activity);
        }
        if ((workItem = ptmDataInfo.getWorkItem()) == null) {
            workItem = new HashMap<String, Object>();
            ptmDataInfo.setWorkItem(workItem);
        }
        String taskId = MapUtils.getString(project, (Object)"projectDefCode");
        if (BooleanUtils.isTrue((Boolean)ptmDataInfo.getProjectCard())) {
            Long projectId = MapUtils.getLong(project, (Object)"id");
            Map<String, Object> activityData = this.commonProjectHandleService.getActivityData(project);
            activityData.put("needCardTitleOnly", Boolean.TRUE);
            log.info("\u83b7\u53d6\u9879\u76ee\u5361\u6807\u9898:{}", (Object)JsonUtils.objectToString(activityData));
            BaseResultDTO cardTitleResult = this.aglieService.getProjectCardDataByProjectDataAbstract(taskId, projectId, activityData);
            result = (Map)cardTitleResult.getResponse();
        } else {
            String tmActivityId = MapUtils.getString(task, (Object)"taskDefCode");
            Map<String, Object> ptmAction = this.backlogActionCreateService.getPtmAction(ptmDataInfo);
            if ("__uibot__".equals(taskId) && "uibotManualTask".equals(tmActivityId)) {
                ptmAction.put("calendar", true);
            }
            log.info("\u83b7\u53d6\u4efb\u52a1\u5361\u6807\u9898:{}", (Object)JsonUtils.objectToString(ptmAction));
            BaseResultDTO taskCardTitle = this.aglieService.getTaskCardTitle(taskId, tmActivityId, ptmAction);
            result = (Map)taskCardTitle.getResponse();
        }
        log.info("\u6807\u9898:{}", (Object)result);
        return result;
    }

    @MockData(type="detail")
    public Map getBacklogCardAbstractById(long workItemId, AuthoredUser user, boolean needHistoryInfo) {
        return this.getBacklogCardAbstractById(workItemId, user, new CardAbstractDTO().setNeedHistoryInfo(needHistoryInfo));
    }

    @MockData(type="detail")
    public Map getBacklogCardAbstractById(long workItemId, AuthoredUser user, CardAbstractDTO cardAbstractDTO) {
        String comment;
        boolean isApproval;
        BacklogDTO backlogDTO = this.commonPtmTransformService.selectBacklogForCard(workItemId);
        backlogDTO.setDataFrom("PTM");
        HashMap<String, String> checkItems_map = new HashMap<String, String>();
        if (backlogDTO.getOverdueWorkitemId() != null && backlogDTO.getOverdueWorkitemId() > 0L) {
            backlogDTO.setName("{\"zh_TW\":\"\u903e\u6642\u8655\u7406\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"\u903e\u65f6\u5904\u7406\"}");
            backlogDTO.setTmTaskId("__uibot__");
            backlogDTO.setTmActivityId("uibot_overdue_task");
            backlogDTO.setTmPattern("UIBOT");
            backlogDTO.setTmCategory("UIBOT");
            Backlog originalBacklog = this.getOriginalBacklog(backlogDTO.getOverdueWorkitemId());
            ArrayList<Map<String, Object>> checkItems = new ArrayList<Map<String, Object>>();
            backlogDTO.setCheckItems(checkItems);
            checkItems_map.put("item", this.messageUtils.getMessageWithFormat(BACKLOG_OVERDUE_TASK_MSG, new Object[]{MessageUtils.getMessageByCurrentLanguage((Object)originalBacklog.getName()), TimeUtils.dateInterval((LocalDateTime)originalBacklog.getEndTime(), (LocalDateTime)LocalDateTime.now())}));
            checkItems.add(checkItems_map);
            backlogDTO.setOperation(MessageUtils.getMessageByCurrentLanguage((Object)"{\"zh_TW\":\"\u8acb\u9078\u64c7\u8655\u7406\u65b9\u6848\",\"en_US\":\"Please choose a solution\",\"zh_CN\":\"\u8bf7\u9009\u62e9\u5904\u7406\u65b9\u6848\"}"));
        }
        if (GlobalConstant.DATA_UNIFORMITY_BACKLOG_TYPE.equals(backlogDTO.getType())) {
            backlogDTO.setName("{\"zh_TW\":\"\u696d\u52d9\u6578\u64da\u4e0d\u4e00\u81f4\u7570\u5e38\u6392\u9664\",\"en_US\":\"Abnormal Exclude\",\"zh_CN\":\"\u4e1a\u52a1\u6570\u636e\u4e0d\u4e00\u81f4\u5f02\u5e38\u6392\u9664\"}");
        }
        this.setCheckItems(user, backlogDTO);
        Map summaryLayoutStr = this.setSummaryLayoutStr(user, backlogDTO, cardAbstractDTO);
        String reapprovalInfoComment = "";
        boolean isAbnormal = org.springframework.util.StringUtils.pathEquals((String)TmTaskPattern.BUSINESS.getValue(), (String)backlogDTO.getTmPattern()) && org.springframework.util.StringUtils.pathEquals((String)TmTaskCategory.SOLVE.getValue(), (String)backlogDTO.getTmCategory());
        String targetApproveActivity = this.themeMapService.getActivityTargetCode(backlogDTO.getTmTaskId(), backlogDTO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
        boolean bl = isApproval = Objects.equals(backlogDTO.getTmPattern(), TmTaskPattern.BUSINESS.getValue()) && Objects.equals(backlogDTO.getTmCategory(), TmTaskCategory.APPROVAL.getValue());
        if (!(isAbnormal || StringUtils.isEmpty((String)targetApproveActivity) && !isApproval || StringUtils.isEmpty((String)(comment = this.commonPtmTransformService.getExecuteComment(workItemId))))) {
            reapprovalInfoComment = this.messageUtils.getMessage("reapproval.info.comment") + comment;
        }
        HashMap checkItemsMap = new HashMap();
        if (summaryLayoutStr != null) {
            if (summaryLayoutStr.containsKey(SUMMARY_LAYOUT_STR) && !StringUtils.isEmpty((String)summaryLayoutStr.get(SUMMARY_LAYOUT_STR).toString())) {
                if (!StringUtils.isEmpty((String)reapprovalInfoComment)) {
                    String summaryLayout = reapprovalInfoComment + "<br>" + summaryLayoutStr.get(SUMMARY_LAYOUT_STR).toString();
                    summaryLayoutStr.put(SUMMARY_LAYOUT_STR, summaryLayout);
                }
            } else {
                summaryLayoutStr.put(SUMMARY_LAYOUT_STR, reapprovalInfoComment);
            }
            checkItemsMap.put("summaryLayout", summaryLayoutStr.get(SUMMARY_LAYOUT_STR));
            checkItemsMap.put("historyMessage", summaryLayoutStr.get("historyMessage"));
            checkItemsMap.put("searchMessage", summaryLayoutStr.get("searchMessage"));
            checkItemsMap.put("cardState", summaryLayoutStr.get("cardState"));
        } else if (!StringUtils.isEmpty((String)reapprovalInfoComment)) {
            checkItemsMap.put("summaryLayout", reapprovalInfoComment);
        }
        String checkItemsStr = "";
        if (backlogDTO.getCheckItems() != null) {
            int value_i;
            checkItemsStr = backlogDTO.getCheckItems().get(0).get("item").toString();
            if (backlogDTO.getCheckItems().get(0).get("value") != null && (value_i = Integer.parseInt(backlogDTO.getCheckItems().get(0).get("value").toString())) != 0) {
                checkItemsStr = checkItemsStr + backlogDTO.getCheckItems().get(0).get("value").toString();
            }
            checkItemsMap.put("checkItems", checkItemsStr);
        }
        if (backlogDTO.getOperation() != null) {
            String operationStr = backlogDTO.getOperation();
            checkItemsMap.put("operation", operationStr);
        }
        if (!CollectionUtils.isEmpty(backlogDTO.getTodoItems())) {
            String todoItemStr = backlogDTO.getTodoItems().get(0).get("item").toString();
            checkItemsMap.put("todoItems", todoItemStr);
        }
        if (backlogDTO.getError() != null) {
            checkItemsMap.put("error", backlogDTO.getError().get("error").toString());
        }
        return checkItemsMap;
    }

    private Map setSummaryLayoutStr(AuthoredUser authoredUserm, BacklogDTO backlogDTO, CardAbstractDTO cardAbstractDTO) {
        Map<String, Object> activityData;
        Map<String, Object> activityDataMap = activityData = this.backlogActionCreateService.getEditActions(authoredUserm, backlogDTO.getId(), null);
        Map cardAbstractMap = null;
        try {
            activityDataMap.put("needHistoryInfo", cardAbstractDTO.getNeedHistoryInfo());
            activityDataMap.put("calendar", backlogDTO.getCalendar());
            BaseResultDTO actionResponse = this.aglieService.getTaskCardAbstractStr(backlogDTO.getTmTaskId(), backlogDTO.getTmActivityId(), backlogDTO.getId(), activityDataMap, cardAbstractDTO.getCount());
            cardAbstractMap = (Map)actionResponse.getResponse();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("error", e.getMessage());
            backlogDTO.setError(error);
        }
        if (BooleanUtils.isTrue((Boolean)cardAbstractDTO.getNeedBusinessMessage())) {
            activityDataMap.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
            activityDataMap.put("cardId", cardAbstractDTO.getCardId());
            activityDataMap.put("pageCode", TmPageName.TASK_CARD_NAME.getValue());
            activityDataMap.put("tmTaskId", backlogDTO.getTmTaskId());
            activityDataMap.put("tmActivityId", backlogDTO.getTmActivityId());
            activityDataMap.put("tenantId", authoredUserm.getTenantId());
            log.info("\u6d41\u7a0b\u53d8\u91cf\u6570\u636e\u5b58\u5165id:{}", (Object)cardAbstractDTO.getCardId());
            this.backlogAbstractUtil.getAndSaveBusinessMessage(activityDataMap);
        }
        return cardAbstractMap == null ? Maps.newHashMap() : cardAbstractMap;
    }

    public void saveTaskSaveBusinessMessage(AuthoredUser authoredUserm, CardAbstractDTO cardAbstractDTO) {
        Map<String, Object> activityData;
        Long cardId = cardAbstractDTO.getCardId();
        BacklogDTO backlogDTO = this.commonPtmTransformService.selectBacklogForCard(cardId);
        if (backlogDTO != null && backlogDTO.getTmActivityId() != null && (activityData = this.backlogActionCreateService.getEditActions(authoredUserm, backlogDTO.getId(), null)) instanceof Map) {
            Map<String, Object> activityDataMap = activityData;
            activityDataMap.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
            activityDataMap.put("cardId", cardId);
            activityDataMap.put("pageCode", TmPageName.TASK_CARD_NAME.getValue());
            activityDataMap.put("tmTaskId", backlogDTO.getTmTaskId());
            activityDataMap.put("tmActivityId", backlogDTO.getTmActivityId());
            activityDataMap.put("tenantId", authoredUserm.getTenantId());
            log.info("\u6d41\u7a0b\u53d8\u91cf\u6570\u636e\u5b58\u5165id:{}", (Object)cardId);
            this.backlogAbstractUtil.getAndSaveBusinessMessage(activityDataMap);
        }
    }

    public Backlog getOriginalBacklog(Long overdueWorkitemId) {
        return this.commonPtmTransformService.translateBacklogById(overdueWorkitemId);
    }

    public void setCheckItems(AuthoredUser authoredUser, BacklogDTO backlogDTO) {
        if (Objects.equals("UIBOT", backlogDTO.getTmPattern()) && Objects.equals("UIBOT", backlogDTO.getTmCategory())) {
            return;
        }
        String tmTaskId = backlogDTO.getTmTaskId();
        TmActivityResponseDTO themeActivity = this.themeMapService.getActivityAction(tmTaskId, backlogDTO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
        backlogDTO.setSubName(themeActivity.getStartApproveActivityName());
        if (Objects.equals("MECHANISM", backlogDTO.getTmPattern()) && Objects.equals("SUGGESTION", backlogDTO.getTmCategory())) {
            this.setReasonToCheckItems(backlogDTO, themeActivity);
            return;
        }
        if (Objects.equals("MECHANISM", backlogDTO.getTmPattern()) && Objects.equals("APPROVAL", backlogDTO.getTmCategory())) {
            this.setMechanismAppovalCheckItems(backlogDTO, themeActivity);
            return;
        }
        if (Objects.equals("ADJUSTMENT", backlogDTO.getTmPattern()) && Objects.equals("ADJUSTMENT", backlogDTO.getTmCategory())) {
            this.setReasonToCheckItems(backlogDTO, themeActivity);
            return;
        }
        if (Objects.equals("MECHANISM", backlogDTO.getTmPattern()) && Objects.equals("POSITIONSUGGESTION", backlogDTO.getTmCategory())) {
            this.setReasonToCheckItems(backlogDTO, themeActivity);
            return;
        }
        if (Objects.equals("MECHANISM", backlogDTO.getTmPattern()) && Objects.equals("POSITIONAPPROVAL", backlogDTO.getTmCategory())) {
            this.setReasonToCheckItems(backlogDTO, themeActivity);
            return;
        }
        boolean needCountData = true;
        if (themeActivity.hasCheckItems()) {
            backlogDTO.setCheckItems(ActivityUtils.getCheckItemsResult(themeActivity.getCheckItems(), 0));
            needCountData = false;
        }
        if (themeActivity.hasOperations()) {
            Optional tmOperation = themeActivity.getPages().getOperations().stream().findFirst();
            tmOperation.ifPresent(tmOperationDTO -> backlogDTO.setOperation(tmOperationDTO.getDescription()));
            needCountData = false;
        }
        if (themeActivity.existSummaryFields()) {
            needCountData = false;
        }
        if (needCountData) {
            this.setTodo(authoredUser, backlogDTO);
        }
        backlogDTO.setBpmActivityId(null);
    }

    public void setReasonToCheckItems(BacklogDTO backlogDTO, TmActivityResponseDTO tmActivityResponseDTO) {
        if (tmActivityResponseDTO.getPages() == null || tmActivityResponseDTO.getPages().getReason() == null) {
            return;
        }
        TmReasonDTO reasonDTO = tmActivityResponseDTO.getPages().getReason();
        ArrayList<Map<String, Object>> checkItems = new ArrayList<Map<String, Object>>();
        backlogDTO.setCheckItems(checkItems);
        HashMap<String, String> checkItemMap = new HashMap<String, String>();
        checkItemMap.put("item", MessageUtils.getMessageByCurrentLanguage((Object)reasonDTO.getTitle()));
        checkItems.add(checkItemMap);
        if (!"ADJUSTMENT".equals(tmActivityResponseDTO.getPattern()) && reasonDTO.getContent() != null) {
            backlogDTO.setOperation(MessageUtils.getMessageByCurrentLanguage((Object)reasonDTO.getContent().getText()));
        }
    }

    public void setMechanismAppovalCheckItems(BacklogDTO backlogDTO, TmActivityResponseDTO tmActivityResponseDTO) {
        String formulaId;
        Map formulaMap;
        Map dataSources = tmActivityResponseDTO.getDataSources();
        if (MapUtils.isEmpty((Map)dataSources) || !dataSources.containsKey("newFormulaData")) {
            return;
        }
        TmActionDTO newFormulaAction = (TmActionDTO)dataSources.get("newFormulaData");
        List paras = newFormulaAction.getActionParams();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)paras)) {
            return;
        }
        BpmActivity bpmActivity = (BpmActivity)((Object)this.bpmActivityMapper.selectById(backlogDTO.getBpmActivityId()));
        if (bpmActivity == null || bpmActivity.getData() == null) {
            return;
        }
        Optional formulaIdNameOption = paras.stream().findFirst();
        String formulaIdName = "";
        if (formulaIdNameOption.isPresent()) {
            formulaIdName = ((TmActionParameterDTO)formulaIdNameOption.get()).getValue();
        }
        if (!(formulaMap = this.themeMapService.executeFormula(formulaId = bpmActivity.getData().getString(formulaIdName))).containsKey("formulaVariables")) {
            return;
        }
        List formulaVariables = (List)formulaMap.get("formulaVariables");
        ArrayList<Map<String, Object>> checkItems = new ArrayList<Map<String, Object>>();
        backlogDTO.setCheckItems(checkItems);
        for (Map m : formulaVariables) {
            HashMap map = new HashMap();
            map.put("item", m.get("name"));
            map.put("value", m.get("value"));
            checkItems.add(map);
        }
    }

    public void setTodo(AuthoredUser authoredUser, BacklogDTO backlogDTO) {
        Map<String, Object> activityData = this.bpmBacklogActionCreateService.getEditActions(authoredUser, backlogDTO.getId(), null);
        try {
            BaseResultDTO actionResponse = this.aglieService.getTaskCardDataSize(backlogDTO.getTmTaskId(), backlogDTO.getTmActivityId(), activityData);
            HashMap data = (HashMap)actionResponse.getResponse();
            if (data == null || data.size() == 0 || !data.containsKey("title")) {
                return;
            }
            ArrayList<Map<String, Object>> todo = new ArrayList<Map<String, Object>>();
            HashMap<String, String> ci = new HashMap<String, String>();
            String langName = this.getLangName(authoredUser.getUserId(), authoredUser.getToken());
            Map<String, Object> activityDataMap = activityData;
            if (activityDataMap.get("type") != null && Integer.parseInt(activityDataMap.get("type").toString()) == 89) {
                ci.put("item", String.format(this.messageUtils.getMessageByLangName("data.uniformity.exception.size", langName), data.get("size")));
            } else {
                String item = MessageFormat.format("{0}{1}{2}", data.get("title"), data.get("size"), this.messageUtils.getMessageByLangName("data.summary.term", langName));
                if (data.containsKey("abnormalSize") && Integer.parseInt(data.get("abnormalSize").toString()) > 0) {
                    item = item + "\uff0c" + String.format(this.messageUtils.getMessageByLangName("data.uniformity.abnormal.size", langName), data.get("abnormalSize"));
                }
                ci.put("item", item);
            }
            todo.add(ci);
            backlogDTO.setTodoItems(todo);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("error", e.getMessage());
            backlogDTO.setError(error);
        }
    }

    private String getLangName(String userId, String token) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String locale = httpServletRequest.getHeader("Locale");
        if (StringUtils.isNotBlank((String)locale)) {
            return locale;
        }
        String langName = this.userService.getUserLangMetadataAllTenant(userId, token);
        if (StringUtils.isNotBlank((String)langName)) {
            return langName;
        }
        return "zh_TW";
    }

    public void resetTaskWorkItem(AuthoredUser user, PtmBacklogRecordDTO ptmBacklogRecord, String dataVariableKey) {
        Map<String, Object> activityData;
        Map<String, Object> activityDataMap = activityData = this.bpmBacklogActionCreateService.getEditActions(user, ptmBacklogRecord.getId(), null);
        activityDataMap.put("needHistoryInfo", false);
        activityDataMap.put("calendar", false);
        activityDataMap.put("dataVariableKey", dataVariableKey);
        try {
            BaseResultDTO actionResponse = this.aglieService.getTaskCardLayoutAbstractUpToDate(ptmBacklogRecord.getProjectDefCode(), ptmBacklogRecord.getTaskDefCode(), ptmBacklogRecord.getId(), activityDataMap, null);
            Map pageDataMap = (Map)actionResponse.getResponse();
            String summaryLayout = "";
            String historyMessage = "";
            String searchMessage = "";
            if (MapUtils.isNotEmpty((Map)pageDataMap)) {
                summaryLayout = pageDataMap.get(SUMMARY_LAYOUT_STR).toString();
                historyMessage = pageDataMap.get("historyMessage").toString();
                searchMessage = pageDataMap.get("searchMessage").toString();
            }
            TaskWorkitemMessage taskWorkitemMessage = new TaskWorkitemMessage();
            taskWorkitemMessage.setId(SnowflakeIdWorker.getInstance().newId());
            taskWorkitemMessage.setTenantId(user.getTenantId());
            taskWorkitemMessage.setCardId(ptmBacklogRecord.getId());
            taskWorkitemMessage.setCreateDate(LocalDateTime.now());
            taskWorkitemMessage.setModifyDate(LocalDateTime.now());
            taskWorkitemMessage.setSummary(summaryLayout);
            taskWorkitemMessage.setHistoryMessage(historyMessage);
            taskWorkitemMessage.setSearchMessage(searchMessage);
            taskWorkitemMessage.setCardType(PTM_BACKLOG);
            this.taskWorkitemMessageMapper.insertOrUpdateMessage(taskWorkitemMessage);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ErrorCodeEnum.RESET_TASK_WORKITEM_ERORR.getBusinessException();
        }
    }
}

