/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.bk.parser.dto.metadata;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.atmc.common.bk.parser.dto.BkNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.util.StringUtils;

public class MetadataUnit {
    private String source;
    private String entityName;
    private Set<String> allJsonPath;
    private String shortestPath;
    private int shortestLength;
    private boolean isRoot;
    private Set<String> longestPath;
    private boolean existLongest;
    private String pathInstance;
    private Map<String, BkNode> bkFields;

    public MetadataUnit(String source, String entityName, Map<String, BkNode> bkFields, boolean isRoot) {
        this.source = source;
        this.entityName = entityName;
        this.bkFields = bkFields;
        this.allJsonPath = new HashSet<String>();
        bkFields.values().forEach(item -> this.allJsonPath.add(item.getNodePath()));
        this.shortestPath = this.getShortestPath(this.allJsonPath);
        this.shortestLength = this.shortestPath.split("\\.").length;
        this.isRoot = isRoot;
        List<String> tempLongestPath = this.listLongestJsonPath(this.allJsonPath);
        this.existLongest = CollectionUtil.isNotEmpty(tempLongestPath);
        this.pathInstance = this.existLongest ? tempLongestPath.get(0) : this.allJsonPath.iterator().next();
        this.longestPath = new HashSet<String>(this.listLongestJsonPath(this.allJsonPath));
    }

    private String getShortestPath(Set<String> allJsonPath) {
        String shortestPath = "";
        int shortestLength = 0;
        for (String jsonPath : allJsonPath) {
            int tempLength = jsonPath.split("\\.").length;
            if (StringUtils.isEmpty((Object)shortestPath)) {
                shortestPath = jsonPath;
                shortestLength = tempLength;
            }
            if (shortestLength <= tempLength) continue;
            shortestLength = tempLength;
            shortestPath = jsonPath;
        }
        return shortestPath;
    }

    private List<String> listLongestJsonPath(Set<String> allJsonPath) {
        int maxLength = -1;
        MultiValueMap valueMap = new MultiValueMap();
        for (String jsonPath : allJsonPath) {
            int tempLength = jsonPath.split("\\.").length;
            if (maxLength == -1) {
                maxLength = tempLength;
            }
            if (maxLength < tempLength) {
                maxLength = tempLength;
            }
            valueMap.put((Object)String.valueOf(tempLength), (Object)jsonPath);
        }
        List longest = (List)valueMap.get((Object)String.valueOf(maxLength));
        if (longest.size() == allJsonPath.size()) {
            return new ArrayList<String>();
        }
        return longest;
    }

    public String getSource() {
        return this.source;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Set<String> getAllJsonPath() {
        return this.allJsonPath;
    }

    public String getShortestPath() {
        return this.shortestPath;
    }

    public int getShortestLength() {
        return this.shortestLength;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Set<String> getLongestPath() {
        return this.longestPath;
    }

    public boolean isExistLongest() {
        return this.existLongest;
    }

    public String getPathInstance() {
        return this.pathInstance;
    }

    public Map<String, BkNode> getBkFields() {
        return this.bkFields;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setAllJsonPath(Set<String> allJsonPath) {
        this.allJsonPath = allJsonPath;
    }

    public void setShortestPath(String shortestPath) {
        this.shortestPath = shortestPath;
    }

    public void setShortestLength(int shortestLength) {
        this.shortestLength = shortestLength;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void setLongestPath(Set<String> longestPath) {
        this.longestPath = longestPath;
    }

    public void setExistLongest(boolean existLongest) {
        this.existLongest = existLongest;
    }

    public void setPathInstance(String pathInstance) {
        this.pathInstance = pathInstance;
    }

    public void setBkFields(Map<String, BkNode> bkFields) {
        this.bkFields = bkFields;
    }
}

