/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.ptm;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.Base64Converter;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.common.dao.ptm.PtmBacklogMapper;
import com.digiwin.athena.atmc.common.dao.ptm.PtmProjectCardMapper;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalActivityDTO;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalStepDTO;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalWorkItemDTO;
import com.digiwin.athena.atmc.common.domain.backlog.CloseBacklogActionDTO;
import com.digiwin.athena.atmc.common.domain.ptm.PtmBacklog;
import com.digiwin.athena.atmc.common.domain.ptm.PtmProjectCard;
import com.digiwin.athena.atmc.common.domain.task.BacklogDTO;
import com.digiwin.athena.atmc.common.domain.task.BacklogStateDTO;
import com.digiwin.athena.atmc.common.enums.ActivityWorkitemSubState;
import com.digiwin.athena.atmc.common.enums.SignCategory;
import com.digiwin.athena.atmc.common.service.bpm.BpmActivityService;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.Task;
import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApproveRequestDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApprovelDTO;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import com.digiwin.athena.atmc.http.restful.im.ImService;
import com.digiwin.athena.atmc.http.restful.im.model.ImNeteaseUserDTO;
import com.digiwin.athena.atmc.http.restful.ptm.PtmService;
import com.digiwin.athena.atmc.http.restful.ptm.model.ApprovalWorkItemByDataDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmActivitySignInformerDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogApprovalDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmEmailBacklogRequestDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectCardDetailDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmProjectRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmTaskRecordDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmWorkItemRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAttachmentConfigInfo;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmDmcAccount;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class PtmBacklogTransformService {
    private static final Logger log = LoggerFactory.getLogger(PtmBacklogTransformService.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private PtmService ptmService;
    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;
    @Autowired
    private PtmProjectCardMapper ptmProjectCardMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private BpmActivityService bpmActivityService;
    @Autowired
    private ImService imService;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    public int batchUpdateNameAndTimeById(Map paramMap) {
        int result = 0;
        if (!this.enablePTM()) {
            return result;
        }
        List list = (List)paramMap.get("data");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        ArrayList paraList = new ArrayList();
        list.forEach(m -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("taskId", MapUtils.getLongValue((Map)m, (Object)"backlogId"));
            if (m.containsKey("name")) {
                map.put("taskName", (Long)m.get("name"));
            }
            if (m.containsKey("startTime")) {
                map.put("startTime", (Long)m.get("startTime"));
            }
            if (m.containsKey("endTime")) {
                map.put("endTime", (Long)m.get("endTime"));
            }
            paraList.add(map);
        });
        HashMap map = new HashMap();
        map.put("data", paraList);
        if (this.ptmService.batchUpdateBacklogInfo(map).booleanValue()) {
            paraList.forEach(u -> this.updateNameAndTimeByTaskId((Map)u));
            result = 1;
        }
        return result;
    }

    private void updateNameAndTimeByTaskId(Map map) {
        Long taskId = MapUtils.getLong((Map)map, (Object)"taskId");
        List backlogList = this.ptmService.queryBacklogPartialByTaskIds(Arrays.asList(taskId));
        if (CollectionUtils.isNotEmpty((Collection)backlogList)) {
            backlogList.forEach(bl -> {
                boolean hasChanged = false;
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"backlog_id", (Object)bl.getId());
                if (map.containsKey("taskName") && map.get("taskName") != null) {
                    updateWrapper.set((Object)"task_name", map.get("taskName"));
                    hasChanged = true;
                }
                if (map.containsKey("endTime") && map.get("endTime") != null) {
                    updateWrapper.set((Object)"plan_end_time", map.get("endTime"));
                    hasChanged = true;
                }
                if (hasChanged) {
                    this.ptmBacklogMapper.update(null, (Wrapper)updateWrapper);
                }
            });
        }
    }

    public int terminateTask(Map paraMap) {
        int result = 0;
        if (!this.enablePTM()) {
            return result;
        }
        if (this.ptmService.batchTerminateTask(paraMap).booleanValue()) {
            result = 1;
        }
        return result;
    }

    public Task translateProjectCardByBacklogId(Long backlogId) {
        Task task = null;
        if (!this.enablePTM()) {
            return task;
        }
        PtmBacklog ptmBacklog = this.commonPtmTransformService.getBacklogForCard(backlogId);
        if (ptmBacklog == null) {
            return task;
        }
        PtmProjectCard ptmProjectCard = this.commonPtmTransformService.getProjectInfo(ptmBacklog.getProjectCardId());
        if (ptmProjectCard == null) {
            PtmProjectCardDetailDTO ptmProjectCardDetailDTO = this.ptmService.getProjectCardDetail(ptmBacklog.getProjectCardId());
            ptmProjectCard = PtmProjectCard.builder().id(ptmProjectCardDetailDTO.getId()).projectCode(ptmProjectCardDetailDTO.getProjectDefCode()).personInCharge(ptmProjectCardDetailDTO.getPersonInCharge()).build();
        }
        task = Task.builder().id(ptmProjectCard.getId()).tmTaskId(ptmProjectCard.getProjectCode()).personInCharge(ptmProjectCard.getPersonInCharge()).build();
        return task;
    }

    public int closeBacklog(CloseBacklogActionDTO action) {
        log.info("closeBacklog:{}", (Object)JsonUtils.objectToString((Object)action));
        int result = 0;
        if (!this.enablePTM()) {
            return result;
        }
        ArrayList<PtmBacklog> list = new ArrayList<PtmBacklog>();
        PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(action.getId()));
        if (ptmBacklog != null) {
            list.add(ptmBacklog);
        } else {
            list.addAll(this.ptmBacklogMapper.selectByWorkItemId(action.getId()));
        }
        if (CollectionUtils.isNotEmpty(list)) {
            AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
            for (PtmBacklog backlog : list) {
                UpdateWrapper updateWrapper;
                if (Objects.equals(backlog.getMerge(), true)) {
                    updateWrapper = new UpdateWrapper();
                    updateWrapper.eq((Object)"backlog_id", (Object)backlog.getBacklogId());
                    ((UpdateWrapper)updateWrapper.set((Object)"action_id", (Object)action.getActionId())).set((Object)"modify_date", (Object)LocalDateTime.now());
                    result += this.ptmBacklogMapper.update(null, (Wrapper)updateWrapper);
                    log.info("close ptm backlog-{}, actionId-{}", (Object)backlog.getBacklogId(), (Object)action.getActionId());
                    continue;
                }
                updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"backlog_id", (Object)backlog.getBacklogId());
                ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"action_id", (Object)action.getActionId())).set((Object)"closed", (Object)1)).set((Object)"closed_time", (Object)LocalDateTime.now())).set((Object)"modify_date", (Object)LocalDateTime.now());
                result += this.ptmBacklogMapper.update(null, (Wrapper)updateWrapper);
            }
        }
        return result;
    }

    public List<Map> selectNoFinishedListByOriginBacklogIdForSolve(Long backlogId) {
        ArrayList<Map> result = new ArrayList<Map>();
        if (!this.enablePTM()) {
            return result;
        }
        ArrayList<Long> originalBacklogIds = new ArrayList<Long>();
        originalBacklogIds.add(backlogId);
        PtmBacklog ptmBacklog = this.commonPtmTransformService.getBacklogForCard(backlogId);
        if (ptmBacklog == null) {
            return result;
        }
        List backlogItemList = this.ptmService.getBacklogByBacklogId(ptmBacklog.getBacklogId());
        backlogItemList.forEach(x -> originalBacklogIds.add(x.getWorkItemId()));
        List list = this.ptmService.getSolveTaskList(originalBacklogIds);
        log.info("getSolveTask list:{}", (Object)JsonUtils.objectToString((Object)list));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Map x2 : list) {
                if (!x2.containsKey("state") || MapUtils.getInteger((Map)x2, (Object)"state", (Integer)0) == 3) continue;
                x2.put("tm_task_id", x2.get("projectDefCode"));
                x2.put("tm_activity_id", x2.get("taskDefCode"));
                x2.put("dataFrom", "PTM");
                result.add(x2);
            }
        }
        return result;
    }

    public List<ApprovalActivityDTO> programProgress(Map<String, Object> approvalStateMap, AuthoredUser user) {
        List processInstances;
        ArrayList<ApprovalActivityDTO> result = new ArrayList<ApprovalActivityDTO>();
        if (!this.enablePTM()) {
            return result;
        }
        if (approvalStateMap.containsKey("processInstances") && CollectionUtils.isNotEmpty((Collection)(processInstances = (List)approvalStateMap.get("processInstances")))) {
            Long solveTaskId = MapUtils.getLong((Map)((Map)processInstances.get(0)), (Object)"solveTaskId", (Long)0L);
            String solveBpmActivityId = MapUtils.getString((Map)((Map)processInstances.get(0)), (Object)"solveBpmActivityId", (String)"");
            String solveBpmActivityName = MapUtils.getString((Map)((Map)processInstances.get(0)), (Object)"solveBpmActivityName", (String)"");
            Long solveWorkItemId = MapUtils.getLong((Map)((Map)processInstances.get(0)), (Object)"solveWorkItemId", (Long)0L);
            ApprovalActivityDTO solveActivity = ApprovalActivityDTO.builder().id(solveTaskId).bpmActivityId(solveBpmActivityId).bpmActivityName(solveBpmActivityName).build();
            PtmWorkItemRecordDTO ptmWorkItemRecordDTO = this.ptmService.getWorkItemRecord(solveWorkItemId);
            if (ptmWorkItemRecordDTO != null) {
                ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().id(0L).createTime(ptmWorkItemRecordDTO.getCreateTime()).closedTime(ptmWorkItemRecordDTO.getClosedTime()).performerId(ptmWorkItemRecordDTO.getPerformerId()).performerName(ptmWorkItemRecordDTO.getPerformerName()).workitemId(ptmWorkItemRecordDTO.getWorkItemId()).comment(ptmWorkItemRecordDTO.getComment()).state(ptmWorkItemRecordDTO.getState()).subState(ptmWorkItemRecordDTO.getSubState()).agentPerformerId(ptmWorkItemRecordDTO.getAgentPerformerId()).agentPerformerName(ptmWorkItemRecordDTO.getAgentPerformerId()).createType(ptmWorkItemRecordDTO.getCreateType()).performerType(ptmWorkItemRecordDTO.getPerformerType()).reassign(new JSONArray()).build();
                ArrayList<ApprovalWorkItemDTO> workitemList = new ArrayList<ApprovalWorkItemDTO>();
                workitemList.add(workItem);
                solveActivity.setWorkitemList(workitemList);
            }
            result.add(solveActivity);
            processInstances.forEach(processInstance -> {
                ApprovalActivityDTO activity = ApprovalActivityDTO.builder().bpmActivityId(MapUtils.getString((Map)processInstance, (Object)"bpmActivityId", (String)"")).bpmActivityName(MapUtils.getString((Map)processInstance, (Object)"bpmActivityName", (String)"")).state(MapUtils.getInteger((Map)processInstance, (Object)"state", (Integer)0)).build();
                activity.setSteps(this.setApprovalStep(MapUtils.getString((Map)processInstance, (Object)"taskUid", (String)"")));
                result.add(activity);
            });
        }
        return result;
    }

    private List<ApprovalStepDTO> setApprovalStep(String taskUid) {
        ArrayList<ApprovalStepDTO> result = new ArrayList<ApprovalStepDTO>();
        BpmTaskApproveRequestDTO requestDTO = BpmTaskApproveRequestDTO.builder().locale(LocaleContextHolder.getLocale().toLanguageTag()).taskUid(taskUid).build();
        BpmTaskApprovelDTO bpmTaskApprovelDTO = this.ptmService.queryApproveByTaskUid(requestDTO);
        if (null != bpmTaskApprovelDTO && CollectionUtils.isNotEmpty((Collection)bpmTaskApprovelDTO.getSignProcess())) {
            HashMap nameMap = new HashMap();
            List approvalList = bpmTaskApprovelDTO.getSignProcess();
            List noticeList = this.ptmService.getSignInformer(approvalList.stream().filter(x -> StringUtils.isNotBlank((String)x.getBpmActivityOID())).map(x -> x.getBpmActivityOID()).collect(Collectors.toList()));
            approvalList.forEach(approval -> {
                ApprovalStepDTO noticeStep = this.builderSignInformer(noticeList, (BpmTaskApproveActivityDTO)approval, "noticeBefore");
                if (noticeStep != null) {
                    noticeStep.setSignType(81);
                    result.add(noticeStep);
                }
                ApprovalStepDTO step = ApprovalStepDTO.builder().id(0L).bpmActivityId(approval.getActivityId()).bpmActivityName(approval.getActivityName()).state(approval.getState()).isReassign(false).isReexecute(false).signType(SignCategory.parse(approval.getSignType()).getValue()).build();
                step.setAttachmentConfig(this.generateAttachmentConfig(bpmTaskApprovelDTO.getProjectDefCode(), bpmTaskApprovelDTO.getTaskDefCode()));
                if (!Objects.equals(-1, approval.getState()) && CollectionUtils.isNotEmpty((Collection)approval.getWorkitemList())) {
                    ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
                    approval.getWorkitemList().forEach(wi -> {
                        UserDTO userDTO;
                        ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().id(0L).createTime(wi.getCreateTime()).closedTime(wi.getClosedTime()).performerId(wi.getPerformerId()).performerName(wi.getPerformerId()).workitemId(wi.getWorkitemId()).comment(wi.getComment()).state(wi.getState()).subState(wi.getSubState()).agentPerformerId(wi.getAgentPerformerId()).agentPerformerName(wi.getAgentPerformerId()).createType(wi.getCreateType()).performerType(wi.getPerformerType()).reassign(new JSONArray()).attachments(wi.getAttachments()).build();
                        if (!Objects.equals(wi.getCreateType(), 0) && wi.getSubState() > 10) {
                            workItem.setSubState(ActivityWorkitemSubState.COMPLETED.getValue());
                        }
                        if (nameMap.containsKey(wi.getPerformerId())) {
                            workItem.setPerformerName((String)nameMap.get(wi.getPerformerId()));
                        } else {
                            userDTO = this.userService.query(wi.getPerformerId());
                            if (userDTO != null) {
                                workItem.setPerformerName(userDTO.getName());
                            }
                            nameMap.put(workItem.getPerformerId(), workItem.getPerformerName());
                        }
                        if (StringUtils.isNotBlank((String)wi.getAgentPerformerId())) {
                            if (nameMap.containsKey(wi.getAgentPerformerId())) {
                                workItem.setAgentPerformerName((String)nameMap.get(wi.getAgentPerformerId()));
                            } else {
                                userDTO = this.userService.query(wi.getAgentPerformerId());
                                if (userDTO != null) {
                                    workItem.setAgentPerformerName(userDTO.getName());
                                }
                                nameMap.put(workItem.getAgentPerformerId(), workItem.getAgentPerformerName());
                            }
                        }
                        workItemList.add(workItem);
                    });
                    step.setWorkitemList(workItemList);
                }
                result.add(step);
                noticeStep = this.builderSignInformer(noticeList, (BpmTaskApproveActivityDTO)approval, "noticeAfter");
                if (noticeStep != null) {
                    noticeStep.setSignType(82);
                    result.add(noticeStep);
                }
            });
        }
        return result;
    }

    private Map<String, Object> generateAttachmentConfig(String projectDefCode, String taskDefCode) {
        TmActivityResponseDTO activityAction;
        TmAttachmentConfigInfo attachment;
        if (StringUtils.isNotBlank((String)projectDefCode) && StringUtils.isNotBlank((String)taskDefCode) && null != (attachment = (activityAction = this.themeMapService.getActivityAction(projectDefCode, taskDefCode, "task-detail")).getAttachment()) && null != attachment.getApprovalConfig()) {
            HashMap<String, Object> attachmentConfig = new HashMap<String, Object>();
            TmDmcAccount dmcAccount = attachment.getApprovalConfig().getDmcAccount();
            if (null != dmcAccount && StringUtils.isNotBlank((String)dmcAccount.getPassword())) {
                dmcAccount.setPassword(Base64Converter.encode((String)dmcAccount.getPassword()));
                attachmentConfig.put("dmcAccount", dmcAccount);
            }
            attachmentConfig.put("buckets", attachment.getApprovalConfig().getBuckets());
            attachmentConfig.put("readCategory", Collections.singletonList(attachment.getApprovalConfig().getUploadCategory()));
            return attachmentConfig;
        }
        return null;
    }

    public List<ApprovalStepDTO> getTaskApprovalList(Long id) {
        List approvalList;
        ArrayList<ApprovalStepDTO> result = new ArrayList<ApprovalStepDTO>();
        if (id == null) {
            return result;
        }
        if (!this.enablePTM()) {
            return result;
        }
        PtmBacklogRecordDTO ptmBacklogRecord = this.ptmService.getBacklogRecord(id);
        if (null != ptmBacklogRecord) {
            approvalList = this.ptmService.queryApprovalNew(id);
        } else {
            PtmWorkItemRecordDTO ptmWorkItemRecord = this.ptmService.getWorkItemRecord(id);
            if (null == ptmWorkItemRecord) {
                return result;
            }
            approvalList = null != ptmWorkItemRecord.getBacklogId() ? this.ptmService.queryApprovalNew(ptmWorkItemRecord.getBacklogId()) : this.ptmService.queryApprovalByWorkItemId(id);
        }
        if (CollectionUtils.isEmpty((Collection)approvalList)) {
            return result;
        }
        this.dealApprovalList(approvalList, result);
        return result;
    }

    public List<ApprovalStepDTO> getTaskApprovalList(ApprovalWorkItemByDataDTO workItemDataDTO) {
        ArrayList<ApprovalStepDTO> result = new ArrayList<ApprovalStepDTO>();
        List approvalList = this.ptmService.queryApprovalByData(workItemDataDTO);
        this.dealApprovalList(approvalList, result);
        return result;
    }

    private void dealApprovalList(List<PtmBacklogApprovalDTO> approvalList, List<ApprovalStepDTO> result) {
        approvalList.forEach(approval -> {
            if (CollectionUtils.isNotEmpty((Collection)approval.getSignProcess())) {
                HashMap nameMap = new HashMap();
                for (PtmBacklogApprovalDTO.SignProcess signProcess : approval.getSignProcess()) {
                    ApprovalStepDTO noticeStep;
                    ApprovalStepDTO step;
                    if (signProcess.getInitiatorNode().booleanValue()) {
                        String userName = signProcess.getInitiatorId();
                        UserDTO userDTO = this.userService.query(userName);
                        if (userDTO != null) {
                            userName = userDTO.getName();
                        }
                        step = ApprovalStepDTO.builder().id(0L).bpmActivityId("__uibot__start__").bpmActivityName(this.messageUtils.getMessage("backlog.first.step.name")).state(3).isReassign(false).isReexecute(false).build();
                        ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().id(0L).createTime(signProcess.getStartTime()).closedTime(signProcess.getCompletedTime()).performerId(signProcess.getInitiatorId()).performerName(userName).state(3).subState(10).reassign(new JSONArray()).build();
                        ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
                        workItemList.add(workItem);
                        step.setWorkitemList(workItemList);
                        result.add(step);
                        continue;
                    }
                    JSONObject informer = null;
                    if (StringUtils.isNotBlank((String)signProcess.getNoticeInformer())) {
                        informer = JSONObject.fromObject((Object)signProcess.getNoticeInformer());
                    }
                    if ((noticeStep = this.builderSignInformer(signProcess, informer, "noticeBefore")) != null) {
                        noticeStep.setSignType(81);
                        result.add(noticeStep);
                    }
                    step = ApprovalStepDTO.builder().id(0L).bpmActivityId(signProcess.getActivityId()).bpmActivityName(signProcess.getActivityName()).state(signProcess.getState()).isReassign(false).isReexecute(false).signType(SignCategory.parse(signProcess.getSignType()).getValue()).build();
                    step.setAttachmentConfig(this.generateAttachmentConfig(approval.getProjectDefCode(), approval.getTaskDefCode()));
                    if (!Objects.equals(-1, signProcess.getState()) && CollectionUtils.isNotEmpty((Collection)signProcess.getWorkitemList())) {
                        ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
                        signProcess.getWorkitemList().forEach(wi -> {
                            UserDTO userDTO;
                            ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().id(0L).createTime(wi.getCreateTime()).closedTime(wi.getClosedTime()).performerId(wi.getPerformerId()).performerName(wi.getPerformerId()).workitemId(wi.getWorkitemId()).comment(wi.getComment()).state(wi.getState()).subState(wi.getSubState()).agentPerformerId(wi.getAgentPerformerId()).agentPerformerName(wi.getAgentPerformerId()).createType(wi.getCreateType()).performerType(wi.getPerformerType()).reassign(new JSONArray()).attachments(wi.getAttachments()).build();
                            if (!Objects.equals(wi.getCreateType(), 0) && wi.getSubState() > 10) {
                                workItem.setSubState(ActivityWorkitemSubState.COMPLETED.getValue());
                            }
                            if (nameMap.containsKey(wi.getPerformerId())) {
                                workItem.setPerformerName((String)nameMap.get(wi.getPerformerId()));
                            } else {
                                userDTO = this.userService.query(wi.getPerformerId());
                                if (userDTO != null) {
                                    workItem.setPerformerName(userDTO.getName());
                                }
                                nameMap.put(workItem.getPerformerId(), workItem.getPerformerName());
                            }
                            if (StringUtils.isNotBlank((String)wi.getAgentPerformerId())) {
                                if (nameMap.containsKey(wi.getAgentPerformerId())) {
                                    workItem.setAgentPerformerName((String)nameMap.get(wi.getAgentPerformerId()));
                                } else {
                                    userDTO = this.userService.query(wi.getAgentPerformerId());
                                    if (userDTO != null) {
                                        workItem.setAgentPerformerName(userDTO.getName());
                                    }
                                    nameMap.put(workItem.getAgentPerformerId(), workItem.getAgentPerformerName());
                                }
                            }
                            workItemList.add(workItem);
                        });
                        step.setWorkitemList(workItemList);
                    }
                    result.add(step);
                    noticeStep = this.builderSignInformer(signProcess, informer, "noticeAfter");
                    if (noticeStep == null) continue;
                    noticeStep.setSignType(81);
                    result.add(noticeStep);
                }
            }
        });
    }

    public List<Map> queryApprovalTask(Map<String, Object> paramMap) {
        List list;
        ArrayList<Map> result = new ArrayList<Map>();
        if (MapUtils.isNotEmpty(paramMap) && CollectionUtils.isNotEmpty((Collection)(list = this.ptmService.queryProjectReport(paramMap)))) {
            list.forEach(x -> {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("bpmActivityId", x.getTaskId());
                m.put("bpmActivityName", x.getTaskName());
                m.put("workitemId", x.getId());
                m.put("processSerialNumber", x.getProcessSerialNumber());
                m.put("tmActivityId", x.getTaskDefCode());
                result.add(m);
            });
        }
        return result;
    }

    public List<BacklogStateDTO> isBacklogClosed(List<Long> workItemIdList) {
        List<BacklogStateDTO> result = new ArrayList<BacklogStateDTO>();
        if (CollectionUtils.isNotEmpty(workItemIdList)) {
            ArrayList<Long> backlogIdList = new ArrayList<Long>();
            List workItemRecordList = this.ptmService.getWorkItemRecordByWorkItemIds(workItemIdList);
            if (CollectionUtils.isNotEmpty((Collection)workItemRecordList)) {
                backlogIdList.addAll(workItemRecordList.stream().map(x -> x.getBacklogId()).distinct().collect(Collectors.toList()));
                for (Long workItemId : workItemIdList) {
                    if (workItemRecordList.stream().filter(x -> Objects.equals(x.getId(), workItemId)).count() != 0L) continue;
                    backlogIdList.addAll(workItemIdList);
                }
            } else {
                backlogIdList.addAll(workItemIdList);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.in((Object)"backlog_id", backlogIdList)).select(new String[]{"backlog_id", "closed"});
            List backlogList = this.ptmBacklogMapper.selectList((Wrapper)queryWrapper);
            result = backlogList.stream().map(bl -> {
                BacklogStateDTO backlogState = new BacklogStateDTO();
                backlogState.setId(bl.getBacklogId());
                backlogState.setClosed(bl.getClosed());
                return backlogState;
            }).collect(Collectors.toList());
        }
        return result;
    }

    public boolean isBacklogClosed(Long backlogId) {
        if (Objects.isNull(backlogId)) {
            return false;
        }
        PtmBacklogRecordDTO backlogRecord = this.ptmService.getBacklogRecord(backlogId);
        if (null != backlogRecord && BooleanUtils.isTrue((Boolean)backlogRecord.getClosed())) {
            return true;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"backlog_id", (Object)backlogId)).select(new String[]{"backlog_id", "closed"});
        PtmBacklog backlog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectOne((Wrapper)queryWrapper));
        if (null != backlog) {
            return BooleanUtils.isTrue((Boolean)backlog.getClosed());
        }
        if (null != backlogRecord) {
            return BooleanUtils.isTrue((Boolean)backlogRecord.getClosed());
        }
        List<BacklogStateDTO> backlogStateList = this.isBacklogClosed(Lists.newArrayList((Object[])new Long[]{backlogId}));
        if (CollectionUtils.isEmpty(backlogStateList)) {
            return false;
        }
        return backlogStateList.stream().filter(backlogState -> BooleanUtils.isTrue((Boolean)backlogState.getClosed())).findFirst().isPresent();
    }

    private ApprovalStepDTO builderSignInformer(List<PtmActivitySignInformerDTO> noticeList, BpmTaskApproveActivityDTO approval, String noticeType) {
        PtmActivitySignInformerDTO notice;
        JSONObject informer;
        if (CollectionUtils.isEmpty(noticeList)) {
            return null;
        }
        Optional<PtmActivitySignInformerDTO> noticeOptional = noticeList.stream().filter(x -> Objects.equals(x.getBpmActivityUid(), approval.getBpmActivityOID())).findFirst();
        if (noticeOptional.isPresent() && (informer = JSONObject.fromObject((Object)(StringUtils.isBlank((String)(notice = noticeOptional.get()).getInformer()) ? new JSONObject() : notice.getInformer()))) != null && informer.containsKey((Object)noticeType)) {
            JSONArray noticeArray = JSONArray.fromObject((Object)informer.get(noticeType));
            if (noticeArray == null || noticeArray.isEmpty()) {
                return null;
            }
            ApprovalStepDTO step = ApprovalStepDTO.builder().id(0L).bpmActivityId(approval.getActivityId()).bpmActivityName(approval.getActivityName()).state(3).isReassign(false).isReexecute(false).build();
            ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
            for (Object sn : noticeArray) {
                JSONObject noticeObject = JSONObject.fromObject(sn);
                if (!noticeObject.containsKey((Object)"userId") || StringUtils.isBlank((String)noticeObject.getString("userId"))) continue;
                ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().performerId(noticeObject.getString("userId")).build();
                if (noticeObject.containsKey((Object)"userName") && StringUtils.isNotBlank((String)noticeObject.getString("userName"))) {
                    workItem.setPerformerName(noticeObject.getString("userName"));
                }
                if (noticeObject.containsKey((Object)"sendTime") && StringUtils.isNotBlank((String)noticeObject.getString("sendTime"))) {
                    workItem.setClosedTime(null);
                }
                workItemList.add(workItem);
            }
            step.setWorkitemList(workItemList);
            return step;
        }
        return null;
    }

    private ApprovalStepDTO builderSignInformer(PtmBacklogApprovalDTO.SignProcess signProcess, JSONObject informer, String noticeType) {
        if (signProcess == null || informer == null) {
            return null;
        }
        if (informer.containsKey((Object)noticeType)) {
            JSONArray noticeArray = JSONArray.fromObject((Object)informer.get(noticeType));
            if (noticeArray == null || noticeArray.isEmpty()) {
                return null;
            }
            ApprovalStepDTO step = ApprovalStepDTO.builder().id(0L).bpmActivityId(signProcess.getActivityId()).bpmActivityName(signProcess.getActivityName()).state(3).isReassign(false).isReexecute(false).build();
            ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
            for (Object sn : noticeArray) {
                JSONObject noticeObject = JSONObject.fromObject(sn);
                if (!noticeObject.containsKey((Object)"userId") || StringUtils.isBlank((String)noticeObject.getString("userId"))) continue;
                ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().performerId(noticeObject.getString("userId")).build();
                if (noticeObject.containsKey((Object)"userName") && StringUtils.isNotBlank((String)noticeObject.getString("userName"))) {
                    workItem.setPerformerName(noticeObject.getString("userName"));
                }
                if (noticeObject.containsKey((Object)"sendTime") && StringUtils.isNotBlank((String)noticeObject.getString("sendTime"))) {
                    workItem.setClosedTime(null);
                }
                workItemList.add(workItem);
            }
            step.setWorkitemList(workItemList);
            return step;
        }
        return null;
    }

    public List<BacklogDTO> queryWorkItemListByIdAndProcessSerialNumber(String tenantId, Long mainProjectId, List<Long> workItemIdList) {
        ArrayList<BacklogDTO> result = new ArrayList<BacklogDTO>();
        if (CollectionUtils.isEmpty(workItemIdList)) {
            return result;
        }
        List workItemRecordList = this.ptmService.getWorkItemRecordByWorkItemIds(workItemIdList);
        if (CollectionUtils.isEmpty((Collection)workItemRecordList)) {
            return result;
        }
        List projectList = this.ptmService.getProjectRecordByProjectIdsV2(workItemRecordList.stream().map(x -> x.getProjectId()).collect(Collectors.toList()), false);
        List taskRecordList = this.ptmService.getTaskRecordByTaskIds(workItemRecordList.stream().map(x -> x.getTaskId()).collect(Collectors.toList()));
        workItemRecordList.forEach(wi -> {
            Optional<PtmProjectRecordDTO> project = projectList.stream().filter(x -> Objects.equals(x.getId(), wi.getProjectId()) && Objects.equals(x.getProjectCardId(), mainProjectId)).findFirst();
            if (!project.isPresent()) {
                return;
            }
            Optional<PtmTaskRecordDTO> task = taskRecordList.stream().filter(x -> Objects.equals(x.getId(), wi.getTaskId())).findFirst();
            if (!task.isPresent()) {
                return;
            }
            BacklogDTO backlogDTO = BacklogDTO.builder().id(wi.getBacklogId()).workItemId(wi.getId()).tmTaskId(project.get().getProjectDefCode()).tmActivityId(task.get().getTaskDefCode()).tmActivityName(task.get().getTaskDefName()).build();
            result.add(backlogDTO);
        });
        return result;
    }

    public PtmBacklog getReplyOriginalBacklog(Long backlogId) {
        List<PtmBacklog> list;
        PtmBacklog originaalBacklog = null;
        PtmBacklog backlog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(backlogId));
        if (backlog != null && CollectionUtils.isNotEmpty(list = this.ptmBacklogMapper.selectByWorkItemId(backlog.getWorkItemId()))) {
            for (PtmBacklog bl : list) {
                if (!Objects.equals(bl.getType(), 0) || Objects.equals(bl.getBacklogId(), backlogId)) continue;
                originaalBacklog = bl;
                break;
            }
        }
        return originaalBacklog;
    }

    public PtmBacklog getPtmBacklogPerformerAndType(Long backlogId) {
        PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(backlogId));
        if (null != ptmBacklog) {
            return PtmBacklog.builder().backlogId(ptmBacklog.getBacklogId()).performerId(ptmBacklog.getPerformerId()).performerName(ptmBacklog.getPerformerName()).type(ptmBacklog.getType()).build();
        }
        return this.commonPtmTransformService.getPtmBacklogPerformerAndType(backlogId);
    }

    public void addEmailBacklog(AuthoredUser user, Long backlogId, String email) {
        PtmBacklog backlog = this.commonPtmTransformService.getBacklogForCard(backlogId);
        String tenantId = null;
        String userId = null;
        String userName = null;
        Map<String, String> tenantAuthUserMap = this.bpmActivityService.getTargetTenantAndUser(user, email, "");
        if (tenantAuthUserMap != null && tenantAuthUserMap.size() > 0) {
            tenantId = tenantAuthUserMap.get("workItemToTenantId");
            userName = userId = tenantAuthUserMap.get("commonTenantUserId");
            UserDTO userDTO = this.userService.query(userId);
            if (userDTO != null) {
                userName = userDTO.getName();
            }
        } else {
            throw ErrorCodeEnum.CREATE_PERSON_TENANT_FAIL.getBusinessException();
        }
        PtmEmailBacklogRequestDTO emailRequest = PtmEmailBacklogRequestDTO.builder().workItemId(backlog.getWorkItemId()).performerId(userId).performerName(userName).tenantId(tenantId).build();
        this.ptmService.addCrossTenantBacklog(emailRequest);
    }

    public String getTraceIdByBacklogId(Long backlogId) {
        PtmProjectRecordDTO ptmProjectRecord;
        Long ptmProjectId = null;
        PtmBacklog ptmBacklog = (PtmBacklog)((Object)this.ptmBacklogMapper.selectById(backlogId));
        if (ptmBacklog == null) {
            PtmWorkItemRecordDTO ptmWorkItemRecord = this.ptmService.getWorkItemRecord(backlogId);
            if (ptmWorkItemRecord != null) {
                ptmProjectId = ptmWorkItemRecord.getProjectId();
            }
        } else {
            ptmProjectId = ptmBacklog.getProjectId();
        }
        if (ptmProjectId != null && (ptmProjectRecord = this.ptmService.getProjectRecord(ptmProjectId)) != null) {
            return ptmProjectRecord.getTraceId();
        }
        return null;
    }

    public List<Map> getPersonInChargesInBacklog(AuthoredUser user, Long backlogId) {
        List projectList;
        ArrayList<Map> result = new ArrayList<Map>();
        List backlogItemList = this.ptmService.getBacklogByBacklogId(backlogId);
        if (CollectionUtils.isNotEmpty((Collection)backlogItemList) && CollectionUtils.isNotEmpty((Collection)(projectList = this.ptmService.getProjectCardRecordByProjectCardIds(backlogItemList.stream().map(x -> x.getProjectCardId()).distinct().collect(Collectors.toList()))))) {
            List imUserList = this.imService.queryNeteaseUsers(projectList.stream().map(x -> x.getPersonInCharge()).distinct().collect(Collectors.toList()));
            projectList.forEach(p -> {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("projectCardId", p.getId());
                m.put("projectCardName", p.getProjectName());
                m.put("personInCharge", p.getPersonInCharge());
                m.put("personInChargeName", p.getPersonInChargeName());
                Optional<ImNeteaseUserDTO> imUserOptional = imUserList.stream().filter(x -> Objects.equals(x.getUserId(), p.getPersonInCharge())).findFirst();
                if (imUserOptional.isPresent()) {
                    m.put("neteaseImAccId", imUserOptional.get().getAccid());
                }
                result.add(m);
            });
        }
        return result;
    }

    private boolean enablePTM() {
        return StringUtils.isNotBlank((String)this.envProperties.getPtmUri());
    }

    public Map<Long, Long> backlogIdMap(List<Long> ids) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        ArrayList<PtmBacklog> ptmBacklogs = new ArrayList<PtmBacklog>();
        int batchSize = 1000;
        int totalElements = ids.size();
        for (int i = 0; i < totalElements; i += batchSize) {
            int fromIndex = i;
            int toIndex = Math.min(i + batchSize, totalElements);
            List<Long> batch = ids.subList(fromIndex, toIndex);
            List<PtmBacklog> subList = this.ptmBacklogMapper.selectBacklogType0OrType1(batch);
            ptmBacklogs.addAll(subList);
        }
        Map<Long, List<PtmBacklog>> mapAssist = ptmBacklogs.stream().collect(Collectors.groupingBy(PtmBacklog::getWorkItemId));
        mapAssist.forEach((key, value) -> {
            Optional<PtmBacklog> second;
            Long type0 = null;
            Long type1 = null;
            Optional<PtmBacklog> first = value.stream().filter(e -> e.getType() == 0).findFirst();
            if (first.isPresent()) {
                type0 = first.get().getBacklogId();
            }
            if ((second = value.stream().filter(e -> e.getType() == 1).findFirst()).isPresent()) {
                type1 = second.get().getBacklogId();
            }
            if (type1 != null && type0 != null) {
                map.put(type1, type0);
            }
        });
        return map;
    }
}

