/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.workflow;

import com.digiwin.athena.atmc.common.domain.WorkflowInstance;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalStepDTO;
import com.digiwin.athena.atmc.common.domain.approval.ApprovalWorkItemDTO;
import com.digiwin.athena.atmc.common.enums.ActivityWorkitemSubState;
import com.digiwin.athena.atmc.common.enums.SignCategory;
import com.digiwin.athena.atmc.http.restful.bpm.WorkflowService;
import com.digiwin.athena.atmc.http.restful.bpm.model.WorkflowProcess;
import com.digiwin.athena.atmc.http.restful.bpm.model.WorkflowWorkItem;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTransformService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowTransformService.class);
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private UserService userService;

    private String getUserName(Map<String, String> nameMap, String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            if (nameMap.containsKey(userId)) {
                return nameMap.get(userId);
            }
            UserDTO userDTO = this.userService.query(userId);
            String userName = null;
            if (userDTO != null) {
                userName = userDTO.getName();
            }
            nameMap.put(userId, userName);
            return userName;
        }
        return null;
    }

    private ApprovalStepDTO builderSignInformer(WorkflowProcess signProcess, JSONObject informer, String noticeType) {
        if (signProcess == null || informer == null) {
            return null;
        }
        if (informer.containsKey((Object)noticeType)) {
            JSONArray noticeArray = JSONArray.fromObject((Object)informer.get(noticeType));
            if (noticeArray == null || noticeArray.isEmpty()) {
                return null;
            }
            ApprovalStepDTO step = ApprovalStepDTO.builder().id(0L).bpmActivityId(signProcess.getActivityId()).bpmActivityName(signProcess.getActivityName()).state(3).isReassign(false).isReexecute(false).build();
            ArrayList<ApprovalWorkItemDTO> workItemList = new ArrayList<ApprovalWorkItemDTO>();
            for (Object sn : noticeArray) {
                JSONObject noticeObject = JSONObject.fromObject(sn);
                if (!noticeObject.containsKey((Object)"userId") || StringUtils.isBlank((String)noticeObject.getString("userId"))) continue;
                ApprovalWorkItemDTO workItem = ApprovalWorkItemDTO.builder().performerId(noticeObject.getString("userId")).build();
                if (noticeObject.containsKey((Object)"userName") && StringUtils.isNotBlank((String)noticeObject.getString("userName"))) {
                    workItem.setPerformerName(noticeObject.getString("userName"));
                }
                if (noticeObject.containsKey((Object)"sendTime") && StringUtils.isNotBlank((String)noticeObject.getString("sendTime"))) {
                    workItem.setClosedTime(null);
                }
                workItemList.add(workItem);
            }
            step.setWorkitemList(workItemList);
            return step;
        }
        return null;
    }

    public List<ApprovalStepDTO> getWorkflowHistoryList(WorkflowInstance workflowInstance) {
        List workflowProcessList = this.workflowService.getWorkflowProcessList(workflowInstance.getSerialNumber(), workflowInstance.getWorkItemId());
        if (CollectionUtils.isNotEmpty((Collection)workflowProcessList)) {
            ArrayList result = Lists.newArrayList();
            HashMap nameMap = Maps.newHashMap();
            workflowProcessList.forEach(signProcess -> {
                if ("__uibot__start__".equals(signProcess.getActivityId())) {
                    ApprovalStepDTO.ApprovalStepDTOBuilder builder = ApprovalStepDTO.builder().bpmActivityId(signProcess.getActivityId()).bpmActivityName(signProcess.getActivityName()).state(3).isReassign(false).isReassign(false);
                    List workItems = signProcess.getWorkItems();
                    if (!org.springframework.util.CollectionUtils.isEmpty((Collection)workItems)) {
                        ArrayList workItemList = Lists.newArrayListWithCapacity((int)workItems.size());
                        for (WorkflowWorkItem workItem : workItems) {
                            ApprovalWorkItemDTO workItemDTO = this.initWorkItemDTO(workItem, nameMap);
                            workItemList.add(workItemDTO);
                        }
                        builder.workitemList(workItemList);
                    }
                    result.add(builder.build());
                } else {
                    ApprovalStepDTO noticeStep;
                    JSONObject informer = null;
                    if (StringUtils.isNotBlank((String)signProcess.getNoticeInformer())) {
                        informer = JSONObject.fromObject((Object)signProcess.getNoticeInformer());
                    }
                    if ((noticeStep = this.builderSignInformer((WorkflowProcess)signProcess, informer, "noticeBefore")) != null) {
                        noticeStep.setSignType(81);
                        result.add(noticeStep);
                    }
                    ApprovalStepDTO.ApprovalStepDTOBuilder builder = ApprovalStepDTO.builder().id(0L).bpmActivityId(signProcess.getActivityId()).bpmActivityName(signProcess.getActivityName()).state(signProcess.getState()).isReassign(false).isReassign(false).signType(SignCategory.parse(signProcess.getSignType()).getValue());
                    if (!Objects.equals(-1, signProcess.getState()) && CollectionUtils.isNotEmpty((Collection)signProcess.getWorkItems())) {
                        List workItems = signProcess.getWorkItems();
                        ArrayList workItemList = Lists.newArrayListWithCapacity((int)workItems.size());
                        workItems.forEach(wi -> {
                            ApprovalWorkItemDTO workItem = this.initWorkItemDTO((WorkflowWorkItem)wi, nameMap);
                            workItem.setReassign(new JSONArray());
                            if (!Objects.equals(wi.getCreateType(), 0) && wi.getSubState() > 10) {
                                workItem.setSubState(ActivityWorkitemSubState.COMPLETED.getValue());
                            }
                            workItemList.add(workItem);
                        });
                        builder.workitemList(workItemList);
                    }
                    result.add(builder.build());
                    noticeStep = this.builderSignInformer((WorkflowProcess)signProcess, informer, "noticeAfter");
                    if (noticeStep != null) {
                        noticeStep.setSignType(81);
                        result.add(noticeStep);
                    }
                }
            });
            return result;
        }
        return null;
    }

    private ApprovalWorkItemDTO initWorkItemDTO(WorkflowWorkItem workItem, Map<String, String> nameMap) {
        return ApprovalWorkItemDTO.builder().createTime(workItem.getCreateTime()).closedTime(workItem.getClosedTime()).performerId(workItem.getPerformerId()).performerName(this.getUserName(nameMap, workItem.getPerformerId())).agentPerformerId(workItem.getAgentPerformerId()).agentPerformerName(this.getUserName(nameMap, workItem.getAgentPerformerId())).comment(workItem.getComment()).subState(workItem.getSubState()).attachments(workItem.getAttachments()).createType(workItem.getCreateType()).performerType(workItem.getPerformerType()).state(workItem.getState()).build();
    }
}

