/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.util.engine;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.digiwin.athena.atmc.common.domain.BpmActivityWorkitem;
import com.digiwin.athena.atmc.common.enums.FlowEngineTableEnum;
import com.digiwin.athena.atmc.common.util.engine.FlowEngineBeanUtils;
import com.digiwin.athena.atmc.common.util.engine.FlowEngineDataRedisUtils;
import com.digiwin.athena.atmc.http.domain.Task;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisEngineTypeUtils {
    public static Boolean isPtm(Long id, FlowEngineTableEnum tableName) {
        return AnalysisEngineTypeUtils.isFlowEngine(id, tableName) == false;
    }

    public static Boolean isPtm(Long id, List<FlowEngineTableEnum> tableNames) {
        return tableNames.stream().noneMatch(t -> AnalysisEngineTypeUtils.isFlowEngine(id, t));
    }

    public static Boolean isPtm(List<String> processSerialNumbers, FlowEngineTableEnum tableName) {
        return AnalysisEngineTypeUtils.checkBpmProcessByProcessSerialNumber(tableName, processSerialNumbers) == false;
    }

    public static Boolean isPtmActivity(List<Long> ids, FlowEngineTableEnum tableName) {
        if (CollectionUtil.isEmpty(ids)) {
            return false;
        }
        return AnalysisEngineTypeUtils.isPtm(ids.get(0), tableName);
    }

    public static Boolean isPtmActivity(String param, String value) {
        return param.equals(value);
    }

    private static Boolean isFlowEngine(Long id, FlowEngineTableEnum tableName) {
        if (null == id) {
            return true;
        }
        if (FlowEngineDataRedisUtils.getFlowEngineIdFromRedis(id).booleanValue()) {
            return true;
        }
        Boolean isFlowEngine = AnalysisEngineTypeUtils.checkBpmActivityWorkItem(tableName, id) != false || AnalysisEngineTypeUtils.checkBacklog(tableName, id) != false || AnalysisEngineTypeUtils.checkBpmActivityStep(tableName, id) != false || AnalysisEngineTypeUtils.checkBpmActivity(tableName, id) != false || AnalysisEngineTypeUtils.checkActivity(tableName, id) != false || AnalysisEngineTypeUtils.checkTask(tableName, id) != false || AnalysisEngineTypeUtils.checkBpmProcess(tableName, id) != false;
        if (isFlowEngine.booleanValue()) {
            FlowEngineDataRedisUtils.insertFlowEngineIdToRedis(tableName.getValue(), id);
        }
        return isFlowEngine;
    }

    private static Boolean checkBpmActivityWorkItem(FlowEngineTableEnum tableName, Long id) {
        if (tableName == null) {
            return FlowEngineBeanUtils.getBpmActivityWorkitemMapper().queryById(id) != null;
        }
        return FlowEngineTableEnum.bpmActivityWorkitem.equals((Object)tableName) && FlowEngineBeanUtils.getBpmActivityWorkitemMapper().queryById(id) != null;
    }

    private static Boolean checkBacklog(FlowEngineTableEnum tableName, Long id) {
        return FlowEngineTableEnum.backlog.equals((Object)tableName) && FlowEngineBeanUtils.getBacklogMapper().queryById(id) != null;
    }

    private static Boolean checkBpmActivityStep(FlowEngineTableEnum tableName, Long id) {
        return FlowEngineTableEnum.bpmActivityStep.equals((Object)tableName) && FlowEngineBeanUtils.getBpmActivityStepMapper().queryById(id) != null;
    }

    private static Boolean checkBpmActivity(FlowEngineTableEnum tableName, Long id) {
        return FlowEngineTableEnum.bpmActivity.equals((Object)tableName) && FlowEngineBeanUtils.getBpmActivityMapper().queryById(id) != null;
    }

    private static Boolean checkActivity(FlowEngineTableEnum tableName, Long id) {
        return FlowEngineTableEnum.activity.equals((Object)tableName) && FlowEngineBeanUtils.getActivityMapper().queryById(id) != null;
    }

    private static Boolean checkTask(FlowEngineTableEnum tableName, Long id) {
        return FlowEngineTableEnum.task.equals((Object)tableName) && FlowEngineBeanUtils.getTaskMapper().queryById(id) != null;
    }

    private static Boolean checkBpmProcess(FlowEngineTableEnum tableName, Long id) {
        return FlowEngineTableEnum.bpmProcess.equals((Object)tableName) && FlowEngineBeanUtils.getBpmProcessMapper().queryById(id) != null;
    }

    private static Boolean checkBpmProcessByProcessSerialNumber(FlowEngineTableEnum tableEnum, List<String> processSerialNumbers) {
        if (CollectionUtils.isEmpty(processSerialNumbers)) {
            return true;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"process_serial_number", processSerialNumbers);
        List list = FlowEngineBeanUtils.getBpmProcessMapper().selectList((Wrapper)queryWrapper);
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    public static List<BpmActivityWorkitem> queryActivityByStepId(Set<String> stepIdSet) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"activity_step_id", stepIdSet);
        queryWrapper.ne((Object)"type", (Object)89);
        queryWrapper.ne((Object)"type", (Object)88);
        return FlowEngineBeanUtils.getBpmActivityWorkitemMapper().selectList((Wrapper)queryWrapper);
    }

    public static List<Task> queryTaskByMainTaskId(Long mainTaskId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(Task::getMainTaskId, (Object)mainTaskId)).select(new SFunction[]{Task::getId});
        return FlowEngineBeanUtils.getTaskMapper().selectList((Wrapper)wrapper);
    }
}

