/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.backlog;

import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.ActivityDataBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BacklogActionCreateParentService {
    @Autowired
    private ThemeMapService themeMapService;

    public void processApproval(long workitemId, ActivityDataBO backLogMap, Map<String, Object> map) {
        String tmActivityId;
        if (Objects.equals(backLogMap.getTmCategory(), TmTaskCategoryEnum.SOLVE.getValue())) {
            return;
        }
        String tmTaskId = backLogMap.getTmTaskId();
        String targetApproveActivity = this.getTargetApproveActivity(tmTaskId, tmActivityId = backLogMap.getTmActivityId());
        if (StringUtils.isBlank((String)targetApproveActivity)) {
            return;
        }
        List tasks = (List)map.get("tasks");
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            return;
        }
        for (Object taskObj : tasks) {
            Map task = (Map)taskObj;
            List backlogs = (List)task.get("backlog");
            Map backlog = (Map)backlogs.get(0);
            Object workItemId = backlog.containsKey("ptmBacklogId") && null != backlog.get("ptmBacklogId") ? backlog.get("ptmBacklogId") : backlog.get("backlogId");
            HashMap signProgressMap = new HashMap();
            signProgressMap.put("processSerialNumber", task.get("processSerialNumber"));
            ArrayList<String> activityIds = new ArrayList<String>();
            activityIds.add(targetApproveActivity);
            signProgressMap.put("tmActivityIds", activityIds);
            signProgressMap.put("workitemId", workItemId);
            signProgressMap.put("ptmWorkItemId", backlog.get("ptmWorkItemId"));
            task.put("relationApproval", signProgressMap);
        }
    }

    private String getTargetApproveActivity(String tmTaskId, String tmActivityId) {
        return this.themeMapService.getActivityTargetCode(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
    }
}

