/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.mongodb;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.domain.backlog.BkItemDTO;
import com.digiwin.athena.atmc.common.mongodb.DistributeLocker;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.buf.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MongodbService {
    private static final Logger log = LoggerFactory.getLogger(MongodbService.class);
    @Autowired
    @Qualifier(value="atmcBkDatabaseMongoTemplate")
    private MongoTemplate atmcBkDatabaseMongoTemplate;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final String LOCK_NAME_SUFFIX = ":createMongoCollection:lock";
    private List<String> existCollectionList = new ArrayList<String>();

    public void createCollectionLock(String collectionName, Map<String, Object> indexMap) {
        if (this.existCollectionList.contains(collectionName)) {
            return;
        }
        if (this.atmcBkDatabaseMongoTemplate.collectionExists(collectionName)) {
            this.existCollectionList.add(collectionName);
            return;
        }
        String tmpLockName = "atmc:" + collectionName + LOCK_NAME_SUFFIX;
        DistributeLocker.tryLock30s(this.redisTemplate, tmpLockName, () -> this.createCollectionAndIndex(collectionName, indexMap));
    }

    public void createCollectionLock(String collectionName, List<IndexModel> indexList) {
        if (this.existCollectionList.contains(collectionName)) {
            return;
        }
        if (this.atmcBkDatabaseMongoTemplate.collectionExists(collectionName)) {
            this.existCollectionList.add(collectionName);
            return;
        }
        String tmpLockName = "atmc:" + collectionName + LOCK_NAME_SUFFIX;
        DistributeLocker.tryLock30s(this.redisTemplate, tmpLockName, () -> this.createCollectionAndIndexMulti(collectionName, indexList));
    }

    private void createCollectionAndIndex(String collectionName, Map<String, Object> indexMap) {
        this.atmcBkDatabaseMongoTemplate.createCollection(collectionName);
        this.existCollectionList.add(collectionName);
        if (indexMap != null && indexMap.size() > 0) {
            String indexName = StringUtils.join(indexMap.keySet(), (char)'_');
            IndexOptions indexOptions = new IndexOptions();
            indexOptions.background(true);
            indexOptions.name(indexName);
            this.atmcBkDatabaseMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(indexMap), indexOptions);
        }
    }

    private void createCollectionAndIndexMulti(String collectionName, List<IndexModel> indexList) {
        this.atmcBkDatabaseMongoTemplate.createCollection(collectionName);
        this.existCollectionList.add(collectionName);
        for (IndexModel indexModel : indexList) {
            this.atmcBkDatabaseMongoTemplate.getCollection(collectionName).createIndex(indexModel.getKeys(), indexModel.getOptions());
        }
    }

    public void insert(List<Map> dataList, String collectionName) {
        this.atmcBkDatabaseMongoTemplate.insert(dataList, collectionName);
    }

    public <T> void insertBatch(Collection<? extends T> batchToSave, String collectionName) {
        this.atmcBkDatabaseMongoTemplate.insert(batchToSave, collectionName);
    }

    public void updateFirst(String collectionName, Query query, Update update) {
        this.atmcBkDatabaseMongoTemplate.updateFirst(query, (UpdateDefinition)update, collectionName);
    }

    public List<Map> query(String collectionName, Query query) {
        return this.atmcBkDatabaseMongoTemplate.find(query, Map.class, collectionName);
    }

    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        return this.atmcBkDatabaseMongoTemplate.find(query, entityClass, collectionName);
    }

    public List<Map> executeQueryCommand(String jsonCommand) {
        Document document = this.atmcBkDatabaseMongoTemplate.executeCommand(jsonCommand);
        Map cursor = (Map)document.get("cursor");
        List mapList = (List)cursor.get("firstBatch");
        return mapList;
    }

    public List<Map> executeQueryCommand(Map jsonCommand) {
        return this.executeQueryCommand(JsonUtils.objectToString((Object)jsonCommand));
    }

    public void deleteIdexFromCollections(String deleteIndex) {
        Set collectionNameSet = this.atmcBkDatabaseMongoTemplate.getCollectionNames();
        if (CollectionUtils.isEmpty((Collection)collectionNameSet)) {
            return;
        }
        for (String collectionName : collectionNameSet) {
            List indexList = this.atmcBkDatabaseMongoTemplate.indexOps(collectionName).getIndexInfo();
            ArrayList<String> indexNameList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)indexList)) {
                for (IndexInfo indexInfo : indexList) {
                    indexNameList.add(indexInfo.getName());
                }
            }
            if (!indexNameList.contains(deleteIndex)) continue;
            this.atmcBkDatabaseMongoTemplate.indexOps(collectionName).dropIndex(deleteIndex);
        }
    }

    public void insertIndex(Map<String, Object> indexMap) {
        Set collectionNameSet = this.atmcBkDatabaseMongoTemplate.getCollectionNames();
        if (CollectionUtils.isEmpty((Collection)collectionNameSet)) {
            return;
        }
        for (String collectionName : collectionNameSet) {
            if (indexMap == null || indexMap.size() <= 0) continue;
            String indexName = StringUtils.join(indexMap.keySet(), (char)'_');
            IndexOptions indexOptions = new IndexOptions();
            indexOptions.background(true);
            indexOptions.name(indexName);
            List indexList = this.atmcBkDatabaseMongoTemplate.indexOps(collectionName).getIndexInfo();
            ArrayList<String> indexNameList = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)indexList)) {
                for (IndexInfo indexInfo : indexList) {
                    indexNameList.add(indexInfo.getName());
                }
            }
            if (!CollectionUtils.isEmpty(indexNameList) && indexNameList.contains(indexName)) continue;
            this.atmcBkDatabaseMongoTemplate.getCollection(collectionName).createIndex((Bson)new Document(indexMap), indexOptions);
        }
    }

    public void updateMulti(String collectionName, Query query, Update update) {
        this.atmcBkDatabaseMongoTemplate.updateMulti(query, (UpdateDefinition)update, collectionName);
    }

    public void deleteData(BkItemDTO bkItemDTO) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"cardId").is((Object)bkItemDTO.getCardId()).and("tenantId").is((Object)bkItemDTO.getTenantId()).and("bkContent").is((Object)bkItemDTO.getBkContent()).and("type").is((Object)"workitem"));
        this.atmcBkDatabaseMongoTemplate.remove(query, bkItemDTO.getTenantId());
    }

    public void delete(Query query, String collectionName) {
        this.atmcBkDatabaseMongoTemplate.remove(query, collectionName);
    }
}

