/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.service.project;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.dao.TaskMapper;
import com.digiwin.athena.atmc.common.domain.BpmProcess;
import com.digiwin.athena.atmc.common.domain.backlog.CardAbstractDTO;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.common.util.BacklogAbstractUtil;
import com.digiwin.athena.atmc.http.domain.Task;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityPageDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmDataState;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmScheduleConfig;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmTaskDefineResponseDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonProjectHandleService {
    private static final Logger log = LoggerFactory.getLogger(CommonProjectHandleService.class);
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private ThemeMapService themeMapService;
    @Autowired
    private AglieService aglieService;
    @Autowired
    private CommonPtmTransformService commonPtmTransformService;
    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;

    private List<Map<String, Object>> getTasks(Long projectCardId) {
        ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
        List<BpmProcess> processList = this.commonPtmTransformService.getProjectByProjectCardId(projectCardId);
        for (BpmProcess bpmProcess : processList) {
            HashMap<String, String> taskObject = new HashMap<String, String>();
            taskObject.put("processSerialNumber", bpmProcess.getProcessSerialNumber());
            taskObject.put("bpmData", (String)bpmProcess.getData());
            taskObject.put("businessUnit", (String)bpmProcess.getBusinessUnit());
            taskObject.put("proxyToken", bpmProcess.getProxyToken());
            tasks.add(taskObject);
        }
        return tasks;
    }

    public Map getActivityData(Task task) {
        HashMap<String, Object> project = new HashMap<String, Object>();
        project.put("projectId", task.getId());
        project.put("tmProjectId", task.getTmTaskId());
        project.put("chargeId", task.getPersonInCharge());
        project.put("chargeName", task.getPersonInChargeName());
        project.put("tenantId", task.getTenantId());
        project.put("startTime", task.getStartTime());
        project.put("endTime", task.getEndTime());
        project.put("projectName", task.getName());
        List<Map<String, Object>> tasks = this.getTasks(task.getId());
        HashMap<String, Object> activityData = new HashMap<String, Object>();
        activityData.put("project", project);
        activityData.put("tasks", tasks);
        return activityData;
    }

    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId, boolean needHistoryInfo) {
        return this.getProjectCardSelfAbstract(user, projectId, new CardAbstractDTO().setNeedHistoryInfo(needHistoryInfo));
    }

    public Map getProjectActivityData(Long projectId) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        if (task != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            return this.getActivityData(task);
        }
        return null;
    }

    public void saveProjectCardData(Long projectId) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        if (task != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            Map activityData = this.getActivityData(task);
            activityData.put("businessMessageSourceType", "api");
            activityData.put("cardId", projectId);
            activityData.put("pageCode", TmPageName.PROJECT_CARD_NAME.getValue());
            activityData.put("tmTaskId", task.getTmTaskId());
            activityData.put("tenantId", task.getTenantId());
            this.backlogAbstractUtil.getAndSaveBusinessMessage(activityData);
        }
    }

    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId, CardAbstractDTO cardAbstractDTO) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (task != null) {
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            Map activityData = this.setCheckSummaryForProjectCardAbstract(map, task, cardAbstractDTO);
            if (activityData != null && BooleanUtils.isTrue((Boolean)cardAbstractDTO.getNeedBusinessMessage())) {
                activityData.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
                activityData.put("cardId", projectId);
                activityData.put("pageCode", TmPageName.PROJECT_CARD_NAME.getValue());
                activityData.put("tmTaskId", task.getTmTaskId());
                activityData.put("tenantId", task.getTenantId());
                this.backlogAbstractUtil.getAndSaveBusinessMessage(activityData);
            }
        }
        return map;
    }

    private Map setCheckSummaryForProjectCardAbstract(Map<String, Object> map, Task task, CardAbstractDTO cardAbstractDTO) {
        Map pageData;
        TmDataState dataState;
        TmDataState dataState2;
        map.put("overdue", false);
        String tmTaskId = (String)map.get("tmTaskId");
        long projectId = (Long)map.get("projectId");
        TmTaskDefineResponseDTO themeMap = this.themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return null;
        }
        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (!pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            return null;
        }
        String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
        projectCardPage = (TmActivityPageDTO)JsonUtils.jsonToObject((String)json, TmActivityPageDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0 && CollectionUtils.isNotEmpty((Collection)(dataState2 = (TmDataState)projectCardPage.getDataStates().get(0)).getSummaryFields())) {
            projectCardPage.setSummaryFields(dataState2.getSummaryFields());
        }
        if (CollectionUtils.isEmpty((Collection)projectCardPage.getSummaryFields())) {
            return null;
        }
        Map activityData = this.getActivityData(task);
        activityData.put("needHistoryInfo", cardAbstractDTO.getNeedHistoryInfo());
        BaseResultDTO actionResponse = this.aglieService.getProjectCardDataByProjectDataAbstract(tmTaskId, Long.valueOf(projectId), (Object)activityData);
        if (actionResponse == null || actionResponse.getResponse() == null) {
            return activityData;
        }
        Map cardAbstractMap = (Map)actionResponse.getResponse();
        if (MapUtil.isEmpty((Map)cardAbstractMap)) {
            return activityData;
        }
        TmScheduleConfig scheduleConfig = projectCardPage.getScheduleConfig();
        map.put("scheduleRefreshCardMessage", projectCardPage.getScheduleRefreshCardMessage());
        map.put("scheduleRefreshCardType", projectCardPage.getScheduleRefreshCardType());
        map.put("summaryLayout", cardAbstractMap.get("summaryLayoutStr"));
        map.put("historyMessage", cardAbstractMap.get("historyMessage"));
        map.put("searchMessage", cardAbstractMap.get("searchMessage"));
        map.put("projectMessage", cardAbstractMap.get("projectMessage"));
        if (CollectionUtils.isNotEmpty((Collection)projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0 && !StringUtils.isEmpty((String)(dataState = (TmDataState)projectCardPage.getDataStates().get(0)).getOverduePropertyName())) {
            projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
        }
        if (!StringUtils.isEmpty((String)projectCardPage.getOverduePropertyName()) && cardAbstractMap.containsKey("pageData") && cardAbstractMap.get("pageData") != null && cardAbstractMap.get("pageData") instanceof Map && MapUtils.isNotEmpty((Map)(pageData = (Map)cardAbstractMap.get("pageData"))) && pageData.containsKey(projectCardPage.getOverduePropertyName())) {
            Object overdue = pageData.get(projectCardPage.getOverduePropertyName());
            map.put("overdue", Objects.equals(overdue, 1.0));
        }
        return activityData;
    }

    public Map getProjectCardSelf(AuthoredUser user, long projectId) {
        Task task = this.commonPtmTransformService.getTask(projectId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tmTaskId", task.getTmTaskId());
        map.put("projectId", projectId);
        this.setCheckSummaryForProjectCard(map, task);
        return map;
    }

    private void setCheckSummaryForProjectCard(Map<String, Object> map, Task task) {
        Map pageData;
        Map response;
        TmDataState dataState;
        TmDataState dataState2;
        map.put("overdue", false);
        String tmTaskId = (String)map.get("tmTaskId");
        long projectId = (Long)map.get("projectId");
        TmTaskDefineResponseDTO themeMap = this.themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return;
        }
        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (!pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            return;
        }
        String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
        projectCardPage = (TmActivityPageDTO)JsonUtils.jsonToObject((String)json, TmActivityPageDTO.class);
        if (CollectionUtils.isNotEmpty((Collection)projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0 && CollectionUtils.isNotEmpty((Collection)(dataState2 = (TmDataState)projectCardPage.getDataStates().get(0)).getSummaryFields())) {
            projectCardPage.setSummaryFields(dataState2.getSummaryFields());
        }
        if (CollectionUtils.isEmpty((Collection)projectCardPage.getSummaryFields())) {
            return;
        }
        Map activityData = this.getActivityData(task);
        BaseResultDTO actionResponse = this.aglieService.getProjectCardDataByProjectData(tmTaskId, Long.valueOf(projectId), (Object)activityData);
        if (actionResponse == null || actionResponse.getResponse() == null || !((Map)actionResponse.getResponse()).containsKey("pageData")) {
            return;
        }
        map.put("summaryLayout", actionResponse.getResponse());
        if (CollectionUtils.isNotEmpty((Collection)projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0 && !StringUtils.isEmpty((String)(dataState = (TmDataState)projectCardPage.getDataStates().get(0)).getOverduePropertyName())) {
            projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
        }
        if (!StringUtils.isEmpty((String)projectCardPage.getOverduePropertyName()) && (response = (Map)actionResponse.getResponse()).containsKey("pageData") && response.get("pageData") != null && response.get("pageData") instanceof Map && MapUtils.isNotEmpty((Map)(pageData = (Map)response.get("pageData")))) {
            for (Map.Entry stringObjectEntry : pageData.entrySet()) {
                List list;
                if (stringObjectEntry.getValue() == null) continue;
                Map firstValue = null;
                if (stringObjectEntry.getValue() instanceof Map) {
                    firstValue = (Map)stringObjectEntry.getValue();
                } else if (stringObjectEntry.getValue() instanceof List && CollectionUtils.isNotEmpty((Collection)(list = (List)stringObjectEntry.getValue()))) {
                    firstValue = (Map)list.get(0);
                }
                if (firstValue == null || !firstValue.containsKey(projectCardPage.getOverduePropertyName())) continue;
                Object overdue = firstValue.get(projectCardPage.getOverduePropertyName());
                map.put("overdue", Objects.equals(overdue, 1));
            }
        }
    }
}

