/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.common.util;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atmc.http.domain.BacklogCardField;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class BacklogAbstractUtil {
    private static final Logger log = LoggerFactory.getLogger(BacklogAbstractUtil.class);
    @Resource
    private AglieService aglieService;
    @Resource(name="atmcCardBusinessMessageMongoTemplate")
    private MongoTemplate atmcCardBusinessMessageMongoTemplate;
    public static final String BACKLOG_CARD_FIELD = "backlogCardField";

    public void removeBusinessMessage(Collection<Long> cardIds, String tenantId, String pageCode) {
        if (CollectionUtils.isEmpty(cardIds) || StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)pageCode)) {
            log.debug("RemoveBusinessMessage fail, cardId: {}, tenantId: {}, pageCode: {}", new Object[]{null, tenantId, pageCode});
            return;
        }
        Criteria criteria = Criteria.where((String)"cardId").in(cardIds).and("pageCode").is((Object)pageCode).and("tenantId").is((Object)tenantId);
        this.atmcCardBusinessMessageMongoTemplate.remove(Query.query((CriteriaDefinition)criteria), BACKLOG_CARD_FIELD);
    }

    public Map<Long, Map<String, List<String>>> getAndBuildBusinessMessage(List<Long> cardIdList, String pageCode, String tenantId) {
        Map<Long, Map<String, List<String>>> businessMessage = null;
        try {
            long start = System.currentTimeMillis();
            businessMessage = this.getAndBuildBusinessMessageInner(cardIdList, pageCode, tenantId);
            log.debug("Get batch businessMessage cost: {}ms, batchSize: {}", (Object)(System.currentTimeMillis() - start), (Object)cardIdList.size());
        }
        catch (Exception e) {
            log.warn("Get batch businessMessage failed: {}", (Object)ExceptionUtil.getSimpleMessage((Throwable)e));
        }
        return businessMessage;
    }

    public Map<Long, Map<String, List<String>>> getAndBuildBusinessMessageInner(List<Long> cardIdList, String pageCode, String tenantId) {
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            tenantId = AppAuthContextHolder.getContext().getAuthoredUser().getTenantId();
        }
        Criteria criteria = Criteria.where((String)"cardId").in(cardIdList).and("pageCode").is((Object)pageCode).and("tenantId").is((Object)tenantId);
        List backlogCardFieldList = this.atmcCardBusinessMessageMongoTemplate.find(new Query((CriteriaDefinition)criteria), BacklogCardField.class, BACKLOG_CARD_FIELD);
        HashMap map = Maps.newHashMapWithExpectedSize((int)backlogCardFieldList.size());
        for (BacklogCardField backlogCardField : backlogCardFieldList) {
            List valueList = backlogCardField.getValueList();
            if (!CollectionUtils.isNotEmpty((Collection)valueList)) continue;
            Map row = (Map)valueList.get(0);
            HashMap firstRow = Maps.newHashMapWithExpectedSize((int)row.size());
            row.forEach((k, v) -> {
                if (CollectionUtils.isNotEmpty((Collection)v)) {
                    firstRow.put(k, v.stream().map(String::valueOf).collect(Collectors.toList()));
                }
            });
            map.put(backlogCardField.getCardId(), firstRow);
        }
        return map;
    }

    public void getAndSaveBusinessMessage(Map activityDataDTO) {
        try {
            String tmTaskId = MapUtils.getString((Map)activityDataDTO, (Object)"tmTaskId");
            String tmActivityId = MapUtils.getString((Map)activityDataDTO, (Object)"tmActivityId");
            BaseResultDTO cardBusinessMessageResp = this.aglieService.getCardBusinessMessage(tmTaskId, tmActivityId, (Object)activityDataDTO);
            Map cardBusinessMessage = (Map)cardBusinessMessageResp.getResponse();
            if (MapUtils.isNotEmpty((Map)cardBusinessMessage)) {
                Long cardId = MapUtils.getLong((Map)activityDataDTO, (Object)"cardId");
                String pageCode = MapUtils.getString((Map)activityDataDTO, (Object)"pageCode");
                String tenantId = MapUtils.getString((Map)activityDataDTO, (Object)"tenantId");
                this.saveBusinessMessageInner(cardId, tenantId, pageCode, cardBusinessMessage);
            } else {
                log.warn("Get businessMessage empty, tmTaskId: {}, tmActivityId: {}", (Object)tmTaskId, (Object)tmActivityId);
            }
        }
        catch (Exception e) {
            log.warn("Get and Save businessMessage failed: {}", (Object)ExceptionUtil.getSimpleMessage((Throwable)e));
        }
    }

    private void saveBusinessMessageInner(Long cardId, String tenantId, String pageCode, Map<String, Object> businessMessage) {
        this.removeBusinessMessage(Lists.newArrayList((Object[])new Long[]{cardId}), tenantId, pageCode);
        BacklogCardField backlogCardField = this.buildBacklogCardField(cardId, tenantId, pageCode, businessMessage);
        this.atmcCardBusinessMessageMongoTemplate.insert((Object)backlogCardField, BACKLOG_CARD_FIELD);
    }

    private BacklogCardField buildBacklogCardField(Long cardId, String tenantId, String pageCode, Map<String, Object> businessMessage) {
        HashMap valueMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : businessMessage.entrySet()) {
            String fieldPathCombine = entry.getKey();
            List fieldPathList = CharSequenceUtil.split((CharSequence)fieldPathCombine, (CharSequence)"__");
            String aliasField = (String)fieldPathList.get(1);
            Set aliasFieldValueSet = valueMap.computeIfAbsent(aliasField, v -> Sets.newLinkedHashSet());
            Object fieldValueObj = entry.getValue();
            if (fieldValueObj instanceof Collection) {
                aliasFieldValueSet.addAll((Collection)fieldValueObj);
                continue;
            }
            aliasFieldValueSet.add(fieldValueObj);
        }
        BacklogCardField backlogCardField = new BacklogCardField().setCardId(cardId).setPageCode(pageCode).setTenantId(tenantId).setValueList((List)Lists.newArrayList((Object[])new Map[]{valueMap}));
        return backlogCardField;
    }

    public void saveOrUpdateBusinessMessageInner(String tenantId, String pageCode, Map<Long, Map<String, Object>> cardToData) {
        if (MapUtils.isEmpty(cardToData)) {
            return;
        }
        Set<Long> set = cardToData.keySet();
        this.removeBusinessMessage(set, tenantId, pageCode);
        ArrayList rows = new ArrayList(cardToData.size());
        cardToData.forEach((k, v) -> {
            if (!MapUtils.isEmpty((Map)v)) {
                rows.add(this.buildBacklogCardField((Long)k, tenantId, pageCode, (Map<String, Object>)v));
            }
        });
        if (rows.size() > 0) {
            this.atmcCardBusinessMessageMongoTemplate.insert(rows, BACKLOG_CARD_FIELD);
        }
    }
}

