package com.digiwin.athena.atmc.common.bk.parser.dto.metadata;


import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.bk.parser.dto.BkNode;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;
import java.util.Set;

/**
 * 任务bk元数据
 *
 * @author zhangzhi@digiwin.com
 * @date 2021/11/22
 */
@Getter
@Setter
public class TaskBkMetadata implements IMetadataUnit {
    private MetadataUnit unit;

    public TaskBkMetadata(MetadataUnit unit) {
        this.unit = unit;
    }

    public String getSource() {
        return unit.getSource();
    }

    public String getEntityName() {
        return unit.getEntityName();
    }

    public Set<String> getAllJsonPath() {
        return unit.getAllJsonPath();
    }

    public String getShortestPath() {
        return unit.getShortestPath();
    }

    public int getShortestLength() {
        return unit.getShortestLength();
    }

    public boolean isRoot() {
        return unit.isRoot();
    }

    public Set<String> getLongestPath() {
        return unit.getLongestPath();
    }

    public boolean isExistLongest() {
        return unit.isExistLongest();
    }

    public String getPathInstance() {
        return unit.getPathInstance();
    }

    public Map<String, BkNode> getBkFields() {
        return unit.getBkFields();
    }

    @Override
    public String toString() {
        return JsonUtils.objectToString(this);
    }
}
