package com.digiwin.athena.atmc.common.bk.parser.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.bk.parser.IParser;
import com.digiwin.athena.atmc.common.bk.parser.bo.ParserBo;
import com.digiwin.athena.atmc.common.bk.parser.event.IEvent;
import com.digiwin.athena.atmc.common.bk.parser.event.TaskEvent;
import com.digiwin.athena.atmc.common.bk.parser.instance.IBkInstanceParser;
import com.digiwin.athena.atmc.common.bk.parser.metadata.IBkMetadataParser;

import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.TaskBkMetadata;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;


import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/11/24
 */
@Service("taskParser")
public class TaskParser implements IParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskParser.class);

    private IBkMetadataParser bkMetadataParser;
    private IBkInstanceParser bkInstanceParser;

    public TaskParser(@Qualifier("taskBkMetadataParser") IBkMetadataParser bkMetadataParser, @Qualifier("taskBkInstanceParser") IBkInstanceParser bkInstanceParser) {
        this.bkMetadataParser = bkMetadataParser;
        this.bkInstanceParser = bkInstanceParser;
    }

    @Override
    public List<ParserBo> parse(IEvent event, AuthoredUser user) throws Exception {
        TaskEvent taskEvent = (TaskEvent) event;
        /** 获取API的bk元数据信息 */
        TaskBkMetadata bkMetadata = (TaskBkMetadata) bkMetadataParser.parse(taskEvent.getTempId(),taskEvent.getType(),user);

        /** 根据获取到的元数据定义以及对应的请求数据，解析出所有的bk实例数据 */
        List<JSONObject> bkInfo = bkInstanceParser.parse(bkMetadata, taskEvent.getBkData());
        if (CollectionUtils.isEmpty(bkInfo)) {
            LOGGER.warn("taskEvent为{}解析出来的业务主键为空！", bkInfo);
        }

        return bkInfo.stream().map(bk -> new ParserBo(bk, bkMetadata.getEntityName())).collect(Collectors.toList());
    }


    public static void main(String[] args) throws JsonProcessingException {
        String str = "{\"data\": {\n" +
                "                    \"detailField\": \"uuid_data\",\n" +
                "                    \"processEmergency\": 50,\n" +
                "                    \"dueDate\": \"2021-10-11\",\n" +
                "                    \"purchase\": [\n" +
                "                        {\n" +
                "                            \"key1\":[\n" +
                "                                {\n" +
                "                                    \"purchase_no\": \"331-101009004\",\n" +
                "                                    \"purchase_seq\": \"0001\",\n" +
                "                                    \"purchase_sub_seq\": \"\"\n" +
                "                                },\n" +
                "                                {\n" +
                "                                    \"purchase_no\": \"331-101009004\",\n" +
                "                                    \"purchase_seq\": \"0002\",\n" +
                "                                    \"purchase_sub_seq\": \"\"\n" +
                "                                }\n" +
                "                            ]\n" +
                "                        },\n" +
                "                        {\n" +
                "                            \"key2\":[\n" +
                "                                {\n" +
                "                                    \"purchase_no\": \"331-101009004\",\n" +
                "                                    \"purchase_seq\": \"0003\",\n" +
                "                                    \"purchase_sub_seq\": \"\"\n" +
                "                                },\n" +
                "                                {\n" +
                "                                    \"purchase_no\": \"331-101009004\",\n" +
                "                                    \"purchase_seq\": \"0004\",\n" +
                "                                    \"purchase_sub_seq\": \"\"\n" +
                "                                }\n" +
                "                            ]\n" +
                "                        }\n" +
                "                        \n" +
                "                    ],\n" +
                "                    \"proxyToken\": \"bf075f29-b20e-4358-a87b-c94e65f8b3ae\",\n" +
                "                    \"sourceIds\": \"311-101009005\",\n" +
                "                    \"personInCharge\": \"emp008\",\n" +
                "                    \"process_EOC\": {\n" +
                "                        \"eoc_company_id\": \"TCm02\",\n" +
                "                        \"eoc_site_id\": \"Pt02\"\n" +
                "                    }\n" +
                "                }" +
                "}";

        ObjectMapper mapper = new ObjectMapper();
        JSONObject jsonObject =JSONObject.fromObject(str);
        JsonNode jsonNode = mapper.readTree(JsonUtils.objectToString(jsonObject));
        JsonNode aa = jsonNode.at("/data/purchase/0/key1");
        System.out.println();
    }

}
