package com.digiwin.athena.atmc.common.bk.parser.instance.impl;


import com.digiwin.athena.atmc.common.bk.parser.core.Constant;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.IMetadataUnit;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.TaskBkMetadata;
import com.digiwin.athena.atmc.common.bk.parser.instance.AbstractBkInstanceParser;
import com.digiwin.athena.atmc.common.bk.parser.instance.IBkInstanceParser;
import com.fasterxml.jackson.databind.JsonNode;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/11/23
 */
@Service("taskBkInstanceParser")
public class TaskBkInstanceParser extends AbstractBkInstanceParser implements IBkInstanceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskBkInstanceParser.class);

    @Override
    public List<JSONObject> parse(IMetadataUnit metadata, JSONObject data) throws Exception {
        if (!(metadata instanceof TaskBkMetadata)) {
            LOGGER.warn("metadata 类型错误，非TaskBkMetadata类型");
            return null;
        }
        TaskBkMetadata taskBkMetadata = (TaskBkMetadata) metadata;
        /** 获取承载业务主键的根节点，如果isRoot为True返回的messageData下的processVar节点{processVar:{}}， 如果是false,返回的是processVar节点对应的Object:{} */
        JsonNode originalNode = getNode(data);
        return parse(taskBkMetadata.getUnit(), originalNode, Constant.Common.PROCESS_VAR);
    }
}
