package com.digiwin.athena.atmc.common.cache;

import java.time.Duration;

public interface CacheService {

    boolean hasKey(String key);
    boolean hasKey(String serviceName,String functionName,String paraStr);
    void delete(String key);
    void cache(String key,String value);
    void cache(String key, String value, Duration duration);
    void cache(String serviceName,String functionName,String paraStr, String value);
    void cache(String serviceName, String functionName, String paraStr, String value, Duration duration);
    Object get(String key);
    Object get(String serviceName,String functionName,String paraStr);
    void batchDelete(String pattern);
    void cacheNoPrefix(String key,String value);

}
