package com.digiwin.athena.atmc.common.cache.impl;

import com.digiwin.athena.atmc.common.cache.CacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.time.Duration;
import java.util.Set;

@Service
public class CacheServiceImpl implements CacheService {

    private static String keyPrefix = "atmc:cache:";

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public boolean hasKey(String key) {
        return stringRedisTemplate.hasKey(keyPrefix + key);
    }

    @Override
    public boolean hasKey(String serviceName, String functionName, String paraStr) {
        return hasKey(getFormatKey(serviceName, functionName, paraStr));
    }

    @Override
    public void delete(String key) {
        stringRedisTemplate.delete(keyPrefix + key);
    }

    @Override
    public void cache(String key, String value) {
        stringRedisTemplate.boundValueOps(keyPrefix + key).set(value);
    }

    @Override
    public void cache(String key, String value, Duration duration) {
        stringRedisTemplate.boundValueOps(keyPrefix + key).set(value, duration);
    }

    @Override
    public void cache(String serviceName, String functionName, String paraStr, String value) {
        cache(getFormatKey(serviceName, functionName, paraStr), value);
    }

    @Override
    public void cache(String serviceName, String functionName, String paraStr, String value, Duration duration) {
        cache(getFormatKey(serviceName, functionName, paraStr), value, duration);
    }

    @Override
    public Object get(String key) {
        key = keyPrefix + key;
        return stringRedisTemplate.boundValueOps(key).get();
    }

    @Override
    public Object get(String serviceName, String functionName, String paraStr) {
        return get(getFormatKey(serviceName, functionName, paraStr));
    }

    private String getFormatKey(String serviceName, String functionName, String paraStr) {
        return String.format("%s.%s(%s)", serviceName, functionName, paraStr);
    }


    @Override
    public void batchDelete(String pattern) {
        Set<String> keys = stringRedisTemplate.keys(keyPrefix + pattern);
        stringRedisTemplate.delete(keys);

//        Set<String> ruleKeys = redisTemplate.keys(USER_RULE_CACHE_CACHE_PREFIX+pattern);
//        redisTemplate.delete(ruleKeys);

    }


    @Override
    public void cacheNoPrefix(String key, String value) {
        stringRedisTemplate.opsForValue().set(key, value);
    }

}
