package com.digiwin.athena.atmc.common.constant;

import com.baomidou.mybatisplus.core.enums.IEnum;

import java.util.Objects;

/**
 * 历史数据类型
 */
public enum PtmBacklogTypeEnum implements IEnum<Integer> {
    NORMAL(0),
    /**
     * 1 回复型-辅助执行者
     */
    REPLY_ASSIST(1),
    /**
     * 2 回复型-跨租户
     */
    REPLY_CROSS_TENANT(2);

    private Integer value;

    PtmBacklogTypeEnum(Integer value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    /**
     * 是否为普通任务卡类型（type=0）
     *
     * @param type
     * @return
     */
    public static boolean isNormalBacklogType(Integer type) {
        return Objects.equals(NORMAL.getValue(), type);
    }

    /**
     * 是否为回复型辅助执行者、跨租户任务卡类型
     *
     * @param type
     * @return
     */
    public static boolean isReplyAssistOrCrossTenantBacklogType(Integer type) {
        return Objects.equals(REPLY_ASSIST.getValue(), type) || Objects.equals(REPLY_CROSS_TENANT.getValue(), type);
    }
}
