package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.BpmProcess;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component
public interface BpmProcessMapper    extends BaseMapper<BpmProcess> {

    /**
     * 根据项目ID(task.id)，查询流程的部分数据
     * @param projectId 项目ID(task.id)
     * @return
     */
    List<BpmProcess> selectListByProjectId(@Param("projectId") Long projectId);

    /**
     * 根据租户和流程序号，查找流程
     * @param tenantId
     * @param processSerialNumber
     * @return
     */
    BpmProcess getByTenantIdAndProcessSerialNumber(@Param("tenantId") String tenantId, @Param("processSerialNumber") String processSerialNumber);

    /**
     * 根据租户和流程序号，获取 流程的部分 信息
     * @param tenantId
     * @param processSerialNumber
     * @return id, task_id
     */
    BpmProcess getPartialByTenantIdAndProcessSerialNumber(@Param("tenantId") String tenantId, @Param("processSerialNumber") String processSerialNumber);

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<BpmProcess> entityList);

    List<BpmProcess> selectByTaskId(@Param("taskId") Long taskId);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);
}