package com.digiwin.athena.atmc.common.dao.ptm;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.QueryTaskVO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.PtmProjectCard;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Component
public interface PtmProjectCardMapper extends BaseMapper<PtmProjectCard> {

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<PtmProjectCard> entityList);

    /**
     * 关闭项目卡。只更新 state 和 modify_date
     *
     * @param projectCardId
     * @param state
     * @param modifyDate
     * @return
     */
    Integer closeProjectCard(@Param("projectCardId") Long projectCardId, @Param("state") Integer state, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * @param projectCardIds
     * @return id, favorite, read_count, modify_date
     */
    List<PtmProjectCard> getProjectCardPartialByIds(@Param("projectCardIds") List<Long> projectCardIds);

    /**
     * 已读次数增1
     *
     * @param projectCardId
     * @param modifyDate
     * @return
     */
    int increaseReadCount(@Param("projectCardId") Long projectCardId, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 设置是否加入我的最爱
     *
     * @param projectCardId
     * @param favorite      0-不加入，1-加入
     * @param modifyDate
     * @return
     */
    int updateFavorite(@Param("projectCardId") Long projectCardId, @Param("favorite") Integer favorite, @Param("modifyDate") LocalDateTime modifyDate);

    /**
     * 更新提交唯一键
     *
     * @param backlogId 项目ID
     * @return
     */
    int updateSubmitId(@Param("backlogId") Long backlogId);

    /**
     * 获取进行中的项目卡最后更新时间
     *
     * @param userId
     * @param tenantId
     * @return
     */
    LocalDateTime selectLastModifyDate(@Param("userId") String userId, @Param("tenantId") String tenantId);

    /**
     * 转派
     *
     * @param record
     * @return
     */
    int reassign(@Param("record") PtmProjectCard record);

    /**
     * 判断指定的项目卡是否存在
     *
     * @param projectCardId
     * @return
     */
    int exists(@Param("projectCardId") Long projectCardId);

    /**
     * 将项目标记为已过期 expired=1
     *
     * @param projectCodeList
     */
    int markProjectExpired(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

    /**
     * 将项目标记为已过期 expired=1
     *
     * @param projectCodeList
     */
    int markProjectNoExpired(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

    /**
     * 彻底删除ptm项目数据
     *
     *
     * @param tenantId
     * @param projectCodeList
     * @return
     */
    void clearPtmProjectBacklogCompletely(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

    /**
     * 彻底删除ptm项目数据-临时测试
     *
     *
     * @param tenantId
     * @param projectCodeList
     * @return
     */
    void clearPtmProjectBacklogCompletelyOld(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

    /**
     * 根据租户查询项目
     *
     * @Author：SYQ
     * @Date：2022/9/9 10:19
     */
    List<PtmProjectCard> getProjectsByTenantId(String tenantId);

    /**
     * 查询项目
     *
     * @Author：SYQ
     * @Date：2022/10/9 13:57
     */
    List<QueryTaskVO> queryTask(Map<String, Object> parameter);

    /**
     * 恢复项目卡
     *
     * @param id
     * @param tenantId
     * @return
     */
    int updateState(@Param("id") Long id, @Param("tenantId") String tenantId);

    /**
     * 测试查询后面会删掉-临时测试
     *
     * @param projectCodeList
     * @param tenantId
     * @return
     */
    List<Long> selectPtmProjectBacklogCompletelyOld(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);
    /**
     * 测试查询后面会删掉-临时测试
     *
     * @param projectCodeList
     * @param tenantId
     * @return
     */
    List<Long> selectPtmProjectBacklogCompletely(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

}
