package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.infrastructure.utils.MySqlJsonArrayHandler;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import com.digiwin.athena.atmc.http.handler.MySqlJsonHandler;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors; 
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.time.LocalDateTime; 

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class BpmActivity extends BaseEntity<BpmActivity> {
    /**
     *
     */
    private static final long serialVersionUID = -799569784820162198L;

    @TableId()
    private Long id;

    private Long bpmProcessId;

    private String processSerialNumber;

    /**
     * bpm推送过来的themeMap中的任务ID
     */
    private String activityId;

    /**
     * bpm推送过来的themeMap中的任务名称
     * 暂不使用，仅记录BPM的原始数据
     */
    private String activityName;

    private LocalDateTime createTime;

    private LocalDateTime closedTime;

    private String bpmnType;

    private Integer state;
    @TableField(typeHandler = MySqlJsonArrayHandler.class)
    private JSONArray performerId;

    /**
     * BPM传过来的查询数据，优先使用 bpm_activity_step.data
     * 如果 bpm_activity_step.data 没有值，或没有对应的 bpm_activity_step 记录，则使用该 data
     */
    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject data;

    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject businessUnit;

    /**
     * 是否有异常
     */
    private boolean exception;

    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject bpmSignReason;

    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject stateData;

    /**
     * 任务的原始待办Id
     */
    private Long originalBacklogId;

    /**
     * ---- 已废弃,不需要该字段。，zhujg,2021-08-05
     * ---- 迭代19从mysql删除，否则迭代8上正式区的时候需要切库
     *
     * 0	未開始
     * 0	進行中
     * 0	暫停
     * 10	正常完成
     * 20	終止項目而關閉
     * 50	往前加簽而關閉
     * 60	退回重签而關閉
     * 70	取回重辦而關閉
     * 80	強制終止
     * 90	項目被撤銷而關閉
     * 100	其他任務已處理完成而關閉
     * 120	退回重辦而關閉
     */
//    private Integer subState;

    /**
     * 所属任务id
     * 租户内唯一
     */
    private String taskUid;

    /**
     * 上个任务实例id
     * 租户内唯一
     */
    private String sourceTaskUid;

    /**
     * 引擎类型
     */
    private String engineType;

    /**
     * 任务的计划结束时间。有可能为null,例如预测关卡
     */
    private LocalDateTime planEndTime;

    /**
     * 直接取自theemMap的任务名称，作为任务对外显示的名称，支持多语言
     * 也有可能是bpm的data推过来的名称，优先使用 bpm.data.atmcTaskName
     */
    private String tmActivityName;

    /**
     * 任务引擎：任务类别。execution，manual，notice，approve
     */
    private String taskType;

    /**
     * 代理 token
     * 优先使用此代理token，如果没有，则使用bpm_process.proxy_token
     */
    private String proxyToken;
}