package com.digiwin.athena.atmc.common.domain.approval;

import com.digiwin.athena.appcore.domain.LanguageMark;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ApprovalActivityDTO {

    private Long id;

    private String bpmActivityId;

    @LanguageMark
    private String bpmActivityName;

    private Integer state;

    private List<ApprovalStepDTO> steps;

    /**
     * steps和workitemList二者只有一个
     */
    private List<ApprovalWorkItemDTO> workitemList;

    //是否退回，表示当前关卡是由别人退回的
    private Boolean isReexecute = false;

    //是否撤回，表示当前关卡是撤回的
    private Boolean isAbortTask = false;

}
