package com.digiwin.athena.atmc.common.domain.approval;

import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import com.digiwin.athena.atmc.common.enums.WorkitemCreateType;
import com.digiwin.athena.atmc.http.restful.ptm.model.ApprovelAttachmentDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONArray;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * bpm_activity_workitem 的签核历程UI实体
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ApprovalWorkItemDTO  {

    private Long id;

    private LocalDateTime createTime;
    private LocalDateTime closedTime;

    private String performerId;
    private String performerName;

    private String workitemId;
    private String comment;

    private Integer state;

    //代理人ID
    private String agentPerformerId;
    private String agentPerformerName;

    //是否代理人执行，0-非代理人，1-代理人，2-辅助执行得
    private Integer performerType = 0;

    private Integer subState;

    private Integer createType = 0;

    //要删除
    private JSONArray reassign = new JSONArray();

    /**
     * 转派、加签等来源信息
     */
    private From from;

    /**
     * 签名图章
     */
    private String signaturePicture;

    /**
     * 代理人签名图章
     */
    private String agentSignaturePicture;

    /**
     * 附件信息
     */
    private List<ApprovelAttachmentDTO> attachments;

    public static ApprovalWorkItemDTO fromBpmActivityWorkitem(BpmActivityWorkitem workitem){
        ApprovalWorkItemDTO dto = ApprovalWorkItemDTO.builder()
                .id(workitem.getId())
                .createTime(workitem.getCreateTime())
                .closedTime(workitem.getClosedTime())
                .performerId(workitem.getPerformerId())
                .performerName(workitem.getPerformerName())
                .workitemId(workitem.getWorkitemId())
                .comment(workitem.getComment())
                .state(workitem.getState())
                .agentPerformerId(workitem.getAgentPerformerId())
                .agentPerformerName(workitem.getAgentPerformerName())
                .performerType(workitem.getPerformerType())
                .subState(workitem.getSubState())
                .createType(workitem.getCreateType())
                .reassign(new JSONArray())
                .build();

        if(!CollectionUtils.isEmpty(workitem.getReassign())){
            //设置转派标志
            dto.setCreateType(WorkitemCreateType.REASSIGN.getValue());
        }
        return dto;
    }

    /**
     * 来源信息
     */
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class From{
        private String performerId;
        private String performerName;
        private String comment;
    }}
