package com.digiwin.athena.atmc.common.domain.backlog;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true)
public class CardAbstractDTO {

    public static final String SOURCE_TYPE_API = "api";

    public static final String SOURCE_TYPE_BPM = "bpm";

    /**
     * 是否需要历史数据
     */
    private Boolean needHistoryInfo;

    /**
     *  卡片id
     */
    private Long cardId;

    /**
     * 是否需要业务数据
     */
    private Boolean needBusinessMessage;

    /**
     * 来源类型，api/bpm；若为api或空，则业务数据只查api（默认）；
     */
    private String businessMessageSourceType;

    private Integer count;
    /**
     *  是否强制查询api
     */
    private boolean enableQueryApi = true;

}
