package com.digiwin.athena.atmc.common.domain.backlog;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnRuleDTO {

    private String taskDefCode;

    private List<Rule> columns;

    public List<ColumnRuleDTO> buildColumnRuleDTOList(Object obj,String locale) {
        try {
            JSONArray jsonArray = JSONUtil.parseArray(obj);
            List<ColumnRuleDTO> columnRuleDTOS = JSONUtil.toList(jsonArray, ColumnRuleDTO.class);
            columnRuleDTOS.forEach(e->e.getColumns().stream().forEach(p->dealLang(p,locale)));
            return columnRuleDTOS;
        } catch (ClassCastException e) {
            return new ArrayList<>();
        }
    }

    public void removeSystemKey(List<ColumnRuleDTO> list) {
        for (ColumnRuleDTO next : list) {
            next.getColumns().removeIf(next1 -> !"businessKey".equals(next1.getType()));
        }
    }

    private void dealLang(Rule rule,String locale) {
        String name = ((Map<String, String>) rule.getLang().get("name")).get(locale);
        rule.setName(name);
        rule.setLang(null);
        rule.setLanguage(null);
    }


    public String getTaskDefCode() {
        return taskDefCode;
    }

    public void setTaskDefCode(String taskDefCode) {
        this.taskDefCode = taskDefCode;
    }

    public List<Rule> getColumns() {
        return columns;
    }

    public void setColumns(List<Rule> columns) {
        this.columns = columns;
    }

    private class Rule{

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        private String key;

        private String name;

        private String order;

        private String isShow;

        private Map language;

        private Map lang;

        private String type;

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOrder() {
            return order;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getIsShow() {
            return isShow;
        }

        public void setIsShow(String isShow) {
            this.isShow = isShow;
        }

        public Map getLanguage() {
            return language;
        }

        public void setLanguage(Map language) {
            this.language = language;
        }

        public Map getLang() {
            return lang;
        }

        public void setLang(Map lang) {
            this.lang = lang;
        }
    }


}
