package com.digiwin.athena.atmc.common.domain.bpm;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class BpmStepWorkitemDTO {
    private String workitemId;
    private String performerId;
    private String comment;
    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private Integer state;

    /**
     * 仅用于流程引擎
     */
    private List<BpmWorkitemReassignDTO> reassign;

    //代理人ID
    private String agentPerformerId;

    //是否代理人执行，0-非代理人，1-代理人，999-任务引擎执行时不验证执行人,场景二，适用于目标租户下的执行人
    private Integer performerType = 0;

    private Integer subState;

    /**
     * 取值 0=正常产生/1=转派/2=退回重签/3=退回重办/4=加签
     */
    private Integer createType = 0;

    /**
     * 仅用于任务引擎
     * 1=转派/2=退回重签/4=加签等任务的来源任务workitemId
     */
    private String fromWorkitemId;

    /**
     * 协作厂商、企业用户的执行人ID,与BPM无关
     */
    private String commonPerformerId;

}
